/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Blob;
import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Console;
import com.xensource.xenapi.Crashdump;
import com.xensource.xenapi.DataSource;
import com.xensource.xenapi.Host;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.Network;
import com.xensource.xenapi.PCI;
import com.xensource.xenapi.SR;
import com.xensource.xenapi.Session;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VBD;
import com.xensource.xenapi.VDI;
import com.xensource.xenapi.VGPU;
import com.xensource.xenapi.VIF;
import com.xensource.xenapi.VMAppliance;
import com.xensource.xenapi.VMGuestMetrics;
import com.xensource.xenapi.VMMetrics;
import com.xensource.xenapi.VMPP;
import com.xensource.xenapi.VTPM;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

public class VM
extends XenAPIObject {
    protected final String ref;

    VM(String string) {
        this.ref = string;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof VM) {
            VM vM = (VM)object;
            return vM.ref.equals(this.ref);
        }
        return false;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public Record getRecord(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_record";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVMRecord(v);
    }

    public static VM getByUuid(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.get_by_uuid";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toVM(v);
    }

    public static Task createAsync(Connection connection, Record record) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.create";
        String string2 = connection.getSessionReference();
        Map<String, Object> map = record.toMap();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
        Object v = map2.get("Value");
        return Types.toTask(v);
    }

    public static VM create(Connection connection, Record record) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.create";
        String string2 = connection.getSessionReference();
        Map<String, Object> map = record.toMap();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
        Object v = map2.get("Value");
        return Types.toVM(v);
    }

    public Task destroyAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void destroy(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Set<VM> getByNameLabel(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.get_by_name_label";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVM(v);
    }

    public String getUuid(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_uuid";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Set<Types.VmOperations> getAllowedOperations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_allowed_operations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVmOperations(v);
    }

    public Map<String, Types.VmOperations> getCurrentOperations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_current_operations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringVmOperations(v);
    }

    public Types.VmPowerState getPowerState(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_power_state";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVmPowerState(v);
    }

    public String getNameLabel(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_name_label";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getNameDescription(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_name_description";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Long getUserVersion(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_user_version";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Boolean getIsATemplate(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_is_a_template";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public VDI getSuspendVDI(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_suspend_VDI";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVDI(v);
    }

    public Host getResidentOn(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_resident_on";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toHost(v);
    }

    public Host getAffinity(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_affinity";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toHost(v);
    }

    public Long getMemoryOverhead(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_memory_overhead";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    @Deprecated
    public Long getMemoryTarget(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_memory_target";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Long getMemoryStaticMax(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_memory_static_max";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Long getMemoryDynamicMax(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_memory_dynamic_max";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Long getMemoryDynamicMin(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_memory_dynamic_min";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Long getMemoryStaticMin(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_memory_static_min";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Map<String, String> getVCPUsParams(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_VCPUs_params";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Long getVCPUsMax(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_VCPUs_max";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Long getVCPUsAtStartup(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_VCPUs_at_startup";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Types.OnNormalExit getActionsAfterShutdown(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_actions_after_shutdown";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toOnNormalExit(v);
    }

    public Types.OnNormalExit getActionsAfterReboot(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_actions_after_reboot";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toOnNormalExit(v);
    }

    public Types.OnCrashBehaviour getActionsAfterCrash(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_actions_after_crash";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toOnCrashBehaviour(v);
    }

    public Set<Console> getConsoles(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_consoles";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfConsole(v);
    }

    public Set<VIF> getVIFs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_VIFs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVIF(v);
    }

    public Set<VBD> getVBDs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_VBDs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVBD(v);
    }

    public Set<Crashdump> getCrashDumps(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_crash_dumps";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfCrashdump(v);
    }

    public Set<VTPM> getVTPMs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_VTPMs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVTPM(v);
    }

    public String getPVBootloader(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_PV_bootloader";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getPVKernel(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_PV_kernel";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getPVRamdisk(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_PV_ramdisk";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getPVArgs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_PV_args";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getPVBootloaderArgs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_PV_bootloader_args";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getPVLegacyArgs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_PV_legacy_args";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getHVMBootPolicy(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_HVM_boot_policy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Map<String, String> getHVMBootParams(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_HVM_boot_params";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Double getHVMShadowMultiplier(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_HVM_shadow_multiplier";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toDouble(v);
    }

    public Map<String, String> getPlatform(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_platform";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    @Deprecated
    public String getPCIBus(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_PCI_bus";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Map<String, String> getOtherConfig(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Long getDomid(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_domid";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public String getDomarch(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_domarch";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Map<String, String> getLastBootCPUFlags(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_last_boot_CPU_flags";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Boolean getIsControlDomain(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_is_control_domain";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public VMMetrics getMetrics(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_metrics";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVMMetrics(v);
    }

    public VMGuestMetrics getGuestMetrics(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_guest_metrics";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVMGuestMetrics(v);
    }

    public String getLastBootedRecord(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_last_booted_record";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getRecommendations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_recommendations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Map<String, String> getXenstoreData(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_xenstore_data";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    @Deprecated
    public Boolean getHaAlwaysRun(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_ha_always_run";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public String getHaRestartPriority(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_ha_restart_priority";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Boolean getIsASnapshot(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_is_a_snapshot";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public VM getSnapshotOf(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_snapshot_of";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVM(v);
    }

    public Set<VM> getSnapshots(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_snapshots";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVM(v);
    }

    public Date getSnapshotTime(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_snapshot_time";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toDate(v);
    }

    public String getTransportableSnapshotId(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_transportable_snapshot_id";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Map<String, Blob> getBlobs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_blobs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringBlob(v);
    }

    public Set<String> getTags(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_tags";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public Map<Types.VmOperations, String> getBlockedOperations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_blocked_operations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfVmOperationsString(v);
    }

    public Map<String, String> getSnapshotInfo(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_snapshot_info";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public String getSnapshotMetadata(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_snapshot_metadata";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public VM getParent(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_parent";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVM(v);
    }

    public Set<VM> getChildren(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_children";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVM(v);
    }

    public Map<String, String> getBiosStrings(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_bios_strings";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    @Deprecated
    public VMPP getProtectionPolicy(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_protection_policy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVMPP(v);
    }

    @Deprecated
    public Boolean getIsSnapshotFromVmpp(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_is_snapshot_from_vmpp";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public VMAppliance getAppliance(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_appliance";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVMAppliance(v);
    }

    public Long getStartDelay(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_start_delay";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Long getShutdownDelay(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_shutdown_delay";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Long getOrder(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_order";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Set<VGPU> getVGPUs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_VGPUs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVGPU(v);
    }

    public Set<PCI> getAttachedPCIs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_attached_PCIs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPCI(v);
    }

    public SR getSuspendSR(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_suspend_SR";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSR(v);
    }

    public Long getVersion(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_version";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public String getGenerationId(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_generation_id";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public void setNameLabel(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.set_name_label";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setNameDescription(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.set_name_description";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setUserVersion(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_user_version";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setIsATemplate(Connection connection, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_is_a_template";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setAffinity(Connection connection, Host host) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_affinity";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setVCPUsParams(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_VCPUs_params";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToVCPUsParams(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "VM.add_to_VCPUs_params";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromVCPUsParams(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.remove_from_VCPUs_params";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setActionsAfterShutdown(Connection connection, Types.OnNormalExit onNormalExit) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_actions_after_shutdown";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)onNormalExit)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setActionsAfterReboot(Connection connection, Types.OnNormalExit onNormalExit) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_actions_after_reboot";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)onNormalExit)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setActionsAfterCrash(Connection connection, Types.OnCrashBehaviour onCrashBehaviour) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_actions_after_crash";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)onCrashBehaviour)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setPVBootloader(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.set_PV_bootloader";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setPVKernel(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.set_PV_kernel";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setPVRamdisk(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.set_PV_ramdisk";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setPVArgs(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.set_PV_args";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setPVBootloaderArgs(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.set_PV_bootloader_args";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setPVLegacyArgs(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.set_PV_legacy_args";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setHVMBootPolicy(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.set_HVM_boot_policy";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setHVMBootParams(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_HVM_boot_params";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToHVMBootParams(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "VM.add_to_HVM_boot_params";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromHVMBootParams(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.remove_from_HVM_boot_params";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setPlatform(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_platform";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToPlatform(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "VM.add_to_platform";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromPlatform(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.remove_from_platform";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    @Deprecated
    public void setPCIBus(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.set_PCI_bus";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setOtherConfig(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToOtherConfig(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "VM.add_to_other_config";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromOtherConfig(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.remove_from_other_config";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setRecommendations(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.set_recommendations";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setXenstoreData(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_xenstore_data";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToXenstoreData(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "VM.add_to_xenstore_data";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromXenstoreData(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.remove_from_xenstore_data";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setTags(Connection connection, Set<String> set) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_tags";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(set)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void addTags(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.add_tags";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void removeTags(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.remove_tags";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setBlockedOperations(Connection connection, Map<Types.VmOperations, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_blocked_operations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToBlockedOperations(Connection connection, Types.VmOperations vmOperations, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.add_to_blocked_operations";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)vmOperations), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void removeFromBlockedOperations(Connection connection, Types.VmOperations vmOperations) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.remove_from_blocked_operations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)vmOperations)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setSuspendSR(Connection connection, SR sR) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_suspend_SR";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(sR)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task snapshotAsync(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed {
        String string2 = "Async.VM.snapshot";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public VM snapshot(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed {
        String string2 = "VM.snapshot";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toVM(v);
    }

    public Task snapshotWithQuiesceAsync(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed, Types.VmSnapshotWithQuiesceFailed, Types.VmSnapshotWithQuiesceTimeout, Types.VmSnapshotWithQuiescePluginDeosNotRespond, Types.VmSnapshotWithQuiesceNotSupported {
        String string2 = "Async.VM.snapshot_with_quiesce";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public VM snapshotWithQuiesce(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed, Types.VmSnapshotWithQuiesceFailed, Types.VmSnapshotWithQuiesceTimeout, Types.VmSnapshotWithQuiescePluginDeosNotRespond, Types.VmSnapshotWithQuiesceNotSupported {
        String string2 = "VM.snapshot_with_quiesce";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toVM(v);
    }

    public Task createCloneAsync(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed {
        String string2 = "Async.VM.clone";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public VM createClone(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed {
        String string2 = "VM.clone";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toVM(v);
    }

    public Task copyAsync(Connection connection, String string, SR sR) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed {
        String string2 = "Async.VM.copy";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(sR)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public VM copy(Connection connection, String string, SR sR) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed {
        String string2 = "VM.copy";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(sR)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toVM(v);
    }

    public Task revertAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OperationNotAllowed, Types.SrFull, Types.VmRevertFailed {
        String string = "Async.VM.revert";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void revert(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OperationNotAllowed, Types.SrFull, Types.VmRevertFailed {
        String string = "VM.revert";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task checkpointAsync(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed, Types.VmCheckpointSuspendFailed, Types.VmCheckpointResumeFailed {
        String string2 = "Async.VM.checkpoint";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public VM checkpoint(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed, Types.VmCheckpointSuspendFailed, Types.VmCheckpointResumeFailed {
        String string2 = "VM.checkpoint";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toVM(v);
    }

    public Task provisionAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed {
        String string = "Async.VM.provision";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void provision(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.SrFull, Types.OperationNotAllowed {
        String string = "VM.provision";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task startAsync(Connection connection, Boolean bl, Boolean bl2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.VmHvmRequired, Types.VmIsTemplate, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.BootloaderFailed, Types.UnknownBootloader, Types.NoHostsAvailable, Types.LicenceRestriction {
        String string = "Async.VM.start";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC(bl2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void start(Connection connection, Boolean bl, Boolean bl2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.VmHvmRequired, Types.VmIsTemplate, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.BootloaderFailed, Types.UnknownBootloader, Types.NoHostsAvailable, Types.LicenceRestriction {
        String string = "VM.start";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC(bl2)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task startOnAsync(Connection connection, Host host, Boolean bl, Boolean bl2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.VmIsTemplate, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.BootloaderFailed, Types.UnknownBootloader {
        String string = "Async.VM.start_on";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC(bl2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void startOn(Connection connection, Host host, Boolean bl, Boolean bl2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.VmIsTemplate, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.BootloaderFailed, Types.UnknownBootloader {
        String string = "VM.start_on";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC(bl2)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task pauseAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "Async.VM.pause";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void pause(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "VM.pause";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task unpauseAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "Async.VM.unpause";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void unpause(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "VM.unpause";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task cleanShutdownAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "Async.VM.clean_shutdown";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void cleanShutdown(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "VM.clean_shutdown";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task shutdownAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "Async.VM.shutdown";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void shutdown(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "VM.shutdown";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task cleanRebootAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "Async.VM.clean_reboot";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void cleanReboot(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "VM.clean_reboot";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task hardShutdownAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "Async.VM.hard_shutdown";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void hardShutdown(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "VM.hard_shutdown";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task powerStateResetAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.power_state_reset";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void powerStateReset(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.power_state_reset";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task hardRebootAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "Async.VM.hard_reboot";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void hardReboot(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "VM.hard_reboot";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task suspendAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "Async.VM.suspend";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void suspend(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "VM.suspend";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task resumeAsync(Connection connection, Boolean bl, Boolean bl2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "Async.VM.resume";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC(bl2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void resume(Connection connection, Boolean bl, Boolean bl2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "VM.resume";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC(bl2)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task resumeOnAsync(Connection connection, Host host, Boolean bl, Boolean bl2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "Async.VM.resume_on";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC(bl2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void resumeOn(Connection connection, Host host, Boolean bl, Boolean bl2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OperationNotAllowed, Types.VmIsTemplate {
        String string = "VM.resume_on";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC(bl2)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task poolMigrateAsync(Connection connection, Host host, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.VmIsTemplate, Types.OperationNotAllowed, Types.VmMigrateFailed, Types.VmMissingPvDrivers {
        String string = "Async.VM.pool_migrate";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
        Object v = map2.get("Value");
        return Types.toTask(v);
    }

    public void poolMigrate(Connection connection, Host host, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState, Types.OtherOperationInProgress, Types.VmIsTemplate, Types.OperationNotAllowed, Types.VmMigrateFailed, Types.VmMissingPvDrivers {
        String string = "VM.pool_migrate";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public Task setVCPUsNumberLiveAsync(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.set_VCPUs_number_live";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void setVCPUsNumberLive(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_VCPUs_number_live";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task addToVCPUsParamsLiveAsync(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "Async.VM.add_to_VCPUs_params_live";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void addToVCPUsParamsLive(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "VM.add_to_VCPUs_params_live";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void setHaRestartPriority(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.set_ha_restart_priority";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    @Deprecated
    public void setHaAlwaysRun(Connection connection, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_ha_always_run";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task computeMemoryOverheadAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.compute_memory_overhead";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Long computeMemoryOverhead(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.compute_memory_overhead";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public void setMemoryDynamicMax(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_memory_dynamic_max";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setMemoryDynamicMin(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_memory_dynamic_min";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task setMemoryDynamicRangeAsync(Connection connection, Long l, Long l2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.set_memory_dynamic_range";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l), Marshalling.toXMLRPC(l2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void setMemoryDynamicRange(Connection connection, Long l, Long l2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_memory_dynamic_range";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l), Marshalling.toXMLRPC(l2)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setMemoryStaticMax(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.HaOperationWouldBreakFailoverPlan {
        String string = "VM.set_memory_static_max";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setMemoryStaticMin(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_memory_static_min";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task setMemoryStaticRangeAsync(Connection connection, Long l, Long l2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.set_memory_static_range";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l), Marshalling.toXMLRPC(l2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void setMemoryStaticRange(Connection connection, Long l, Long l2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_memory_static_range";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l), Marshalling.toXMLRPC(l2)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task setMemoryLimitsAsync(Connection connection, Long l, Long l2, Long l3, Long l4) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.set_memory_limits";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l), Marshalling.toXMLRPC(l2), Marshalling.toXMLRPC(l3), Marshalling.toXMLRPC(l4)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void setMemoryLimits(Connection connection, Long l, Long l2, Long l3, Long l4) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_memory_limits";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l), Marshalling.toXMLRPC(l2), Marshalling.toXMLRPC(l3), Marshalling.toXMLRPC(l4)};
        Map map = connection.dispatch(string, objectArray);
    }

    @Deprecated
    public Task setMemoryTargetLiveAsync(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.set_memory_target_live";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    @Deprecated
    public void setMemoryTargetLive(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_memory_target_live";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    @Deprecated
    public Task waitMemoryTargetLiveAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.wait_memory_target_live";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    @Deprecated
    public void waitMemoryTargetLive(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.wait_memory_target_live";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    @Deprecated
    public Task getCooperativeAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.get_cooperative";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    @Deprecated
    public Boolean getCooperative(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_cooperative";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public void setHVMShadowMultiplier(Connection connection, Double d) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_HVM_shadow_multiplier";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(d)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task setShadowMultiplierLiveAsync(Connection connection, Double d) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.set_shadow_multiplier_live";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(d)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void setShadowMultiplierLive(Connection connection, Double d) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_shadow_multiplier_live";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(d)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setVCPUsMax(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_VCPUs_max";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setVCPUsAtStartup(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_VCPUs_at_startup";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task sendSysrqAsync(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState {
        String string2 = "Async.VM.send_sysrq";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void sendSysrq(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState {
        String string2 = "VM.send_sysrq";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public Task sendTriggerAsync(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState {
        String string2 = "Async.VM.send_trigger";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void sendTrigger(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState {
        String string2 = "VM.send_trigger";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public Task maximiseMemoryAsync(Connection connection, Long l, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.maximise_memory";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Long maximiseMemory(Connection connection, Long l, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.maximise_memory";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Task migrateSendAsync(Connection connection, Map<String, String> map, Boolean bl, Map<VDI, SR> map2, Map<VIF, Network> map3, Map<String, String> map4) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState {
        String string = "Async.VM.migrate_send";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC(map2), Marshalling.toXMLRPC(map3), Marshalling.toXMLRPC(map4)};
        Map map5 = connection.dispatch(string, objectArray);
        Object v = map5.get("Value");
        return Types.toTask(v);
    }

    public void migrateSend(Connection connection, Map<String, String> map, Boolean bl, Map<VDI, SR> map2, Map<VIF, Network> map3, Map<String, String> map4) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmBadPowerState {
        String string = "VM.migrate_send";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC(map2), Marshalling.toXMLRPC(map3), Marshalling.toXMLRPC(map4)};
        Map map5 = connection.dispatch(string, objectArray);
    }

    public Task assertCanMigrateAsync(Connection connection, Map<String, String> map, Boolean bl, Map<VDI, SR> map2, Map<VIF, Network> map3, Map<String, String> map4) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.assert_can_migrate";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC(map2), Marshalling.toXMLRPC(map3), Marshalling.toXMLRPC(map4)};
        Map map5 = connection.dispatch(string, objectArray);
        Object v = map5.get("Value");
        return Types.toTask(v);
    }

    public void assertCanMigrate(Connection connection, Map<String, String> map, Boolean bl, Map<VDI, SR> map2, Map<VIF, Network> map3, Map<String, String> map4) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.assert_can_migrate";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC(map2), Marshalling.toXMLRPC(map3), Marshalling.toXMLRPC(map4)};
        Map map5 = connection.dispatch(string, objectArray);
    }

    public Record getBootRecord(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_boot_record";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVMRecord(v);
    }

    public Set<DataSource.Record> getDataSources(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_data_sources";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfDataSourceRecord(v);
    }

    public void recordDataSource(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.record_data_source";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public Double queryDataSource(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.query_data_source";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toDouble(v);
    }

    public void forgetDataSourceArchives(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VM.forget_data_source_archives";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public Task assertOperationValidAsync(Connection connection, Types.VmOperations vmOperations) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.assert_operation_valid";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)vmOperations)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void assertOperationValid(Connection connection, Types.VmOperations vmOperations) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.assert_operation_valid";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)vmOperations)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task updateAllowedOperationsAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.update_allowed_operations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void updateAllowedOperations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.update_allowed_operations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Set<String> getAllowedVBDDevices(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_allowed_VBD_devices";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public Set<String> getAllowedVIFDevices(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_allowed_VIF_devices";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public Task getPossibleHostsAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.get_possible_hosts";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Set<Host> getPossibleHosts(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_possible_hosts";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfHost(v);
    }

    public Task assertCanBootHereAsync(Connection connection, Host host) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.HostNotEnoughFreeMemory, Types.VmRequiresSr, Types.VmHostIncompatibleVersion {
        String string = "Async.VM.assert_can_boot_here";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void assertCanBootHere(Connection connection, Host host) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.HostNotEnoughFreeMemory, Types.VmRequiresSr, Types.VmHostIncompatibleVersion {
        String string = "VM.assert_can_boot_here";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task createNewBlobAsync(Connection connection, String string, String string2, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "Async.VM.create_new_blob";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Blob createNewBlob(Connection connection, String string, String string2, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "VM.create_new_blob";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toBlob(v);
    }

    public Task assertAgileAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.assert_agile";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void assertAgile(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.assert_agile";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task retrieveWlbRecommendationsAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.retrieve_wlb_recommendations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Map<Host, Set<String>> retrieveWlbRecommendations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.retrieve_wlb_recommendations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfHostSetOfString(v);
    }

    public Task copyBiosStringsAsync(Connection connection, Host host) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.copy_bios_strings";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void copyBiosStrings(Connection connection, Host host) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.copy_bios_strings";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(host)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setProtectionPolicy(Connection connection, VMPP vMPP) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_protection_policy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(vMPP)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task setStartDelayAsync(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.set_start_delay";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void setStartDelay(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_start_delay";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task setShutdownDelayAsync(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.set_shutdown_delay";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void setShutdownDelay(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_shutdown_delay";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task setOrderAsync(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.set_order";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void setOrder(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_order";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task setSuspendVDIAsync(Connection connection, VDI vDI) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.set_suspend_VDI";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(vDI)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void setSuspendVDI(Connection connection, VDI vDI) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_suspend_VDI";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(vDI)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task assertCanBeRecoveredAsync(Connection connection, Session session) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmIsPartOfAnAppliance, Types.VmRequiresSr {
        String string = "Async.VM.assert_can_be_recovered";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(session)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void assertCanBeRecovered(Connection connection, Session session) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VmIsPartOfAnAppliance, Types.VmRequiresSr {
        String string = "VM.assert_can_be_recovered";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(session)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task recoverAsync(Connection connection, Session session, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.recover";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void recover(Connection connection, Session session, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.recover";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(session), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Task importConvertAsync(Connection connection, String string, String string2, String string3, SR sR, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string4 = "Async.VM.import_convert";
        String string5 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string5), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(sR), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string4, objectArray);
        Object v = map2.get("Value");
        return Types.toTask(v);
    }

    public static void importConvert(Connection connection, String string, String string2, String string3, SR sR, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string4 = "VM.import_convert";
        String string5 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string5), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(sR), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string4, objectArray);
    }

    public Task setApplianceAsync(Connection connection, VMAppliance vMAppliance) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.set_appliance";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(vMAppliance)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void setAppliance(Connection connection, VMAppliance vMAppliance) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.set_appliance";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(vMAppliance)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task queryServicesAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VM.query_services";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Map<String, String> queryServices(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.query_services";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public static Set<VM> getAll(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_all";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVM(v);
    }

    public static Map<VM, Record> getAllRecords(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VM.get_all_records";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfVMVMRecord(v);
    }

    public static class Record
    implements Types.Record {
        public String uuid;
        public Set<Types.VmOperations> allowedOperations;
        public Map<String, Types.VmOperations> currentOperations;
        public Types.VmPowerState powerState;
        public String nameLabel;
        public String nameDescription;
        public Long userVersion;
        public Boolean isATemplate;
        public VDI suspendVDI;
        public Host residentOn;
        public Host affinity;
        public Long memoryOverhead;
        public Long memoryTarget;
        public Long memoryStaticMax;
        public Long memoryDynamicMax;
        public Long memoryDynamicMin;
        public Long memoryStaticMin;
        public Map<String, String> VCPUsParams;
        public Long VCPUsMax;
        public Long VCPUsAtStartup;
        public Types.OnNormalExit actionsAfterShutdown;
        public Types.OnNormalExit actionsAfterReboot;
        public Types.OnCrashBehaviour actionsAfterCrash;
        public Set<Console> consoles;
        public Set<VIF> VIFs;
        public Set<VBD> VBDs;
        public Set<Crashdump> crashDumps;
        public Set<VTPM> VTPMs;
        public String PVBootloader;
        public String PVKernel;
        public String PVRamdisk;
        public String PVArgs;
        public String PVBootloaderArgs;
        public String PVLegacyArgs;
        public String HVMBootPolicy;
        public Map<String, String> HVMBootParams;
        public Double HVMShadowMultiplier;
        public Map<String, String> platform;
        public String PCIBus;
        public Map<String, String> otherConfig;
        public Long domid;
        public String domarch;
        public Map<String, String> lastBootCPUFlags;
        public Boolean isControlDomain;
        public VMMetrics metrics;
        public VMGuestMetrics guestMetrics;
        public String lastBootedRecord;
        public String recommendations;
        public Map<String, String> xenstoreData;
        public Boolean haAlwaysRun;
        public String haRestartPriority;
        public Boolean isASnapshot;
        public VM snapshotOf;
        public Set<VM> snapshots;
        public Date snapshotTime;
        public String transportableSnapshotId;
        public Map<String, Blob> blobs;
        public Set<String> tags;
        public Map<Types.VmOperations, String> blockedOperations;
        public Map<String, String> snapshotInfo;
        public String snapshotMetadata;
        public VM parent;
        public Set<VM> children;
        public Map<String, String> biosStrings;
        public VMPP protectionPolicy;
        public Boolean isSnapshotFromVmpp;
        public VMAppliance appliance;
        public Long startDelay;
        public Long shutdownDelay;
        public Long order;
        public Set<VGPU> VGPUs;
        public Set<PCI> attachedPCIs;
        public SR suspendSR;
        public Long version;
        public String generationId;

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            printWriter.printf("%1$20s: %2$s\n", "allowedOperations", this.allowedOperations);
            printWriter.printf("%1$20s: %2$s\n", "currentOperations", this.currentOperations);
            printWriter.printf("%1$20s: %2$s\n", new Object[]{"powerState", this.powerState});
            printWriter.printf("%1$20s: %2$s\n", "nameLabel", this.nameLabel);
            printWriter.printf("%1$20s: %2$s\n", "nameDescription", this.nameDescription);
            printWriter.printf("%1$20s: %2$s\n", "userVersion", this.userVersion);
            printWriter.printf("%1$20s: %2$s\n", "isATemplate", this.isATemplate);
            printWriter.printf("%1$20s: %2$s\n", "suspendVDI", this.suspendVDI);
            printWriter.printf("%1$20s: %2$s\n", "residentOn", this.residentOn);
            printWriter.printf("%1$20s: %2$s\n", "affinity", this.affinity);
            printWriter.printf("%1$20s: %2$s\n", "memoryOverhead", this.memoryOverhead);
            printWriter.printf("%1$20s: %2$s\n", "memoryTarget", this.memoryTarget);
            printWriter.printf("%1$20s: %2$s\n", "memoryStaticMax", this.memoryStaticMax);
            printWriter.printf("%1$20s: %2$s\n", "memoryDynamicMax", this.memoryDynamicMax);
            printWriter.printf("%1$20s: %2$s\n", "memoryDynamicMin", this.memoryDynamicMin);
            printWriter.printf("%1$20s: %2$s\n", "memoryStaticMin", this.memoryStaticMin);
            printWriter.printf("%1$20s: %2$s\n", "VCPUsParams", this.VCPUsParams);
            printWriter.printf("%1$20s: %2$s\n", "VCPUsMax", this.VCPUsMax);
            printWriter.printf("%1$20s: %2$s\n", "VCPUsAtStartup", this.VCPUsAtStartup);
            printWriter.printf("%1$20s: %2$s\n", new Object[]{"actionsAfterShutdown", this.actionsAfterShutdown});
            printWriter.printf("%1$20s: %2$s\n", new Object[]{"actionsAfterReboot", this.actionsAfterReboot});
            printWriter.printf("%1$20s: %2$s\n", new Object[]{"actionsAfterCrash", this.actionsAfterCrash});
            printWriter.printf("%1$20s: %2$s\n", "consoles", this.consoles);
            printWriter.printf("%1$20s: %2$s\n", "VIFs", this.VIFs);
            printWriter.printf("%1$20s: %2$s\n", "VBDs", this.VBDs);
            printWriter.printf("%1$20s: %2$s\n", "crashDumps", this.crashDumps);
            printWriter.printf("%1$20s: %2$s\n", "VTPMs", this.VTPMs);
            printWriter.printf("%1$20s: %2$s\n", "PVBootloader", this.PVBootloader);
            printWriter.printf("%1$20s: %2$s\n", "PVKernel", this.PVKernel);
            printWriter.printf("%1$20s: %2$s\n", "PVRamdisk", this.PVRamdisk);
            printWriter.printf("%1$20s: %2$s\n", "PVArgs", this.PVArgs);
            printWriter.printf("%1$20s: %2$s\n", "PVBootloaderArgs", this.PVBootloaderArgs);
            printWriter.printf("%1$20s: %2$s\n", "PVLegacyArgs", this.PVLegacyArgs);
            printWriter.printf("%1$20s: %2$s\n", "HVMBootPolicy", this.HVMBootPolicy);
            printWriter.printf("%1$20s: %2$s\n", "HVMBootParams", this.HVMBootParams);
            printWriter.printf("%1$20s: %2$s\n", "HVMShadowMultiplier", this.HVMShadowMultiplier);
            printWriter.printf("%1$20s: %2$s\n", "platform", this.platform);
            printWriter.printf("%1$20s: %2$s\n", "PCIBus", this.PCIBus);
            printWriter.printf("%1$20s: %2$s\n", "otherConfig", this.otherConfig);
            printWriter.printf("%1$20s: %2$s\n", "domid", this.domid);
            printWriter.printf("%1$20s: %2$s\n", "domarch", this.domarch);
            printWriter.printf("%1$20s: %2$s\n", "lastBootCPUFlags", this.lastBootCPUFlags);
            printWriter.printf("%1$20s: %2$s\n", "isControlDomain", this.isControlDomain);
            printWriter.printf("%1$20s: %2$s\n", "metrics", this.metrics);
            printWriter.printf("%1$20s: %2$s\n", "guestMetrics", this.guestMetrics);
            printWriter.printf("%1$20s: %2$s\n", "lastBootedRecord", this.lastBootedRecord);
            printWriter.printf("%1$20s: %2$s\n", "recommendations", this.recommendations);
            printWriter.printf("%1$20s: %2$s\n", "xenstoreData", this.xenstoreData);
            printWriter.printf("%1$20s: %2$s\n", "haAlwaysRun", this.haAlwaysRun);
            printWriter.printf("%1$20s: %2$s\n", "haRestartPriority", this.haRestartPriority);
            printWriter.printf("%1$20s: %2$s\n", "isASnapshot", this.isASnapshot);
            printWriter.printf("%1$20s: %2$s\n", "snapshotOf", this.snapshotOf);
            printWriter.printf("%1$20s: %2$s\n", "snapshots", this.snapshots);
            printWriter.printf("%1$20s: %2$s\n", "snapshotTime", this.snapshotTime);
            printWriter.printf("%1$20s: %2$s\n", "transportableSnapshotId", this.transportableSnapshotId);
            printWriter.printf("%1$20s: %2$s\n", "blobs", this.blobs);
            printWriter.printf("%1$20s: %2$s\n", "tags", this.tags);
            printWriter.printf("%1$20s: %2$s\n", "blockedOperations", this.blockedOperations);
            printWriter.printf("%1$20s: %2$s\n", "snapshotInfo", this.snapshotInfo);
            printWriter.printf("%1$20s: %2$s\n", "snapshotMetadata", this.snapshotMetadata);
            printWriter.printf("%1$20s: %2$s\n", "parent", this.parent);
            printWriter.printf("%1$20s: %2$s\n", "children", this.children);
            printWriter.printf("%1$20s: %2$s\n", "biosStrings", this.biosStrings);
            printWriter.printf("%1$20s: %2$s\n", "protectionPolicy", this.protectionPolicy);
            printWriter.printf("%1$20s: %2$s\n", "isSnapshotFromVmpp", this.isSnapshotFromVmpp);
            printWriter.printf("%1$20s: %2$s\n", "appliance", this.appliance);
            printWriter.printf("%1$20s: %2$s\n", "startDelay", this.startDelay);
            printWriter.printf("%1$20s: %2$s\n", "shutdownDelay", this.shutdownDelay);
            printWriter.printf("%1$20s: %2$s\n", "order", this.order);
            printWriter.printf("%1$20s: %2$s\n", "VGPUs", this.VGPUs);
            printWriter.printf("%1$20s: %2$s\n", "attachedPCIs", this.attachedPCIs);
            printWriter.printf("%1$20s: %2$s\n", "suspendSR", this.suspendSR);
            printWriter.printf("%1$20s: %2$s\n", "version", this.version);
            printWriter.printf("%1$20s: %2$s\n", "generationId", this.generationId);
            return stringWriter.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("uuid", this.uuid == null ? "" : this.uuid);
            hashMap.put("allowed_operations", this.allowedOperations == null ? new LinkedHashSet() : this.allowedOperations);
            hashMap.put("current_operations", this.currentOperations == null ? new HashMap() : this.currentOperations);
            hashMap.put("power_state", (Object)(this.powerState == null ? Types.VmPowerState.UNRECOGNIZED : this.powerState));
            hashMap.put("name_label", this.nameLabel == null ? "" : this.nameLabel);
            hashMap.put("name_description", this.nameDescription == null ? "" : this.nameDescription);
            hashMap.put("user_version", this.userVersion == null ? 0L : this.userVersion);
            hashMap.put("is_a_template", this.isATemplate == null ? false : this.isATemplate);
            hashMap.put("suspend_VDI", this.suspendVDI == null ? new VDI("OpaqueRef:NULL") : this.suspendVDI);
            hashMap.put("resident_on", this.residentOn == null ? new Host("OpaqueRef:NULL") : this.residentOn);
            hashMap.put("affinity", this.affinity == null ? new Host("OpaqueRef:NULL") : this.affinity);
            hashMap.put("memory_overhead", this.memoryOverhead == null ? 0L : this.memoryOverhead);
            hashMap.put("memory_target", this.memoryTarget == null ? 0L : this.memoryTarget);
            hashMap.put("memory_static_max", this.memoryStaticMax == null ? 0L : this.memoryStaticMax);
            hashMap.put("memory_dynamic_max", this.memoryDynamicMax == null ? 0L : this.memoryDynamicMax);
            hashMap.put("memory_dynamic_min", this.memoryDynamicMin == null ? 0L : this.memoryDynamicMin);
            hashMap.put("memory_static_min", this.memoryStaticMin == null ? 0L : this.memoryStaticMin);
            hashMap.put("VCPUs_params", this.VCPUsParams == null ? new HashMap() : this.VCPUsParams);
            hashMap.put("VCPUs_max", this.VCPUsMax == null ? 0L : this.VCPUsMax);
            hashMap.put("VCPUs_at_startup", this.VCPUsAtStartup == null ? 0L : this.VCPUsAtStartup);
            hashMap.put("actions_after_shutdown", (Object)(this.actionsAfterShutdown == null ? Types.OnNormalExit.UNRECOGNIZED : this.actionsAfterShutdown));
            hashMap.put("actions_after_reboot", (Object)(this.actionsAfterReboot == null ? Types.OnNormalExit.UNRECOGNIZED : this.actionsAfterReboot));
            hashMap.put("actions_after_crash", (Object)(this.actionsAfterCrash == null ? Types.OnCrashBehaviour.UNRECOGNIZED : this.actionsAfterCrash));
            hashMap.put("consoles", this.consoles == null ? new LinkedHashSet() : this.consoles);
            hashMap.put("VIFs", this.VIFs == null ? new LinkedHashSet() : this.VIFs);
            hashMap.put("VBDs", this.VBDs == null ? new LinkedHashSet() : this.VBDs);
            hashMap.put("crash_dumps", this.crashDumps == null ? new LinkedHashSet() : this.crashDumps);
            hashMap.put("VTPMs", this.VTPMs == null ? new LinkedHashSet() : this.VTPMs);
            hashMap.put("PV_bootloader", this.PVBootloader == null ? "" : this.PVBootloader);
            hashMap.put("PV_kernel", this.PVKernel == null ? "" : this.PVKernel);
            hashMap.put("PV_ramdisk", this.PVRamdisk == null ? "" : this.PVRamdisk);
            hashMap.put("PV_args", this.PVArgs == null ? "" : this.PVArgs);
            hashMap.put("PV_bootloader_args", this.PVBootloaderArgs == null ? "" : this.PVBootloaderArgs);
            hashMap.put("PV_legacy_args", this.PVLegacyArgs == null ? "" : this.PVLegacyArgs);
            hashMap.put("HVM_boot_policy", this.HVMBootPolicy == null ? "" : this.HVMBootPolicy);
            hashMap.put("HVM_boot_params", this.HVMBootParams == null ? new HashMap() : this.HVMBootParams);
            hashMap.put("HVM_shadow_multiplier", this.HVMShadowMultiplier == null ? 0.0 : this.HVMShadowMultiplier);
            hashMap.put("platform", this.platform == null ? new HashMap() : this.platform);
            hashMap.put("PCI_bus", this.PCIBus == null ? "" : this.PCIBus);
            hashMap.put("other_config", this.otherConfig == null ? new HashMap() : this.otherConfig);
            hashMap.put("domid", this.domid == null ? 0L : this.domid);
            hashMap.put("domarch", this.domarch == null ? "" : this.domarch);
            hashMap.put("last_boot_CPU_flags", this.lastBootCPUFlags == null ? new HashMap() : this.lastBootCPUFlags);
            hashMap.put("is_control_domain", this.isControlDomain == null ? false : this.isControlDomain);
            hashMap.put("metrics", this.metrics == null ? new VMMetrics("OpaqueRef:NULL") : this.metrics);
            hashMap.put("guest_metrics", this.guestMetrics == null ? new VMGuestMetrics("OpaqueRef:NULL") : this.guestMetrics);
            hashMap.put("last_booted_record", this.lastBootedRecord == null ? "" : this.lastBootedRecord);
            hashMap.put("recommendations", this.recommendations == null ? "" : this.recommendations);
            hashMap.put("xenstore_data", this.xenstoreData == null ? new HashMap() : this.xenstoreData);
            hashMap.put("ha_always_run", this.haAlwaysRun == null ? false : this.haAlwaysRun);
            hashMap.put("ha_restart_priority", this.haRestartPriority == null ? "" : this.haRestartPriority);
            hashMap.put("is_a_snapshot", this.isASnapshot == null ? false : this.isASnapshot);
            hashMap.put("snapshot_of", this.snapshotOf == null ? new VM("OpaqueRef:NULL") : this.snapshotOf);
            hashMap.put("snapshots", this.snapshots == null ? new LinkedHashSet() : this.snapshots);
            hashMap.put("snapshot_time", this.snapshotTime == null ? new Date(0L) : this.snapshotTime);
            hashMap.put("transportable_snapshot_id", this.transportableSnapshotId == null ? "" : this.transportableSnapshotId);
            hashMap.put("blobs", this.blobs == null ? new HashMap() : this.blobs);
            hashMap.put("tags", this.tags == null ? new LinkedHashSet() : this.tags);
            hashMap.put("blocked_operations", this.blockedOperations == null ? new HashMap() : this.blockedOperations);
            hashMap.put("snapshot_info", this.snapshotInfo == null ? new HashMap() : this.snapshotInfo);
            hashMap.put("snapshot_metadata", this.snapshotMetadata == null ? "" : this.snapshotMetadata);
            hashMap.put("parent", this.parent == null ? new VM("OpaqueRef:NULL") : this.parent);
            hashMap.put("children", this.children == null ? new LinkedHashSet() : this.children);
            hashMap.put("bios_strings", this.biosStrings == null ? new HashMap() : this.biosStrings);
            hashMap.put("protection_policy", this.protectionPolicy == null ? new VMPP("OpaqueRef:NULL") : this.protectionPolicy);
            hashMap.put("is_snapshot_from_vmpp", this.isSnapshotFromVmpp == null ? false : this.isSnapshotFromVmpp);
            hashMap.put("appliance", this.appliance == null ? new VMAppliance("OpaqueRef:NULL") : this.appliance);
            hashMap.put("start_delay", this.startDelay == null ? 0L : this.startDelay);
            hashMap.put("shutdown_delay", this.shutdownDelay == null ? 0L : this.shutdownDelay);
            hashMap.put("order", this.order == null ? 0L : this.order);
            hashMap.put("VGPUs", this.VGPUs == null ? new LinkedHashSet() : this.VGPUs);
            hashMap.put("attached_PCIs", this.attachedPCIs == null ? new LinkedHashSet() : this.attachedPCIs);
            hashMap.put("suspend_SR", this.suspendSR == null ? new SR("OpaqueRef:NULL") : this.suspendSR);
            hashMap.put("version", this.version == null ? 0L : this.version);
            hashMap.put("generation_id", this.generationId == null ? "" : this.generationId);
            return hashMap;
        }
    }
}

