// -*- C++ -*-
// VisualBoyAdvance - Nintendo Gameboy/GameboyAdvance (TM) emulator.
// Copyright (C) 1999-2003 Forgotten
// Copyright (C) 2004 Forgotten and the VBA development team

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or(at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

/************************************************************************/
/* Arm/Thumb command set disassembler                                   */
/************************************************************************/

#ifndef __ARMDIS_H__
#define __ARMDIS_H__
#ifdef __cplusplus
extern "C" {
#endif

#define DIS_VIEW_ADDRESS 1
#define DIS_VIEW_CODE 2

#define u32 unsigned int

typedef struct ARMul_State ARMul_State;

int disThumb(ARMul_State * state, u32 opcode, char *dest, int flags);
int disArm(ARMul_State * state, u32 offset, char *dest, int flags);
#ifdef __cplusplus
}
#endif
#endif // __ARMDIS_H__
