/*
 * Decompiled with CFR 0.152.
 */
package beagleutil;

import beagleutil.ThreadSafeIndexer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ChromIds {
    private static final ChromIds chromIds = new ChromIds();
    private final ThreadSafeIndexer<String> indexer;
    private final ConcurrentMap<String, Integer> map;
    private volatile List<String> ids;

    private ChromIds() {
        int n = 4;
        this.indexer = new ThreadSafeIndexer(n);
        this.map = new ConcurrentHashMap<String, Integer>(n);
        this.ids = new ArrayList<String>();
    }

    public static ChromIds instance() {
        return chromIds;
    }

    public int getIndex(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("id.isEmpty()");
        }
        Integer n = (Integer)this.map.get(string);
        if (n != null) {
            return n;
        }
        int n2 = this.indexer.getIndex(string);
        this.map.putIfAbsent(string, n2);
        return n2;
    }

    public int[] getIndices(String[] stringArray) {
        for (String string : stringArray) {
            if (!string.isEmpty()) continue;
            throw new IllegalArgumentException("id.isEmpty()");
        }
        return this.indexer.getIndices((String[])stringArray);
    }

    public int getIndexIfIndexed(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("id.isEmpty()");
        }
        Integer n = (Integer)this.map.get(string);
        if (n != null) {
            return n;
        }
        int n2 = this.indexer.getIndexIfIndexed(string);
        if (n2 >= 0) {
            this.map.putIfAbsent(string, n2);
        }
        return n2;
    }

    public int size() {
        return this.indexer.size();
    }

    public String id(int n) {
        if (n >= this.ids.size()) {
            this.ids = this.indexer.items();
        }
        return this.ids.get(n);
    }

    public String[] ids() {
        return this.indexer.items().toArray(new String[0]);
    }

    public String toString() {
        return Arrays.toString(this.ids());
    }
}

