REM Purpose:  Verify FILEATTR
REM  Author:  Howard Wulf, AF5NE
REM    Date:  2015-02-20
REM


REM -----------------------------------------
REM THE FOLLOWING SHOULD NOT ERROR
REM

PRINT "FILEATTR FOR CLOSED FILES"
PRINT "FILEATTR(CLOSED,1)=";FILEATTR(#7,1)
PRINT "FILEATTR(CLOSED,2)=";FILEATTR(#7,2)


PRINT "FILEATTR FOR INPUT FILES"
OPEN "E062.DAT" FOR INPUT AS #4
PRINT "FILEATTR(INPUT ,1)=";FILEATTR(#4,1)
PRINT "FILEATTR(INPUT ,2)=";FILEATTR(#4,2)
CLOSE #4

PRINT "FILEATTR FOR OUTPUT FILES"
OPEN "E062.DAT" FOR OUTPUT AS #1
PRINT "FILEATTR(OUTPUT,1)=";FILEATTR(#1,1)
PRINT "FILEATTR(INPUT ,2)=";FILEATTR(#4,2)
CLOSE #1

PRINT "FILEATTR FOR RANDOM FILES"
OPEN "E062.DAT" FOR RANDOM AS #5
PRINT "FILEATTR(RANDOM,1)=";FILEATTR(#5,1)
PRINT "FILEATTR(RANDOM,2)=";FILEATTR(#5,2)
CLOSE #5

PRINT "FILEATTR FOR APPEND FILES"
OPEN "E062.DAT" FOR APPEND AS #2
PRINT "FILEATTR(APPEND,1)=";FILEATTR(#2,1)
PRINT "FILEATTR(APPEND,2)=";FILEATTR(#2,2)
CLOSE #2

PRINT "FILEATTR FOR BINARY FILES"
OPEN "E062.DAT" FOR BINARY AS #3
PRINT "FILEATTR(BINARY,1)=";FILEATTR(#3,1)
PRINT "FILEATTR(BINARY,2)=";FILEATTR(#3,2)
CLOSE #3


ON ERROR RESUME NEXT


REM -----------------------------------------
REM THE FOLLOWING SHOULD CAUSE ERRORS
REM BECAUSE THE DEVICE NUMBER IS NOT ALLOWED
REM

PRINT "FILEATTR WITH INVALID X < DEVMIN"
100 PRINT "FILEATTR(#0,1)=";FILEATTR(#0,1)
PRINT
PRINT "ERR =";ERR
PRINT "ERL =";ERL
PRINT "ERR$=";ERR$
ERROR 0

PRINT "FILEATTR WITH INVALID X > DEVMAX"
200 PRINT "FILEATTR(#999,2)=";FILEATTR(#999,2)
PRINT
PRINT "ERR =";ERR
PRINT "ERL =";ERL
PRINT "ERR$=";ERR$
ERROR 0

REM -----------------------------------------
REM THE FOLLOWING SHOULD CAUSE ERRORS
REM BECAUSE THE ATTRIBUTE NUMBER IS NOT ALLOWED
REM
REM

PRINT "FILEATTR WITH INVALID Y < 1"
300 PRINT "FILEATTR(...,0)=";FILEATTR(#7,0)
PRINT
PRINT "ERR =";ERR
PRINT "ERL =";ERL
PRINT "ERR$=";ERR$
ERROR 0

PRINT "FILEATTR WITH INVALID Y > 2"
400 PRINT "FILEATTR(...,3)=";FILEATTR(#7,3)
PRINT
PRINT "ERR =";ERR
PRINT "ERL =";ERL
PRINT "ERR$=";ERR$
ERROR 0


END
