// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/datacatalog/v1beta1/policytagmanagerserialization.proto

package datacatalogpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/iam/v1"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Message capturing a taxonomy and its policy tag hierarchy as a nested proto.
// Used for taxonomy import/export and mutation.
type SerializedTaxonomy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Display name of the taxonomy. Max 200 bytes when encoded in UTF-8.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Description of the serialized taxonomy. The length of the
	// description is limited to 2000 bytes when encoded in UTF-8. If not set,
	// defaults to an empty description.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Top level policy tags associated with the taxonomy if any.
	PolicyTags []*SerializedPolicyTag `protobuf:"bytes,3,rep,name=policy_tags,json=policyTags,proto3" json:"policy_tags,omitempty"`
}

func (x *SerializedTaxonomy) Reset() {
	*x = SerializedTaxonomy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SerializedTaxonomy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SerializedTaxonomy) ProtoMessage() {}

func (x *SerializedTaxonomy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SerializedTaxonomy.ProtoReflect.Descriptor instead.
func (*SerializedTaxonomy) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDescGZIP(), []int{0}
}

func (x *SerializedTaxonomy) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *SerializedTaxonomy) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *SerializedTaxonomy) GetPolicyTags() []*SerializedPolicyTag {
	if x != nil {
		return x.PolicyTags
	}
	return nil
}

// Message representing one policy tag when exported as a nested proto.
type SerializedPolicyTag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Display name of the policy tag. Max 200 bytes when encoded in UTF-8.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Description of the serialized policy tag. The length of the
	// description is limited to 2000 bytes when encoded in UTF-8. If not set,
	// defaults to an empty description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Children of the policy tag if any.
	ChildPolicyTags []*SerializedPolicyTag `protobuf:"bytes,4,rep,name=child_policy_tags,json=childPolicyTags,proto3" json:"child_policy_tags,omitempty"`
}

func (x *SerializedPolicyTag) Reset() {
	*x = SerializedPolicyTag{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SerializedPolicyTag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SerializedPolicyTag) ProtoMessage() {}

func (x *SerializedPolicyTag) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SerializedPolicyTag.ProtoReflect.Descriptor instead.
func (*SerializedPolicyTag) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDescGZIP(), []int{1}
}

func (x *SerializedPolicyTag) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *SerializedPolicyTag) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *SerializedPolicyTag) GetChildPolicyTags() []*SerializedPolicyTag {
	if x != nil {
		return x.ChildPolicyTags
	}
	return nil
}

// Request message for
// [ImportTaxonomies][google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization.ImportTaxonomies].
type ImportTaxonomiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of project that the newly created taxonomies will
	// belong to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Source taxonomies to be imported in a tree structure.
	//
	// Types that are assignable to Source:
	//
	//	*ImportTaxonomiesRequest_InlineSource
	Source isImportTaxonomiesRequest_Source `protobuf_oneof:"source"`
}

func (x *ImportTaxonomiesRequest) Reset() {
	*x = ImportTaxonomiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportTaxonomiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportTaxonomiesRequest) ProtoMessage() {}

func (x *ImportTaxonomiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportTaxonomiesRequest.ProtoReflect.Descriptor instead.
func (*ImportTaxonomiesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDescGZIP(), []int{2}
}

func (x *ImportTaxonomiesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *ImportTaxonomiesRequest) GetSource() isImportTaxonomiesRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImportTaxonomiesRequest) GetInlineSource() *InlineSource {
	if x, ok := x.GetSource().(*ImportTaxonomiesRequest_InlineSource); ok {
		return x.InlineSource
	}
	return nil
}

type isImportTaxonomiesRequest_Source interface {
	isImportTaxonomiesRequest_Source()
}

type ImportTaxonomiesRequest_InlineSource struct {
	// Inline source used for taxonomies import
	InlineSource *InlineSource `protobuf:"bytes,2,opt,name=inline_source,json=inlineSource,proto3,oneof"`
}

func (*ImportTaxonomiesRequest_InlineSource) isImportTaxonomiesRequest_Source() {}

// Inline source used for taxonomies import.
type InlineSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Taxonomies to be imported.
	Taxonomies []*SerializedTaxonomy `protobuf:"bytes,1,rep,name=taxonomies,proto3" json:"taxonomies,omitempty"`
}

func (x *InlineSource) Reset() {
	*x = InlineSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InlineSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InlineSource) ProtoMessage() {}

func (x *InlineSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InlineSource.ProtoReflect.Descriptor instead.
func (*InlineSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDescGZIP(), []int{3}
}

func (x *InlineSource) GetTaxonomies() []*SerializedTaxonomy {
	if x != nil {
		return x.Taxonomies
	}
	return nil
}

// Response message for
// [ImportTaxonomies][google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization.ImportTaxonomies].
type ImportTaxonomiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Taxonomies that were imported.
	Taxonomies []*Taxonomy `protobuf:"bytes,1,rep,name=taxonomies,proto3" json:"taxonomies,omitempty"`
}

func (x *ImportTaxonomiesResponse) Reset() {
	*x = ImportTaxonomiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportTaxonomiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportTaxonomiesResponse) ProtoMessage() {}

func (x *ImportTaxonomiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportTaxonomiesResponse.ProtoReflect.Descriptor instead.
func (*ImportTaxonomiesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDescGZIP(), []int{4}
}

func (x *ImportTaxonomiesResponse) GetTaxonomies() []*Taxonomy {
	if x != nil {
		return x.Taxonomies
	}
	return nil
}

// Request message for
// [ExportTaxonomies][google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization.ExportTaxonomies].
type ExportTaxonomiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the project that taxonomies to be exported
	// will share.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Resource names of the taxonomies to be exported.
	Taxonomies []string `protobuf:"bytes,2,rep,name=taxonomies,proto3" json:"taxonomies,omitempty"`
	// Required. Taxonomies export destination.
	//
	// Types that are assignable to Destination:
	//
	//	*ExportTaxonomiesRequest_SerializedTaxonomies
	Destination isExportTaxonomiesRequest_Destination `protobuf_oneof:"destination"`
}

func (x *ExportTaxonomiesRequest) Reset() {
	*x = ExportTaxonomiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportTaxonomiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportTaxonomiesRequest) ProtoMessage() {}

func (x *ExportTaxonomiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportTaxonomiesRequest.ProtoReflect.Descriptor instead.
func (*ExportTaxonomiesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDescGZIP(), []int{5}
}

func (x *ExportTaxonomiesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportTaxonomiesRequest) GetTaxonomies() []string {
	if x != nil {
		return x.Taxonomies
	}
	return nil
}

func (m *ExportTaxonomiesRequest) GetDestination() isExportTaxonomiesRequest_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportTaxonomiesRequest) GetSerializedTaxonomies() bool {
	if x, ok := x.GetDestination().(*ExportTaxonomiesRequest_SerializedTaxonomies); ok {
		return x.SerializedTaxonomies
	}
	return false
}

type isExportTaxonomiesRequest_Destination interface {
	isExportTaxonomiesRequest_Destination()
}

type ExportTaxonomiesRequest_SerializedTaxonomies struct {
	// Export taxonomies as serialized taxonomies.
	SerializedTaxonomies bool `protobuf:"varint,3,opt,name=serialized_taxonomies,json=serializedTaxonomies,proto3,oneof"`
}

func (*ExportTaxonomiesRequest_SerializedTaxonomies) isExportTaxonomiesRequest_Destination() {}

// Response message for
// [ExportTaxonomies][google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization.ExportTaxonomies].
type ExportTaxonomiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of taxonomies and policy tags in a tree structure.
	Taxonomies []*SerializedTaxonomy `protobuf:"bytes,1,rep,name=taxonomies,proto3" json:"taxonomies,omitempty"`
}

func (x *ExportTaxonomiesResponse) Reset() {
	*x = ExportTaxonomiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportTaxonomiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportTaxonomiesResponse) ProtoMessage() {}

func (x *ExportTaxonomiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportTaxonomiesResponse.ProtoReflect.Descriptor instead.
func (*ExportTaxonomiesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDescGZIP(), []int{6}
}

func (x *ExportTaxonomiesResponse) GetTaxonomies() []*SerializedTaxonomy {
	if x != nil {
		return x.Taxonomies
	}
	return nil
}

var File_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto protoreflect.FileDescriptor

var file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDesc = []byte{
	0x0a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x61, 0x67, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x61, 0x67, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xb6, 0x01, 0x0a, 0x12, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54,
	0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x56, 0x0a, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x52, 0x0a, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x73, 0x22, 0xc2, 0x01, 0x0a, 0x13, 0x53, 0x65,
	0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61,
	0x67, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x61, 0x0a, 0x11, 0x63,
	0x68, 0x69, 0x6c, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x52, 0x0f, 0x63,
	0x68, 0x69, 0x6c, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x73, 0x22, 0xbf,
	0x01, 0x0a, 0x17, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x25, 0x12, 0x23, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54,
	0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x55, 0x0a, 0x0d, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x22, 0x69, 0x0a, 0x0c, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x59, 0x0a, 0x0a, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x64, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x22, 0x66, 0x0a, 0x18, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x0a, 0x74, 0x61, 0x78, 0x6f, 0x6e,
	0x6f, 0x6d, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x0a, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d,
	0x69, 0x65, 0x73, 0x22, 0xf1, 0x01, 0x0a, 0x17, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61,
	0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x0a, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25,
	0x0a, 0x23, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x78,
	0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x0a, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65,
	0x73, 0x12, 0x35, 0x0a, 0x15, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f,
	0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x00, 0x52, 0x14, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x61,
	0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x70, 0x0a, 0x18, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x0a, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x69, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x0a, 0x74,
	0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x32, 0x92, 0x04, 0x0a, 0x1d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x53, 0x65,
	0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xd0, 0x01, 0x0a, 0x10,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73,
	0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f,
	0x6d, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x45, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x22,
	0x3a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f,
	0x6d, 0x69, 0x65, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0x12, 0xcd,
	0x01, 0x0a, 0x10, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d,
	0x69, 0x65, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x78,
	0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x78,
	0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x1a, 0x4e,
	0xca, 0x41, 0x1a, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x88,
	0x02, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x22, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54,
	0x61, 0x67, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x20,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31,
	0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x5c, 0x56, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0xea, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDescOnce sync.Once
	file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDescData = file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDesc
)

func file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDescGZIP() []byte {
	file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDescOnce.Do(func() {
		file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDescData)
	})
	return file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDescData
}

var file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_goTypes = []interface{}{
	(*SerializedTaxonomy)(nil),       // 0: google.cloud.datacatalog.v1beta1.SerializedTaxonomy
	(*SerializedPolicyTag)(nil),      // 1: google.cloud.datacatalog.v1beta1.SerializedPolicyTag
	(*ImportTaxonomiesRequest)(nil),  // 2: google.cloud.datacatalog.v1beta1.ImportTaxonomiesRequest
	(*InlineSource)(nil),             // 3: google.cloud.datacatalog.v1beta1.InlineSource
	(*ImportTaxonomiesResponse)(nil), // 4: google.cloud.datacatalog.v1beta1.ImportTaxonomiesResponse
	(*ExportTaxonomiesRequest)(nil),  // 5: google.cloud.datacatalog.v1beta1.ExportTaxonomiesRequest
	(*ExportTaxonomiesResponse)(nil), // 6: google.cloud.datacatalog.v1beta1.ExportTaxonomiesResponse
	(*Taxonomy)(nil),                 // 7: google.cloud.datacatalog.v1beta1.Taxonomy
}
var file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_depIdxs = []int32{
	1, // 0: google.cloud.datacatalog.v1beta1.SerializedTaxonomy.policy_tags:type_name -> google.cloud.datacatalog.v1beta1.SerializedPolicyTag
	1, // 1: google.cloud.datacatalog.v1beta1.SerializedPolicyTag.child_policy_tags:type_name -> google.cloud.datacatalog.v1beta1.SerializedPolicyTag
	3, // 2: google.cloud.datacatalog.v1beta1.ImportTaxonomiesRequest.inline_source:type_name -> google.cloud.datacatalog.v1beta1.InlineSource
	0, // 3: google.cloud.datacatalog.v1beta1.InlineSource.taxonomies:type_name -> google.cloud.datacatalog.v1beta1.SerializedTaxonomy
	7, // 4: google.cloud.datacatalog.v1beta1.ImportTaxonomiesResponse.taxonomies:type_name -> google.cloud.datacatalog.v1beta1.Taxonomy
	0, // 5: google.cloud.datacatalog.v1beta1.ExportTaxonomiesResponse.taxonomies:type_name -> google.cloud.datacatalog.v1beta1.SerializedTaxonomy
	2, // 6: google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization.ImportTaxonomies:input_type -> google.cloud.datacatalog.v1beta1.ImportTaxonomiesRequest
	5, // 7: google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization.ExportTaxonomies:input_type -> google.cloud.datacatalog.v1beta1.ExportTaxonomiesRequest
	4, // 8: google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization.ImportTaxonomies:output_type -> google.cloud.datacatalog.v1beta1.ImportTaxonomiesResponse
	6, // 9: google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization.ExportTaxonomies:output_type -> google.cloud.datacatalog.v1beta1.ExportTaxonomiesResponse
	8, // [8:10] is the sub-list for method output_type
	6, // [6:8] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_init() }
func file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_init() {
	if File_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto != nil {
		return
	}
	file_google_cloud_datacatalog_v1beta1_policytagmanager_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SerializedTaxonomy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SerializedPolicyTag); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportTaxonomiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InlineSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportTaxonomiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportTaxonomiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportTaxonomiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*ImportTaxonomiesRequest_InlineSource)(nil),
	}
	file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*ExportTaxonomiesRequest_SerializedTaxonomies)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_goTypes,
		DependencyIndexes: file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_depIdxs,
		MessageInfos:      file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_msgTypes,
	}.Build()
	File_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto = out.File
	file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_rawDesc = nil
	file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_goTypes = nil
	file_google_cloud_datacatalog_v1beta1_policytagmanagerserialization_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PolicyTagManagerSerializationClient is the client API for PolicyTagManagerSerialization service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PolicyTagManagerSerializationClient interface {
	// Imports all taxonomies and their policy tags to a project as new
	// taxonomies.
	//
	// This method provides a bulk taxonomy / policy tag creation using nested
	// proto structure.
	ImportTaxonomies(ctx context.Context, in *ImportTaxonomiesRequest, opts ...grpc.CallOption) (*ImportTaxonomiesResponse, error)
	// Exports all taxonomies and their policy tags in a project.
	//
	// This method generates SerializedTaxonomy protos with nested policy tags
	// that can be used as an input for future ImportTaxonomies calls.
	ExportTaxonomies(ctx context.Context, in *ExportTaxonomiesRequest, opts ...grpc.CallOption) (*ExportTaxonomiesResponse, error)
}

type policyTagManagerSerializationClient struct {
	cc grpc.ClientConnInterface
}

func NewPolicyTagManagerSerializationClient(cc grpc.ClientConnInterface) PolicyTagManagerSerializationClient {
	return &policyTagManagerSerializationClient{cc}
}

func (c *policyTagManagerSerializationClient) ImportTaxonomies(ctx context.Context, in *ImportTaxonomiesRequest, opts ...grpc.CallOption) (*ImportTaxonomiesResponse, error) {
	out := new(ImportTaxonomiesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization/ImportTaxonomies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerSerializationClient) ExportTaxonomies(ctx context.Context, in *ExportTaxonomiesRequest, opts ...grpc.CallOption) (*ExportTaxonomiesResponse, error) {
	out := new(ExportTaxonomiesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization/ExportTaxonomies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PolicyTagManagerSerializationServer is the server API for PolicyTagManagerSerialization service.
type PolicyTagManagerSerializationServer interface {
	// Imports all taxonomies and their policy tags to a project as new
	// taxonomies.
	//
	// This method provides a bulk taxonomy / policy tag creation using nested
	// proto structure.
	ImportTaxonomies(context.Context, *ImportTaxonomiesRequest) (*ImportTaxonomiesResponse, error)
	// Exports all taxonomies and their policy tags in a project.
	//
	// This method generates SerializedTaxonomy protos with nested policy tags
	// that can be used as an input for future ImportTaxonomies calls.
	ExportTaxonomies(context.Context, *ExportTaxonomiesRequest) (*ExportTaxonomiesResponse, error)
}

// UnimplementedPolicyTagManagerSerializationServer can be embedded to have forward compatible implementations.
type UnimplementedPolicyTagManagerSerializationServer struct {
}

func (*UnimplementedPolicyTagManagerSerializationServer) ImportTaxonomies(context.Context, *ImportTaxonomiesRequest) (*ImportTaxonomiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportTaxonomies not implemented")
}
func (*UnimplementedPolicyTagManagerSerializationServer) ExportTaxonomies(context.Context, *ExportTaxonomiesRequest) (*ExportTaxonomiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportTaxonomies not implemented")
}

func RegisterPolicyTagManagerSerializationServer(s *grpc.Server, srv PolicyTagManagerSerializationServer) {
	s.RegisterService(&_PolicyTagManagerSerialization_serviceDesc, srv)
}

func _PolicyTagManagerSerialization_ImportTaxonomies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportTaxonomiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerSerializationServer).ImportTaxonomies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization/ImportTaxonomies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerSerializationServer).ImportTaxonomies(ctx, req.(*ImportTaxonomiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManagerSerialization_ExportTaxonomies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportTaxonomiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerSerializationServer).ExportTaxonomies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization/ExportTaxonomies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerSerializationServer).ExportTaxonomies(ctx, req.(*ExportTaxonomiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PolicyTagManagerSerialization_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization",
	HandlerType: (*PolicyTagManagerSerializationServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ImportTaxonomies",
			Handler:    _PolicyTagManagerSerialization_ImportTaxonomies_Handler,
		},
		{
			MethodName: "ExportTaxonomies",
			Handler:    _PolicyTagManagerSerialization_ExportTaxonomies_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datacatalog/v1beta1/policytagmanagerserialization.proto",
}
