// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/dataplex/v1/datascans.proto

package dataplexpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of DataScan.
type DataScanType int32

const (
	// The DataScan type is unspecified.
	DataScanType_DATA_SCAN_TYPE_UNSPECIFIED DataScanType = 0
	// Data Quality scan.
	DataScanType_DATA_QUALITY DataScanType = 1
	// Data Profile scan.
	DataScanType_DATA_PROFILE DataScanType = 2
)

// Enum value maps for DataScanType.
var (
	DataScanType_name = map[int32]string{
		0: "DATA_SCAN_TYPE_UNSPECIFIED",
		1: "DATA_QUALITY",
		2: "DATA_PROFILE",
	}
	DataScanType_value = map[string]int32{
		"DATA_SCAN_TYPE_UNSPECIFIED": 0,
		"DATA_QUALITY":               1,
		"DATA_PROFILE":               2,
	}
)

func (x DataScanType) Enum() *DataScanType {
	p := new(DataScanType)
	*p = x
	return p
}

func (x DataScanType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataScanType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_datascans_proto_enumTypes[0].Descriptor()
}

func (DataScanType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_datascans_proto_enumTypes[0]
}

func (x DataScanType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataScanType.Descriptor instead.
func (DataScanType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{0}
}

// DataScan view options.
type GetDataScanRequest_DataScanView int32

const (
	// The API will default to the `BASIC` view.
	GetDataScanRequest_DATA_SCAN_VIEW_UNSPECIFIED GetDataScanRequest_DataScanView = 0
	// Basic view that does not include *spec* and *result*.
	GetDataScanRequest_BASIC GetDataScanRequest_DataScanView = 1
	// Include everything.
	GetDataScanRequest_FULL GetDataScanRequest_DataScanView = 10
)

// Enum value maps for GetDataScanRequest_DataScanView.
var (
	GetDataScanRequest_DataScanView_name = map[int32]string{
		0:  "DATA_SCAN_VIEW_UNSPECIFIED",
		1:  "BASIC",
		10: "FULL",
	}
	GetDataScanRequest_DataScanView_value = map[string]int32{
		"DATA_SCAN_VIEW_UNSPECIFIED": 0,
		"BASIC":                      1,
		"FULL":                       10,
	}
)

func (x GetDataScanRequest_DataScanView) Enum() *GetDataScanRequest_DataScanView {
	p := new(GetDataScanRequest_DataScanView)
	*p = x
	return p
}

func (x GetDataScanRequest_DataScanView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetDataScanRequest_DataScanView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_datascans_proto_enumTypes[1].Descriptor()
}

func (GetDataScanRequest_DataScanView) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_datascans_proto_enumTypes[1]
}

func (x GetDataScanRequest_DataScanView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetDataScanRequest_DataScanView.Descriptor instead.
func (GetDataScanRequest_DataScanView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{3, 0}
}

// DataScanJob view options.
type GetDataScanJobRequest_DataScanJobView int32

const (
	// The API will default to the `BASIC` view.
	GetDataScanJobRequest_DATA_SCAN_JOB_VIEW_UNSPECIFIED GetDataScanJobRequest_DataScanJobView = 0
	// Basic view that does not include *spec* and *result*.
	GetDataScanJobRequest_BASIC GetDataScanJobRequest_DataScanJobView = 1
	// Include everything.
	GetDataScanJobRequest_FULL GetDataScanJobRequest_DataScanJobView = 10
)

// Enum value maps for GetDataScanJobRequest_DataScanJobView.
var (
	GetDataScanJobRequest_DataScanJobView_name = map[int32]string{
		0:  "DATA_SCAN_JOB_VIEW_UNSPECIFIED",
		1:  "BASIC",
		10: "FULL",
	}
	GetDataScanJobRequest_DataScanJobView_value = map[string]int32{
		"DATA_SCAN_JOB_VIEW_UNSPECIFIED": 0,
		"BASIC":                          1,
		"FULL":                           10,
	}
)

func (x GetDataScanJobRequest_DataScanJobView) Enum() *GetDataScanJobRequest_DataScanJobView {
	p := new(GetDataScanJobRequest_DataScanJobView)
	*p = x
	return p
}

func (x GetDataScanJobRequest_DataScanJobView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetDataScanJobRequest_DataScanJobView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_datascans_proto_enumTypes[2].Descriptor()
}

func (GetDataScanJobRequest_DataScanJobView) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_datascans_proto_enumTypes[2]
}

func (x GetDataScanJobRequest_DataScanJobView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetDataScanJobRequest_DataScanJobView.Descriptor instead.
func (GetDataScanJobRequest_DataScanJobView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{8, 0}
}

// Execution state for the DataScanJob.
type DataScanJob_State int32

const (
	// The DataScanJob state is unspecified.
	DataScanJob_STATE_UNSPECIFIED DataScanJob_State = 0
	// The DataScanJob is running.
	DataScanJob_RUNNING DataScanJob_State = 1
	// The DataScanJob is canceling.
	DataScanJob_CANCELING DataScanJob_State = 2
	// The DataScanJob cancellation was successful.
	DataScanJob_CANCELLED DataScanJob_State = 3
	// The DataScanJob completed successfully.
	DataScanJob_SUCCEEDED DataScanJob_State = 4
	// The DataScanJob is no longer running due to an error.
	DataScanJob_FAILED DataScanJob_State = 5
	// The DataScanJob has been created but not started to run yet.
	DataScanJob_PENDING DataScanJob_State = 7
)

// Enum value maps for DataScanJob_State.
var (
	DataScanJob_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "CANCELING",
		3: "CANCELLED",
		4: "SUCCEEDED",
		5: "FAILED",
		7: "PENDING",
	}
	DataScanJob_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"CANCELING":         2,
		"CANCELLED":         3,
		"SUCCEEDED":         4,
		"FAILED":            5,
		"PENDING":           7,
	}
)

func (x DataScanJob_State) Enum() *DataScanJob_State {
	p := new(DataScanJob_State)
	*p = x
	return p
}

func (x DataScanJob_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataScanJob_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_datascans_proto_enumTypes[3].Descriptor()
}

func (DataScanJob_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_datascans_proto_enumTypes[3]
}

func (x DataScanJob_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataScanJob_State.Descriptor instead.
func (DataScanJob_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{12, 0}
}

// Create dataScan request.
type CreateDataScanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent location:
	// `projects/{project}/locations/{location_id}`
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. DataScan resource.
	DataScan *DataScan `protobuf:"bytes,2,opt,name=data_scan,json=dataScan,proto3" json:"data_scan,omitempty"`
	// Required. DataScan identifier.
	//
	// * Must contain only lowercase letters, numbers and hyphens.
	// * Must start with a letter.
	// * Must end with a number or a letter.
	// * Must be between 1-63 characters.
	// * Must be unique within the customer project / location.
	DataScanId string `protobuf:"bytes,3,opt,name=data_scan_id,json=dataScanId,proto3" json:"data_scan_id,omitempty"`
	// Optional. Only validate the request, but do not perform mutations.
	// The default is `false`.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateDataScanRequest) Reset() {
	*x = CreateDataScanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDataScanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDataScanRequest) ProtoMessage() {}

func (x *CreateDataScanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDataScanRequest.ProtoReflect.Descriptor instead.
func (*CreateDataScanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{0}
}

func (x *CreateDataScanRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDataScanRequest) GetDataScan() *DataScan {
	if x != nil {
		return x.DataScan
	}
	return nil
}

func (x *CreateDataScanRequest) GetDataScanId() string {
	if x != nil {
		return x.DataScanId
	}
	return ""
}

func (x *CreateDataScanRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Update dataScan request.
type UpdateDataScanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. DataScan resource to be updated.
	//
	// Only fields specified in `update_mask` are updated.
	DataScan *DataScan `protobuf:"bytes,1,opt,name=data_scan,json=dataScan,proto3" json:"data_scan,omitempty"`
	// Required. Mask of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. Only validate the request, but do not perform mutations.
	// The default is `false`.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateDataScanRequest) Reset() {
	*x = UpdateDataScanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDataScanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDataScanRequest) ProtoMessage() {}

func (x *UpdateDataScanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDataScanRequest.ProtoReflect.Descriptor instead.
func (*UpdateDataScanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{1}
}

func (x *UpdateDataScanRequest) GetDataScan() *DataScan {
	if x != nil {
		return x.DataScan
	}
	return nil
}

func (x *UpdateDataScanRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateDataScanRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Delete dataScan request.
type DeleteDataScanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the dataScan:
	// `projects/{project}/locations/{location_id}/dataScans/{data_scan_id}`
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDataScanRequest) Reset() {
	*x = DeleteDataScanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDataScanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDataScanRequest) ProtoMessage() {}

func (x *DeleteDataScanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDataScanRequest.ProtoReflect.Descriptor instead.
func (*DeleteDataScanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{2}
}

func (x *DeleteDataScanRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Get dataScan request.
type GetDataScanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the dataScan:
	// `projects/{project}/locations/{location_id}/dataScans/{data_scan_id}`
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Select the DataScan view to return. Defaults to `BASIC`.
	View GetDataScanRequest_DataScanView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.dataplex.v1.GetDataScanRequest_DataScanView" json:"view,omitempty"`
}

func (x *GetDataScanRequest) Reset() {
	*x = GetDataScanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataScanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataScanRequest) ProtoMessage() {}

func (x *GetDataScanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataScanRequest.ProtoReflect.Descriptor instead.
func (*GetDataScanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{3}
}

func (x *GetDataScanRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetDataScanRequest) GetView() GetDataScanRequest_DataScanView {
	if x != nil {
		return x.View
	}
	return GetDataScanRequest_DATA_SCAN_VIEW_UNSPECIFIED
}

// List dataScans request.
type ListDataScansRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent location:
	// `projects/{project}/locations/{location_id}`
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of dataScans to return. The service may return
	// fewer than this value. If unspecified, at most 500 scans will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListDataScans` call. Provide
	// this to retrieve the subsequent page. When paginating, all other parameters
	// provided to `ListDataScans` must match the call that provided the
	// page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Order by fields (`name` or `create_time`) for the result.
	// If not specified, the ordering is undefined.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListDataScansRequest) Reset() {
	*x = ListDataScansRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataScansRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataScansRequest) ProtoMessage() {}

func (x *ListDataScansRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataScansRequest.ProtoReflect.Descriptor instead.
func (*ListDataScansRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{4}
}

func (x *ListDataScansRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDataScansRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDataScansRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDataScansRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDataScansRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// List dataScans response.
type ListDataScansResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DataScans (`BASIC` view only) under the given parent location.
	DataScans []*DataScan `protobuf:"bytes,1,rep,name=data_scans,json=dataScans,proto3" json:"data_scans,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListDataScansResponse) Reset() {
	*x = ListDataScansResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataScansResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataScansResponse) ProtoMessage() {}

func (x *ListDataScansResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataScansResponse.ProtoReflect.Descriptor instead.
func (*ListDataScansResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{5}
}

func (x *ListDataScansResponse) GetDataScans() []*DataScan {
	if x != nil {
		return x.DataScans
	}
	return nil
}

func (x *ListDataScansResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListDataScansResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Run DataScan Request
type RunDataScanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the DataScan:
	// `projects/{project}/locations/{location_id}/dataScans/{data_scan_id}`.
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a GCP region.
	//
	// Only **OnDemand** data scans are allowed.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RunDataScanRequest) Reset() {
	*x = RunDataScanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunDataScanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunDataScanRequest) ProtoMessage() {}

func (x *RunDataScanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunDataScanRequest.ProtoReflect.Descriptor instead.
func (*RunDataScanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{6}
}

func (x *RunDataScanRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Run DataScan Response.
type RunDataScanResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DataScanJob created by RunDataScan request.
	Job *DataScanJob `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
}

func (x *RunDataScanResponse) Reset() {
	*x = RunDataScanResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunDataScanResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunDataScanResponse) ProtoMessage() {}

func (x *RunDataScanResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunDataScanResponse.ProtoReflect.Descriptor instead.
func (*RunDataScanResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{7}
}

func (x *RunDataScanResponse) GetJob() *DataScanJob {
	if x != nil {
		return x.Job
	}
	return nil
}

// Get DataScanJob request.
type GetDataScanJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the DataScanJob:
	// `projects/{project}/locations/{location_id}/dataScans/{data_scan_id}/jobs/{data_scan_job_id}`
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Select the DataScanJob view to return. Defaults to `BASIC`.
	View GetDataScanJobRequest_DataScanJobView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.dataplex.v1.GetDataScanJobRequest_DataScanJobView" json:"view,omitempty"`
}

func (x *GetDataScanJobRequest) Reset() {
	*x = GetDataScanJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataScanJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataScanJobRequest) ProtoMessage() {}

func (x *GetDataScanJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataScanJobRequest.ProtoReflect.Descriptor instead.
func (*GetDataScanJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{8}
}

func (x *GetDataScanJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetDataScanJobRequest) GetView() GetDataScanJobRequest_DataScanJobView {
	if x != nil {
		return x.View
	}
	return GetDataScanJobRequest_DATA_SCAN_JOB_VIEW_UNSPECIFIED
}

// List DataScanJobs request.
type ListDataScanJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent environment:
	// `projects/{project}/locations/{location_id}/dataScans/{data_scan_id}`
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of DataScanJobs to return. The service may return
	// fewer than this value. If unspecified, at most 10 DataScanJobs will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListDataScanJobs` call.
	// Provide this to retrieve the subsequent page. When paginating, all other
	// parameters provided to `ListDataScanJobs` must match the call that provided
	// the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. An expression for filtering the results of the ListDataScanJobs
	// request.
	//
	// If unspecified, all datascan jobs will be returned. Multiple filters can be
	// applied (with `AND`, `OR` logical operators). Filters are case-sensitive.
	//
	// Allowed fields are:
	//
	// - `start_time`
	// - `end_time`
	//
	// `start_time` and `end_time` expect RFC-3339 formatted strings (e.g.
	// 2018-10-08T18:30:00-07:00).
	//
	// For instance, 'start_time > 2018-10-08T00:00:00.123456789Z AND end_time <
	// 2018-10-09T00:00:00.123456789Z' limits results to DataScanJobs between
	// specified start and end times.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListDataScanJobsRequest) Reset() {
	*x = ListDataScanJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataScanJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataScanJobsRequest) ProtoMessage() {}

func (x *ListDataScanJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataScanJobsRequest.ProtoReflect.Descriptor instead.
func (*ListDataScanJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{9}
}

func (x *ListDataScanJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDataScanJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDataScanJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDataScanJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// List DataScanJobs response.
type ListDataScanJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DataScanJobs (`BASIC` view only) under a given dataScan.
	DataScanJobs []*DataScanJob `protobuf:"bytes,1,rep,name=data_scan_jobs,json=dataScanJobs,proto3" json:"data_scan_jobs,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDataScanJobsResponse) Reset() {
	*x = ListDataScanJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataScanJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataScanJobsResponse) ProtoMessage() {}

func (x *ListDataScanJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataScanJobsResponse.ProtoReflect.Descriptor instead.
func (*ListDataScanJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{10}
}

func (x *ListDataScanJobsResponse) GetDataScanJobs() []*DataScanJob {
	if x != nil {
		return x.DataScanJobs
	}
	return nil
}

func (x *ListDataScanJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Represents a user-visible job which provides the insights for the related
// data source.
//
// For example:
//
//   - Data Quality: generates queries based on the rules and runs against the
//     data to get data quality check results.
//   - Data Profile: analyzes the data in table(s) and generates insights about
//     the structure, content and relationships (such as null percent,
//     cardinality, min/max/mean, etc).
type DataScan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative resource name of the scan, of the form:
	// `projects/{project}/locations/{location_id}/dataScans/{datascan_id}`,
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. System generated globally unique ID for the scan. This ID will
	// be different if the scan is deleted and re-created with the same name.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. Description of the scan.
	//
	// * Must be between 1-1024 characters.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. User friendly display name.
	//
	// * Must be between 1-256 characters.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. User-defined labels for the scan.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Current state of the DataScan.
	State State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.dataplex.v1.State" json:"state,omitempty"`
	// Output only. The time when the scan was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the scan was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. The data source for DataScan.
	Data *DataSource `protobuf:"bytes,9,opt,name=data,proto3" json:"data,omitempty"`
	// Optional. DataScan execution settings.
	//
	// If not specified, the fields in it will use their default values.
	ExecutionSpec *DataScan_ExecutionSpec `protobuf:"bytes,10,opt,name=execution_spec,json=executionSpec,proto3" json:"execution_spec,omitempty"`
	// Output only. Status of the data scan execution.
	ExecutionStatus *DataScan_ExecutionStatus `protobuf:"bytes,11,opt,name=execution_status,json=executionStatus,proto3" json:"execution_status,omitempty"`
	// Output only. The type of DataScan.
	Type DataScanType `protobuf:"varint,12,opt,name=type,proto3,enum=google.cloud.dataplex.v1.DataScanType" json:"type,omitempty"`
	// Data Scan related setting.
	// It is required and immutable which means once data_quality_spec is set, it
	// cannot be changed to data_profile_spec.
	//
	// Types that are assignable to Spec:
	//	*DataScan_DataQualitySpec
	//	*DataScan_DataProfileSpec
	Spec isDataScan_Spec `protobuf_oneof:"spec"`
	// The result of the data scan.
	//
	// Types that are assignable to Result:
	//	*DataScan_DataQualityResult
	//	*DataScan_DataProfileResult
	Result isDataScan_Result `protobuf_oneof:"result"`
}

func (x *DataScan) Reset() {
	*x = DataScan{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataScan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataScan) ProtoMessage() {}

func (x *DataScan) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataScan.ProtoReflect.Descriptor instead.
func (*DataScan) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{11}
}

func (x *DataScan) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataScan) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *DataScan) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *DataScan) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DataScan) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *DataScan) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *DataScan) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DataScan) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *DataScan) GetData() *DataSource {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *DataScan) GetExecutionSpec() *DataScan_ExecutionSpec {
	if x != nil {
		return x.ExecutionSpec
	}
	return nil
}

func (x *DataScan) GetExecutionStatus() *DataScan_ExecutionStatus {
	if x != nil {
		return x.ExecutionStatus
	}
	return nil
}

func (x *DataScan) GetType() DataScanType {
	if x != nil {
		return x.Type
	}
	return DataScanType_DATA_SCAN_TYPE_UNSPECIFIED
}

func (m *DataScan) GetSpec() isDataScan_Spec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (x *DataScan) GetDataQualitySpec() *DataQualitySpec {
	if x, ok := x.GetSpec().(*DataScan_DataQualitySpec); ok {
		return x.DataQualitySpec
	}
	return nil
}

func (x *DataScan) GetDataProfileSpec() *DataProfileSpec {
	if x, ok := x.GetSpec().(*DataScan_DataProfileSpec); ok {
		return x.DataProfileSpec
	}
	return nil
}

func (m *DataScan) GetResult() isDataScan_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *DataScan) GetDataQualityResult() *DataQualityResult {
	if x, ok := x.GetResult().(*DataScan_DataQualityResult); ok {
		return x.DataQualityResult
	}
	return nil
}

func (x *DataScan) GetDataProfileResult() *DataProfileResult {
	if x, ok := x.GetResult().(*DataScan_DataProfileResult); ok {
		return x.DataProfileResult
	}
	return nil
}

type isDataScan_Spec interface {
	isDataScan_Spec()
}

type DataScan_DataQualitySpec struct {
	// DataQualityScan related setting.
	DataQualitySpec *DataQualitySpec `protobuf:"bytes,100,opt,name=data_quality_spec,json=dataQualitySpec,proto3,oneof"`
}

type DataScan_DataProfileSpec struct {
	// DataProfileScan related setting.
	DataProfileSpec *DataProfileSpec `protobuf:"bytes,101,opt,name=data_profile_spec,json=dataProfileSpec,proto3,oneof"`
}

func (*DataScan_DataQualitySpec) isDataScan_Spec() {}

func (*DataScan_DataProfileSpec) isDataScan_Spec() {}

type isDataScan_Result interface {
	isDataScan_Result()
}

type DataScan_DataQualityResult struct {
	// Output only. The result of the data quality scan.
	DataQualityResult *DataQualityResult `protobuf:"bytes,200,opt,name=data_quality_result,json=dataQualityResult,proto3,oneof"`
}

type DataScan_DataProfileResult struct {
	// Output only. The result of the data profile scan.
	DataProfileResult *DataProfileResult `protobuf:"bytes,201,opt,name=data_profile_result,json=dataProfileResult,proto3,oneof"`
}

func (*DataScan_DataQualityResult) isDataScan_Result() {}

func (*DataScan_DataProfileResult) isDataScan_Result() {}

// A DataScanJob represents an instance of DataScan execution.
type DataScanJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative resource name of the DataScanJob, of the form:
	// `projects/{project}/locations/{location_id}/dataScans/{datascan_id}/jobs/{job_id}`,
	// where `project` refers to a *project_id* or *project_number* and
	// `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. System generated globally unique ID for the DataScanJob.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The time when the DataScanJob was started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The time when the DataScanJob ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Execution state for the DataScanJob.
	State DataScanJob_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.dataplex.v1.DataScanJob_State" json:"state,omitempty"`
	// Output only. Additional information about the current state.
	Message string `protobuf:"bytes,6,opt,name=message,proto3" json:"message,omitempty"`
	// Output only. The type of the parent DataScan.
	Type DataScanType `protobuf:"varint,7,opt,name=type,proto3,enum=google.cloud.dataplex.v1.DataScanType" json:"type,omitempty"`
	// Data Scan related setting.
	//
	// Types that are assignable to Spec:
	//	*DataScanJob_DataQualitySpec
	//	*DataScanJob_DataProfileSpec
	Spec isDataScanJob_Spec `protobuf_oneof:"spec"`
	// The result of the data scan.
	//
	// Types that are assignable to Result:
	//	*DataScanJob_DataQualityResult
	//	*DataScanJob_DataProfileResult
	Result isDataScanJob_Result `protobuf_oneof:"result"`
}

func (x *DataScanJob) Reset() {
	*x = DataScanJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataScanJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataScanJob) ProtoMessage() {}

func (x *DataScanJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataScanJob.ProtoReflect.Descriptor instead.
func (*DataScanJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{12}
}

func (x *DataScanJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataScanJob) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *DataScanJob) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *DataScanJob) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *DataScanJob) GetState() DataScanJob_State {
	if x != nil {
		return x.State
	}
	return DataScanJob_STATE_UNSPECIFIED
}

func (x *DataScanJob) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *DataScanJob) GetType() DataScanType {
	if x != nil {
		return x.Type
	}
	return DataScanType_DATA_SCAN_TYPE_UNSPECIFIED
}

func (m *DataScanJob) GetSpec() isDataScanJob_Spec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (x *DataScanJob) GetDataQualitySpec() *DataQualitySpec {
	if x, ok := x.GetSpec().(*DataScanJob_DataQualitySpec); ok {
		return x.DataQualitySpec
	}
	return nil
}

func (x *DataScanJob) GetDataProfileSpec() *DataProfileSpec {
	if x, ok := x.GetSpec().(*DataScanJob_DataProfileSpec); ok {
		return x.DataProfileSpec
	}
	return nil
}

func (m *DataScanJob) GetResult() isDataScanJob_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *DataScanJob) GetDataQualityResult() *DataQualityResult {
	if x, ok := x.GetResult().(*DataScanJob_DataQualityResult); ok {
		return x.DataQualityResult
	}
	return nil
}

func (x *DataScanJob) GetDataProfileResult() *DataProfileResult {
	if x, ok := x.GetResult().(*DataScanJob_DataProfileResult); ok {
		return x.DataProfileResult
	}
	return nil
}

type isDataScanJob_Spec interface {
	isDataScanJob_Spec()
}

type DataScanJob_DataQualitySpec struct {
	// Output only. DataQualityScan related setting.
	DataQualitySpec *DataQualitySpec `protobuf:"bytes,100,opt,name=data_quality_spec,json=dataQualitySpec,proto3,oneof"`
}

type DataScanJob_DataProfileSpec struct {
	// Output only. DataProfileScan related setting.
	DataProfileSpec *DataProfileSpec `protobuf:"bytes,101,opt,name=data_profile_spec,json=dataProfileSpec,proto3,oneof"`
}

func (*DataScanJob_DataQualitySpec) isDataScanJob_Spec() {}

func (*DataScanJob_DataProfileSpec) isDataScanJob_Spec() {}

type isDataScanJob_Result interface {
	isDataScanJob_Result()
}

type DataScanJob_DataQualityResult struct {
	// Output only. The result of the data quality scan.
	DataQualityResult *DataQualityResult `protobuf:"bytes,200,opt,name=data_quality_result,json=dataQualityResult,proto3,oneof"`
}

type DataScanJob_DataProfileResult struct {
	// Output only. The result of the data profile scan.
	DataProfileResult *DataProfileResult `protobuf:"bytes,201,opt,name=data_profile_result,json=dataProfileResult,proto3,oneof"`
}

func (*DataScanJob_DataQualityResult) isDataScanJob_Result() {}

func (*DataScanJob_DataProfileResult) isDataScanJob_Result() {}

// DataScan execution settings.
type DataScan_ExecutionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Spec related to how often and when a scan should be triggered.
	//
	// If not specified, the default is `OnDemand`, which means the scan will
	// not run until the user calls `RunDataScan` API.
	Trigger *Trigger `protobuf:"bytes,1,opt,name=trigger,proto3" json:"trigger,omitempty"`
	// Spec related to incremental scan of the data
	//
	// When an option is selected for incremental scan, it cannot be unset or
	// changed. If not specified, a data scan will run for all data in the
	// table.
	//
	// Types that are assignable to Incremental:
	//	*DataScan_ExecutionSpec_Field
	Incremental isDataScan_ExecutionSpec_Incremental `protobuf_oneof:"incremental"`
}

func (x *DataScan_ExecutionSpec) Reset() {
	*x = DataScan_ExecutionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataScan_ExecutionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataScan_ExecutionSpec) ProtoMessage() {}

func (x *DataScan_ExecutionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataScan_ExecutionSpec.ProtoReflect.Descriptor instead.
func (*DataScan_ExecutionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{11, 0}
}

func (x *DataScan_ExecutionSpec) GetTrigger() *Trigger {
	if x != nil {
		return x.Trigger
	}
	return nil
}

func (m *DataScan_ExecutionSpec) GetIncremental() isDataScan_ExecutionSpec_Incremental {
	if m != nil {
		return m.Incremental
	}
	return nil
}

func (x *DataScan_ExecutionSpec) GetField() string {
	if x, ok := x.GetIncremental().(*DataScan_ExecutionSpec_Field); ok {
		return x.Field
	}
	return ""
}

type isDataScan_ExecutionSpec_Incremental interface {
	isDataScan_ExecutionSpec_Incremental()
}

type DataScan_ExecutionSpec_Field struct {
	// Immutable. The unnested field (of type *Date* or *Timestamp*) that
	// contains values which monotonically increase over time.
	//
	// If not specified, a data scan will run for all data in the table.
	Field string `protobuf:"bytes,100,opt,name=field,proto3,oneof"`
}

func (*DataScan_ExecutionSpec_Field) isDataScan_ExecutionSpec_Incremental() {}

// Status of the data scan execution.
type DataScan_ExecutionStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time when the latest DataScanJob started.
	LatestJobStartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=latest_job_start_time,json=latestJobStartTime,proto3" json:"latest_job_start_time,omitempty"`
	// The time when the latest DataScanJob ended.
	LatestJobEndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=latest_job_end_time,json=latestJobEndTime,proto3" json:"latest_job_end_time,omitempty"`
}

func (x *DataScan_ExecutionStatus) Reset() {
	*x = DataScan_ExecutionStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataScan_ExecutionStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataScan_ExecutionStatus) ProtoMessage() {}

func (x *DataScan_ExecutionStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_datascans_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataScan_ExecutionStatus.ProtoReflect.Descriptor instead.
func (*DataScan_ExecutionStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP(), []int{11, 1}
}

func (x *DataScan_ExecutionStatus) GetLatestJobStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LatestJobStartTime
	}
	return nil
}

func (x *DataScan_ExecutionStatus) GetLatestJobEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LatestJobEndTime
	}
	return nil
}

var File_google_cloud_dataplex_v1_datascans_proto protoreflect.FileDescriptor

var file_google_cloud_dataplex_v1_datascans_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x63, 0x61, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76,
	0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31,
	0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xf1, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x44, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x25, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73,
	0x63, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x49, 0x64, 0x12, 0x28, 0x0a,
	0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xc9, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x44, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f,
	0x6e, 0x6c, 0x79, 0x22, 0x55, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x22, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x61, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xeb, 0x01, 0x0a, 0x12, 0x47,
	0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x52, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x61, 0x6e, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76,
	0x69, 0x65, 0x77, 0x22, 0x43, 0x0a, 0x0c, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x56,
	0x69, 0x65, 0x77, 0x12, 0x1e, 0x0a, 0x1a, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x53, 0x43, 0x41, 0x4e,
	0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x08,
	0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x0a, 0x22, 0xdc, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa4, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x41, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x61, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x52,
	0x0a, 0x12, 0x52, 0x75, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x4e, 0x0a, 0x13, 0x52, 0x75, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x03, 0x6a, 0x6f, 0x62,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x03, 0x6a,
	0x6f, 0x62, 0x22, 0xfe, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x25, 0x0a, 0x23, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x4a, 0x0a, 0x0f, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x56, 0x69, 0x65, 0x77, 0x12, 0x22, 0x0a, 0x1e, 0x44, 0x41,
	0x54, 0x41, 0x5f, 0x53, 0x43, 0x41, 0x4e, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x56, 0x49, 0x45, 0x57,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c,
	0x4c, 0x10, 0x0a, 0x22, 0xbe, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x22, 0x8f, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4b, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x5f, 0x6a,
	0x6f, 0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62,
	0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb3, 0x0c, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x61, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03,
	0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03,
	0x75, 0x69, 0x64, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x3a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3d, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5c,
	0x0a, 0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x62, 0x0a, 0x10,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x3f, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x61, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x57, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x51,
	0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x57, 0x0a, 0x11, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x63,
	0x48, 0x00, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x63, 0x0a, 0x13, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x71, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0xc8, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x11, 0x64, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x63, 0x0a, 0x13, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0xc9, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x11, 0x64, 0x61, 0x74, 0x61,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0x7d, 0x0a,
	0x0d, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x40,
	0x0a, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x12, 0x1b, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x64, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x0d, 0x0a,
	0x0b, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x1a, 0xab, 0x01, 0x0a,
	0x0f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x4d, 0x0a, 0x15, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x12, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x49, 0x0a, 0x13, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74,
	0x4a, 0x6f, 0x62, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x63, 0xea, 0x41, 0x60, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x3c, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x2f,
	0x7b, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x7d, 0x42, 0x06, 0x0a, 0x04, 0x73, 0x70,
	0x65, 0x63, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xdf, 0x07, 0x0a,
	0x0b, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x3e, 0x0a, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x1d, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x3f, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x5c, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0f, 0x64,
	0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5c,
	0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0f, 0x64, 0x61, 0x74,
	0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x63, 0x0a, 0x13,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0xc8, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x11,
	0x64, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x63, 0x0a, 0x13, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0xc9, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x48, 0x01, 0x52, 0x11, 0x64, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x71, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x49, 0x4e, 0x47,
	0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10,
	0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x04,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07,
	0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x3a, 0x71, 0xea, 0x41, 0x6e, 0x0a, 0x23,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e,
	0x4a, 0x6f, 0x62, 0x12, 0x47, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e,
	0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x7d, 0x42, 0x06, 0x0a, 0x04,
	0x73, 0x70, 0x65, 0x63, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2a, 0x52,
	0x0a, 0x0c, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e,
	0x0a, 0x1a, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x53, 0x43, 0x41, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10,
	0x0a, 0x0c, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x51, 0x55, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x10, 0x01,
	0x12, 0x10, 0x0a, 0x0c, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45,
	0x10, 0x02, 0x32, 0xf2, 0x0c, 0x0a, 0x0f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xe3, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x80, 0x01, 0xca, 0x41, 0x1d, 0x0a,
	0x08, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1d, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x2c,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3a, 0x3a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x22, 0x2d, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x12, 0xe5, 0x01, 0x0a,
	0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x12,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x82, 0x01, 0xca, 0x41, 0x1d, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x15, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44,
	0x3a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x32, 0x37, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcb, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x69, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2f, 0x2a, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0x9d, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x61, 0x6e, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x61, 0x6e, 0x22, 0x3c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xb0, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x61, 0x6e, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x61, 0x6e, 0x73, 0x12, 0xaf, 0x01, 0x0a, 0x0b, 0x52, 0x75, 0x6e, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x75, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x75, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x43, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x36, 0x3a, 0x01, 0x2a, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x75, 0x6e, 0x12, 0xad, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61,
	0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a,
	0x6f, 0x62, 0x22, 0x43, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc0, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x45, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x1a, 0x4b, 0xca, 0x41, 0x17, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x6a, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x42, 0x0e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61,
	0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataplex_v1_datascans_proto_rawDescOnce sync.Once
	file_google_cloud_dataplex_v1_datascans_proto_rawDescData = file_google_cloud_dataplex_v1_datascans_proto_rawDesc
)

func file_google_cloud_dataplex_v1_datascans_proto_rawDescGZIP() []byte {
	file_google_cloud_dataplex_v1_datascans_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataplex_v1_datascans_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataplex_v1_datascans_proto_rawDescData)
	})
	return file_google_cloud_dataplex_v1_datascans_proto_rawDescData
}

var file_google_cloud_dataplex_v1_datascans_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_dataplex_v1_datascans_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_google_cloud_dataplex_v1_datascans_proto_goTypes = []interface{}{
	(DataScanType)(0),                          // 0: google.cloud.dataplex.v1.DataScanType
	(GetDataScanRequest_DataScanView)(0),       // 1: google.cloud.dataplex.v1.GetDataScanRequest.DataScanView
	(GetDataScanJobRequest_DataScanJobView)(0), // 2: google.cloud.dataplex.v1.GetDataScanJobRequest.DataScanJobView
	(DataScanJob_State)(0),                     // 3: google.cloud.dataplex.v1.DataScanJob.State
	(*CreateDataScanRequest)(nil),              // 4: google.cloud.dataplex.v1.CreateDataScanRequest
	(*UpdateDataScanRequest)(nil),              // 5: google.cloud.dataplex.v1.UpdateDataScanRequest
	(*DeleteDataScanRequest)(nil),              // 6: google.cloud.dataplex.v1.DeleteDataScanRequest
	(*GetDataScanRequest)(nil),                 // 7: google.cloud.dataplex.v1.GetDataScanRequest
	(*ListDataScansRequest)(nil),               // 8: google.cloud.dataplex.v1.ListDataScansRequest
	(*ListDataScansResponse)(nil),              // 9: google.cloud.dataplex.v1.ListDataScansResponse
	(*RunDataScanRequest)(nil),                 // 10: google.cloud.dataplex.v1.RunDataScanRequest
	(*RunDataScanResponse)(nil),                // 11: google.cloud.dataplex.v1.RunDataScanResponse
	(*GetDataScanJobRequest)(nil),              // 12: google.cloud.dataplex.v1.GetDataScanJobRequest
	(*ListDataScanJobsRequest)(nil),            // 13: google.cloud.dataplex.v1.ListDataScanJobsRequest
	(*ListDataScanJobsResponse)(nil),           // 14: google.cloud.dataplex.v1.ListDataScanJobsResponse
	(*DataScan)(nil),                           // 15: google.cloud.dataplex.v1.DataScan
	(*DataScanJob)(nil),                        // 16: google.cloud.dataplex.v1.DataScanJob
	(*DataScan_ExecutionSpec)(nil),             // 17: google.cloud.dataplex.v1.DataScan.ExecutionSpec
	(*DataScan_ExecutionStatus)(nil),           // 18: google.cloud.dataplex.v1.DataScan.ExecutionStatus
	nil,                                        // 19: google.cloud.dataplex.v1.DataScan.LabelsEntry
	(*fieldmaskpb.FieldMask)(nil),              // 20: google.protobuf.FieldMask
	(State)(0),                                 // 21: google.cloud.dataplex.v1.State
	(*timestamppb.Timestamp)(nil),              // 22: google.protobuf.Timestamp
	(*DataSource)(nil),                         // 23: google.cloud.dataplex.v1.DataSource
	(*DataQualitySpec)(nil),                    // 24: google.cloud.dataplex.v1.DataQualitySpec
	(*DataProfileSpec)(nil),                    // 25: google.cloud.dataplex.v1.DataProfileSpec
	(*DataQualityResult)(nil),                  // 26: google.cloud.dataplex.v1.DataQualityResult
	(*DataProfileResult)(nil),                  // 27: google.cloud.dataplex.v1.DataProfileResult
	(*Trigger)(nil),                            // 28: google.cloud.dataplex.v1.Trigger
	(*longrunningpb.Operation)(nil),            // 29: google.longrunning.Operation
}
var file_google_cloud_dataplex_v1_datascans_proto_depIdxs = []int32{
	15, // 0: google.cloud.dataplex.v1.CreateDataScanRequest.data_scan:type_name -> google.cloud.dataplex.v1.DataScan
	15, // 1: google.cloud.dataplex.v1.UpdateDataScanRequest.data_scan:type_name -> google.cloud.dataplex.v1.DataScan
	20, // 2: google.cloud.dataplex.v1.UpdateDataScanRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,  // 3: google.cloud.dataplex.v1.GetDataScanRequest.view:type_name -> google.cloud.dataplex.v1.GetDataScanRequest.DataScanView
	15, // 4: google.cloud.dataplex.v1.ListDataScansResponse.data_scans:type_name -> google.cloud.dataplex.v1.DataScan
	16, // 5: google.cloud.dataplex.v1.RunDataScanResponse.job:type_name -> google.cloud.dataplex.v1.DataScanJob
	2,  // 6: google.cloud.dataplex.v1.GetDataScanJobRequest.view:type_name -> google.cloud.dataplex.v1.GetDataScanJobRequest.DataScanJobView
	16, // 7: google.cloud.dataplex.v1.ListDataScanJobsResponse.data_scan_jobs:type_name -> google.cloud.dataplex.v1.DataScanJob
	19, // 8: google.cloud.dataplex.v1.DataScan.labels:type_name -> google.cloud.dataplex.v1.DataScan.LabelsEntry
	21, // 9: google.cloud.dataplex.v1.DataScan.state:type_name -> google.cloud.dataplex.v1.State
	22, // 10: google.cloud.dataplex.v1.DataScan.create_time:type_name -> google.protobuf.Timestamp
	22, // 11: google.cloud.dataplex.v1.DataScan.update_time:type_name -> google.protobuf.Timestamp
	23, // 12: google.cloud.dataplex.v1.DataScan.data:type_name -> google.cloud.dataplex.v1.DataSource
	17, // 13: google.cloud.dataplex.v1.DataScan.execution_spec:type_name -> google.cloud.dataplex.v1.DataScan.ExecutionSpec
	18, // 14: google.cloud.dataplex.v1.DataScan.execution_status:type_name -> google.cloud.dataplex.v1.DataScan.ExecutionStatus
	0,  // 15: google.cloud.dataplex.v1.DataScan.type:type_name -> google.cloud.dataplex.v1.DataScanType
	24, // 16: google.cloud.dataplex.v1.DataScan.data_quality_spec:type_name -> google.cloud.dataplex.v1.DataQualitySpec
	25, // 17: google.cloud.dataplex.v1.DataScan.data_profile_spec:type_name -> google.cloud.dataplex.v1.DataProfileSpec
	26, // 18: google.cloud.dataplex.v1.DataScan.data_quality_result:type_name -> google.cloud.dataplex.v1.DataQualityResult
	27, // 19: google.cloud.dataplex.v1.DataScan.data_profile_result:type_name -> google.cloud.dataplex.v1.DataProfileResult
	22, // 20: google.cloud.dataplex.v1.DataScanJob.start_time:type_name -> google.protobuf.Timestamp
	22, // 21: google.cloud.dataplex.v1.DataScanJob.end_time:type_name -> google.protobuf.Timestamp
	3,  // 22: google.cloud.dataplex.v1.DataScanJob.state:type_name -> google.cloud.dataplex.v1.DataScanJob.State
	0,  // 23: google.cloud.dataplex.v1.DataScanJob.type:type_name -> google.cloud.dataplex.v1.DataScanType
	24, // 24: google.cloud.dataplex.v1.DataScanJob.data_quality_spec:type_name -> google.cloud.dataplex.v1.DataQualitySpec
	25, // 25: google.cloud.dataplex.v1.DataScanJob.data_profile_spec:type_name -> google.cloud.dataplex.v1.DataProfileSpec
	26, // 26: google.cloud.dataplex.v1.DataScanJob.data_quality_result:type_name -> google.cloud.dataplex.v1.DataQualityResult
	27, // 27: google.cloud.dataplex.v1.DataScanJob.data_profile_result:type_name -> google.cloud.dataplex.v1.DataProfileResult
	28, // 28: google.cloud.dataplex.v1.DataScan.ExecutionSpec.trigger:type_name -> google.cloud.dataplex.v1.Trigger
	22, // 29: google.cloud.dataplex.v1.DataScan.ExecutionStatus.latest_job_start_time:type_name -> google.protobuf.Timestamp
	22, // 30: google.cloud.dataplex.v1.DataScan.ExecutionStatus.latest_job_end_time:type_name -> google.protobuf.Timestamp
	4,  // 31: google.cloud.dataplex.v1.DataScanService.CreateDataScan:input_type -> google.cloud.dataplex.v1.CreateDataScanRequest
	5,  // 32: google.cloud.dataplex.v1.DataScanService.UpdateDataScan:input_type -> google.cloud.dataplex.v1.UpdateDataScanRequest
	6,  // 33: google.cloud.dataplex.v1.DataScanService.DeleteDataScan:input_type -> google.cloud.dataplex.v1.DeleteDataScanRequest
	7,  // 34: google.cloud.dataplex.v1.DataScanService.GetDataScan:input_type -> google.cloud.dataplex.v1.GetDataScanRequest
	8,  // 35: google.cloud.dataplex.v1.DataScanService.ListDataScans:input_type -> google.cloud.dataplex.v1.ListDataScansRequest
	10, // 36: google.cloud.dataplex.v1.DataScanService.RunDataScan:input_type -> google.cloud.dataplex.v1.RunDataScanRequest
	12, // 37: google.cloud.dataplex.v1.DataScanService.GetDataScanJob:input_type -> google.cloud.dataplex.v1.GetDataScanJobRequest
	13, // 38: google.cloud.dataplex.v1.DataScanService.ListDataScanJobs:input_type -> google.cloud.dataplex.v1.ListDataScanJobsRequest
	29, // 39: google.cloud.dataplex.v1.DataScanService.CreateDataScan:output_type -> google.longrunning.Operation
	29, // 40: google.cloud.dataplex.v1.DataScanService.UpdateDataScan:output_type -> google.longrunning.Operation
	29, // 41: google.cloud.dataplex.v1.DataScanService.DeleteDataScan:output_type -> google.longrunning.Operation
	15, // 42: google.cloud.dataplex.v1.DataScanService.GetDataScan:output_type -> google.cloud.dataplex.v1.DataScan
	9,  // 43: google.cloud.dataplex.v1.DataScanService.ListDataScans:output_type -> google.cloud.dataplex.v1.ListDataScansResponse
	11, // 44: google.cloud.dataplex.v1.DataScanService.RunDataScan:output_type -> google.cloud.dataplex.v1.RunDataScanResponse
	16, // 45: google.cloud.dataplex.v1.DataScanService.GetDataScanJob:output_type -> google.cloud.dataplex.v1.DataScanJob
	14, // 46: google.cloud.dataplex.v1.DataScanService.ListDataScanJobs:output_type -> google.cloud.dataplex.v1.ListDataScanJobsResponse
	39, // [39:47] is the sub-list for method output_type
	31, // [31:39] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_google_cloud_dataplex_v1_datascans_proto_init() }
func file_google_cloud_dataplex_v1_datascans_proto_init() {
	if File_google_cloud_dataplex_v1_datascans_proto != nil {
		return
	}
	file_google_cloud_dataplex_v1_data_profile_proto_init()
	file_google_cloud_dataplex_v1_data_quality_proto_init()
	file_google_cloud_dataplex_v1_processing_proto_init()
	file_google_cloud_dataplex_v1_resources_proto_init()
	file_google_cloud_dataplex_v1_service_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dataplex_v1_datascans_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDataScanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_datascans_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDataScanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_datascans_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDataScanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_datascans_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataScanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_datascans_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataScansRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_datascans_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataScansResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_datascans_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunDataScanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_datascans_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunDataScanResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_datascans_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataScanJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_datascans_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataScanJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_datascans_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataScanJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_datascans_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataScan); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_datascans_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataScanJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_datascans_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataScan_ExecutionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_datascans_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataScan_ExecutionStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dataplex_v1_datascans_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*DataScan_DataQualitySpec)(nil),
		(*DataScan_DataProfileSpec)(nil),
		(*DataScan_DataQualityResult)(nil),
		(*DataScan_DataProfileResult)(nil),
	}
	file_google_cloud_dataplex_v1_datascans_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*DataScanJob_DataQualitySpec)(nil),
		(*DataScanJob_DataProfileSpec)(nil),
		(*DataScanJob_DataQualityResult)(nil),
		(*DataScanJob_DataProfileResult)(nil),
	}
	file_google_cloud_dataplex_v1_datascans_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*DataScan_ExecutionSpec_Field)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataplex_v1_datascans_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dataplex_v1_datascans_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataplex_v1_datascans_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataplex_v1_datascans_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataplex_v1_datascans_proto_msgTypes,
	}.Build()
	File_google_cloud_dataplex_v1_datascans_proto = out.File
	file_google_cloud_dataplex_v1_datascans_proto_rawDesc = nil
	file_google_cloud_dataplex_v1_datascans_proto_goTypes = nil
	file_google_cloud_dataplex_v1_datascans_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DataScanServiceClient is the client API for DataScanService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataScanServiceClient interface {
	// Creates a DataScan resource.
	CreateDataScan(ctx context.Context, in *CreateDataScanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a DataScan resource.
	UpdateDataScan(ctx context.Context, in *UpdateDataScanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a DataScan resource.
	DeleteDataScan(ctx context.Context, in *DeleteDataScanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a DataScan resource.
	GetDataScan(ctx context.Context, in *GetDataScanRequest, opts ...grpc.CallOption) (*DataScan, error)
	// Lists DataScans.
	ListDataScans(ctx context.Context, in *ListDataScansRequest, opts ...grpc.CallOption) (*ListDataScansResponse, error)
	// Runs an on-demand execution of a DataScan
	RunDataScan(ctx context.Context, in *RunDataScanRequest, opts ...grpc.CallOption) (*RunDataScanResponse, error)
	// Gets a DataScanJob resource.
	GetDataScanJob(ctx context.Context, in *GetDataScanJobRequest, opts ...grpc.CallOption) (*DataScanJob, error)
	// Lists DataScanJobs under the given DataScan.
	ListDataScanJobs(ctx context.Context, in *ListDataScanJobsRequest, opts ...grpc.CallOption) (*ListDataScanJobsResponse, error)
}

type dataScanServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDataScanServiceClient(cc grpc.ClientConnInterface) DataScanServiceClient {
	return &dataScanServiceClient{cc}
}

func (c *dataScanServiceClient) CreateDataScan(ctx context.Context, in *CreateDataScanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.DataScanService/CreateDataScan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataScanServiceClient) UpdateDataScan(ctx context.Context, in *UpdateDataScanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.DataScanService/UpdateDataScan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataScanServiceClient) DeleteDataScan(ctx context.Context, in *DeleteDataScanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.DataScanService/DeleteDataScan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataScanServiceClient) GetDataScan(ctx context.Context, in *GetDataScanRequest, opts ...grpc.CallOption) (*DataScan, error) {
	out := new(DataScan)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.DataScanService/GetDataScan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataScanServiceClient) ListDataScans(ctx context.Context, in *ListDataScansRequest, opts ...grpc.CallOption) (*ListDataScansResponse, error) {
	out := new(ListDataScansResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.DataScanService/ListDataScans", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataScanServiceClient) RunDataScan(ctx context.Context, in *RunDataScanRequest, opts ...grpc.CallOption) (*RunDataScanResponse, error) {
	out := new(RunDataScanResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.DataScanService/RunDataScan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataScanServiceClient) GetDataScanJob(ctx context.Context, in *GetDataScanJobRequest, opts ...grpc.CallOption) (*DataScanJob, error) {
	out := new(DataScanJob)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.DataScanService/GetDataScanJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataScanServiceClient) ListDataScanJobs(ctx context.Context, in *ListDataScanJobsRequest, opts ...grpc.CallOption) (*ListDataScanJobsResponse, error) {
	out := new(ListDataScanJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataplex.v1.DataScanService/ListDataScanJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataScanServiceServer is the server API for DataScanService service.
type DataScanServiceServer interface {
	// Creates a DataScan resource.
	CreateDataScan(context.Context, *CreateDataScanRequest) (*longrunningpb.Operation, error)
	// Updates a DataScan resource.
	UpdateDataScan(context.Context, *UpdateDataScanRequest) (*longrunningpb.Operation, error)
	// Deletes a DataScan resource.
	DeleteDataScan(context.Context, *DeleteDataScanRequest) (*longrunningpb.Operation, error)
	// Gets a DataScan resource.
	GetDataScan(context.Context, *GetDataScanRequest) (*DataScan, error)
	// Lists DataScans.
	ListDataScans(context.Context, *ListDataScansRequest) (*ListDataScansResponse, error)
	// Runs an on-demand execution of a DataScan
	RunDataScan(context.Context, *RunDataScanRequest) (*RunDataScanResponse, error)
	// Gets a DataScanJob resource.
	GetDataScanJob(context.Context, *GetDataScanJobRequest) (*DataScanJob, error)
	// Lists DataScanJobs under the given DataScan.
	ListDataScanJobs(context.Context, *ListDataScanJobsRequest) (*ListDataScanJobsResponse, error)
}

// UnimplementedDataScanServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDataScanServiceServer struct {
}

func (*UnimplementedDataScanServiceServer) CreateDataScan(context.Context, *CreateDataScanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataScan not implemented")
}
func (*UnimplementedDataScanServiceServer) UpdateDataScan(context.Context, *UpdateDataScanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataScan not implemented")
}
func (*UnimplementedDataScanServiceServer) DeleteDataScan(context.Context, *DeleteDataScanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataScan not implemented")
}
func (*UnimplementedDataScanServiceServer) GetDataScan(context.Context, *GetDataScanRequest) (*DataScan, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataScan not implemented")
}
func (*UnimplementedDataScanServiceServer) ListDataScans(context.Context, *ListDataScansRequest) (*ListDataScansResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataScans not implemented")
}
func (*UnimplementedDataScanServiceServer) RunDataScan(context.Context, *RunDataScanRequest) (*RunDataScanResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunDataScan not implemented")
}
func (*UnimplementedDataScanServiceServer) GetDataScanJob(context.Context, *GetDataScanJobRequest) (*DataScanJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataScanJob not implemented")
}
func (*UnimplementedDataScanServiceServer) ListDataScanJobs(context.Context, *ListDataScanJobsRequest) (*ListDataScanJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataScanJobs not implemented")
}

func RegisterDataScanServiceServer(s *grpc.Server, srv DataScanServiceServer) {
	s.RegisterService(&_DataScanService_serviceDesc, srv)
}

func _DataScanService_CreateDataScan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDataScanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataScanServiceServer).CreateDataScan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.DataScanService/CreateDataScan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataScanServiceServer).CreateDataScan(ctx, req.(*CreateDataScanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataScanService_UpdateDataScan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataScanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataScanServiceServer).UpdateDataScan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.DataScanService/UpdateDataScan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataScanServiceServer).UpdateDataScan(ctx, req.(*UpdateDataScanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataScanService_DeleteDataScan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDataScanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataScanServiceServer).DeleteDataScan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.DataScanService/DeleteDataScan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataScanServiceServer).DeleteDataScan(ctx, req.(*DeleteDataScanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataScanService_GetDataScan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataScanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataScanServiceServer).GetDataScan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.DataScanService/GetDataScan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataScanServiceServer).GetDataScan(ctx, req.(*GetDataScanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataScanService_ListDataScans_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataScansRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataScanServiceServer).ListDataScans(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.DataScanService/ListDataScans",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataScanServiceServer).ListDataScans(ctx, req.(*ListDataScansRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataScanService_RunDataScan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunDataScanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataScanServiceServer).RunDataScan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.DataScanService/RunDataScan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataScanServiceServer).RunDataScan(ctx, req.(*RunDataScanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataScanService_GetDataScanJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataScanJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataScanServiceServer).GetDataScanJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.DataScanService/GetDataScanJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataScanServiceServer).GetDataScanJob(ctx, req.(*GetDataScanJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataScanService_ListDataScanJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataScanJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataScanServiceServer).ListDataScanJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataplex.v1.DataScanService/ListDataScanJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataScanServiceServer).ListDataScanJobs(ctx, req.(*ListDataScanJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataScanService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataplex.v1.DataScanService",
	HandlerType: (*DataScanServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDataScan",
			Handler:    _DataScanService_CreateDataScan_Handler,
		},
		{
			MethodName: "UpdateDataScan",
			Handler:    _DataScanService_UpdateDataScan_Handler,
		},
		{
			MethodName: "DeleteDataScan",
			Handler:    _DataScanService_DeleteDataScan_Handler,
		},
		{
			MethodName: "GetDataScan",
			Handler:    _DataScanService_GetDataScan_Handler,
		},
		{
			MethodName: "ListDataScans",
			Handler:    _DataScanService_ListDataScans_Handler,
		},
		{
			MethodName: "RunDataScan",
			Handler:    _DataScanService_RunDataScan_Handler,
		},
		{
			MethodName: "GetDataScanJob",
			Handler:    _DataScanService_GetDataScanJob_Handler,
		},
		{
			MethodName: "ListDataScanJobs",
			Handler:    _DataScanService_ListDataScanJobs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataplex/v1/datascans.proto",
}
