// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/maps/fleetengine/delivery/v1/delivery_api.proto

package deliverypb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	viewport "google.golang.org/genproto/googleapis/geo/type/viewport"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The `CreateDeliveryVehicle` request message.
type CreateDeliveryVehicleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The standard Delivery API request header.
	Header *DeliveryRequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Required. Must be in the format `providers/{provider}`. The provider must
	// be the Google Cloud Project ID. For example, `sample-cloud-project`.
	Parent string `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Delivery Vehicle ID must be unique and subject to the
	// following restrictions:
	//
	// * Must be a valid Unicode string.
	// * Limited to a maximum length of 64 characters.
	// * Normalized according to [Unicode Normalization Form C]
	// (http://www.unicode.org/reports/tr15/).
	// * May not contain any of the following ASCII characters: '/', ':', '?',
	// ',', or '#'.
	DeliveryVehicleId string `protobuf:"bytes,4,opt,name=delivery_vehicle_id,json=deliveryVehicleId,proto3" json:"delivery_vehicle_id,omitempty"`
	// Required. The `DeliveryVehicle` entity to create. When creating a new
	// delivery vehicle, you may set the following optional fields:
	//
	// * type
	// * last_location
	// * attributes
	//
	// Note: The DeliveryVehicle's `name` field is ignored. All other
	// DeliveryVehicle fields must not be set; otherwise, an error is returned.
	DeliveryVehicle *DeliveryVehicle `protobuf:"bytes,5,opt,name=delivery_vehicle,json=deliveryVehicle,proto3" json:"delivery_vehicle,omitempty"`
}

func (x *CreateDeliveryVehicleRequest) Reset() {
	*x = CreateDeliveryVehicleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDeliveryVehicleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDeliveryVehicleRequest) ProtoMessage() {}

func (x *CreateDeliveryVehicleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDeliveryVehicleRequest.ProtoReflect.Descriptor instead.
func (*CreateDeliveryVehicleRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescGZIP(), []int{0}
}

func (x *CreateDeliveryVehicleRequest) GetHeader() *DeliveryRequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *CreateDeliveryVehicleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDeliveryVehicleRequest) GetDeliveryVehicleId() string {
	if x != nil {
		return x.DeliveryVehicleId
	}
	return ""
}

func (x *CreateDeliveryVehicleRequest) GetDeliveryVehicle() *DeliveryVehicle {
	if x != nil {
		return x.DeliveryVehicle
	}
	return nil
}

// The `GetDeliveryVehicle` request message.
type GetDeliveryVehicleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The standard Delivery API request header.
	Header *DeliveryRequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Required. Must be in the format
	// `providers/{provider}/deliveryVehicles/{delivery_vehicle}`.
	// The `provider` must be the Google Cloud Project ID. For example,
	// `sample-cloud-project`.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDeliveryVehicleRequest) Reset() {
	*x = GetDeliveryVehicleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDeliveryVehicleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeliveryVehicleRequest) ProtoMessage() {}

func (x *GetDeliveryVehicleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeliveryVehicleRequest.ProtoReflect.Descriptor instead.
func (*GetDeliveryVehicleRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescGZIP(), []int{1}
}

func (x *GetDeliveryVehicleRequest) GetHeader() *DeliveryRequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetDeliveryVehicleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The `ListDeliveryVehicles` request message.
type ListDeliveryVehiclesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The standard Delivery API request header.
	Header *DeliveryRequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Required. Must be in the format `providers/{provider}`.
	// The `provider` must be the Google Cloud Project ID.
	// For example, `sample-cloud-project`.
	Parent string `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of vehicles to return. The service may return
	// fewer than this number. If you don't specify this number, then the server
	// determines the number of results to return.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListDeliveryVehicles`
	// call. You must provide this in order to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListDeliveryVehicles`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A filter query to apply when listing delivery vehicles. See
	// http://aip.dev/160 for examples of the filter syntax. If you don't specify
	// a value, or if you specify an empty string for the filter, then all
	// delivery vehicles are returned.
	//
	// Note that the only queries supported for `ListDeliveryVehicles` are
	// on vehicle attributes (for example, `attributes.<key> = <value>` or
	// `attributes.<key1> = <value1> AND attributes.<key2> = <value2>`). Also, all
	// attributes are stored as strings, so the only supported comparisons against
	// attributes are string comparisons. In order to compare against number or
	// boolean values, the values must be explicitly quoted to be treated as
	// strings (for example, `attributes.<key> = "10"` or
	// `attributes.<key> = "true"`).
	//
	// The maximum number of restrictions allowed in a filter query is 50. A
	// restriction is a part of the query of the form
	// `attribute.<KEY> <COMPARATOR> <VALUE>`, for example `attributes.foo = bar`
	// is 1 restriction.
	Filter string `protobuf:"bytes,6,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. A filter that limits the vehicles returned to those whose last
	// known location was in the rectangular area defined by the viewport.
	Viewport *viewport.Viewport `protobuf:"bytes,7,opt,name=viewport,proto3" json:"viewport,omitempty"`
}

func (x *ListDeliveryVehiclesRequest) Reset() {
	*x = ListDeliveryVehiclesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDeliveryVehiclesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeliveryVehiclesRequest) ProtoMessage() {}

func (x *ListDeliveryVehiclesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeliveryVehiclesRequest.ProtoReflect.Descriptor instead.
func (*ListDeliveryVehiclesRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescGZIP(), []int{2}
}

func (x *ListDeliveryVehiclesRequest) GetHeader() *DeliveryRequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *ListDeliveryVehiclesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDeliveryVehiclesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDeliveryVehiclesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDeliveryVehiclesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDeliveryVehiclesRequest) GetViewport() *viewport.Viewport {
	if x != nil {
		return x.Viewport
	}
	return nil
}

// The `ListDeliveryVehicles` response message.
type ListDeliveryVehiclesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of delivery vehicles that meet the requested filtering criteria.
	// When no filter is specified, the request returns all delivery vehicles. A
	// successful response can also be empty. An empty response indicates that no
	// delivery vehicles were found meeting the requested filter criteria.
	DeliveryVehicles []*DeliveryVehicle `protobuf:"bytes,1,rep,name=delivery_vehicles,json=deliveryVehicles,proto3" json:"delivery_vehicles,omitempty"`
	// You can pass this token in the `ListDeliveryVehiclesRequest` to continue to
	// list results. When all of the results are returned, this field won't be in
	// the response, or it will be an empty string.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of delivery vehicles that match the request criteria,
	// across all pages.
	TotalSize int64 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListDeliveryVehiclesResponse) Reset() {
	*x = ListDeliveryVehiclesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDeliveryVehiclesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeliveryVehiclesResponse) ProtoMessage() {}

func (x *ListDeliveryVehiclesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeliveryVehiclesResponse.ProtoReflect.Descriptor instead.
func (*ListDeliveryVehiclesResponse) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescGZIP(), []int{3}
}

func (x *ListDeliveryVehiclesResponse) GetDeliveryVehicles() []*DeliveryVehicle {
	if x != nil {
		return x.DeliveryVehicles
	}
	return nil
}

func (x *ListDeliveryVehiclesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListDeliveryVehiclesResponse) GetTotalSize() int64 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// The `UpdateDeliveryVehicle` request message.
type UpdateDeliveryVehicleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The standard Delivery API request header.
	Header *DeliveryRequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Required. The `DeliveryVehicle` entity update to apply.
	// Note: You cannot update the name of the `DeliveryVehicle`.
	DeliveryVehicle *DeliveryVehicle `protobuf:"bytes,3,opt,name=delivery_vehicle,json=deliveryVehicle,proto3" json:"delivery_vehicle,omitempty"`
	// Required. A field mask that indicates which `DeliveryVehicle` fields to
	// update. Note that the update_mask must contain at least one field.
	//
	// This is a comma-separated list of fully qualified names of fields. Example:
	// `"remaining_vehicle_journey_segments"`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDeliveryVehicleRequest) Reset() {
	*x = UpdateDeliveryVehicleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDeliveryVehicleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDeliveryVehicleRequest) ProtoMessage() {}

func (x *UpdateDeliveryVehicleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDeliveryVehicleRequest.ProtoReflect.Descriptor instead.
func (*UpdateDeliveryVehicleRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateDeliveryVehicleRequest) GetHeader() *DeliveryRequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *UpdateDeliveryVehicleRequest) GetDeliveryVehicle() *DeliveryVehicle {
	if x != nil {
		return x.DeliveryVehicle
	}
	return nil
}

func (x *UpdateDeliveryVehicleRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The `BatchCreateTask` request message.
type BatchCreateTasksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The standard Delivery API request header.
	// Note: If you set this field, then the header field in the
	// `CreateTaskRequest` messages must either be empty, or it must match this
	// field.
	Header *DeliveryRequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Required. The parent resource shared by all tasks. This value must be in
	// the format `providers/{provider}`. The `provider` must be the Google Cloud
	// Project ID. For example, `sample-cloud-project`. The parent field in the
	// `CreateTaskRequest` messages must either  be empty, or it must match this
	// field.
	Parent string `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The request message that specifies the resources to create.
	// Note: You can create a maximum of 500 tasks in a batch.
	Requests []*CreateTaskRequest `protobuf:"bytes,4,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchCreateTasksRequest) Reset() {
	*x = BatchCreateTasksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateTasksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateTasksRequest) ProtoMessage() {}

func (x *BatchCreateTasksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateTasksRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateTasksRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescGZIP(), []int{5}
}

func (x *BatchCreateTasksRequest) GetHeader() *DeliveryRequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *BatchCreateTasksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateTasksRequest) GetRequests() []*CreateTaskRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// The `BatchCreateTask` response message.
type BatchCreateTasksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The created Tasks.
	Tasks []*Task `protobuf:"bytes,1,rep,name=tasks,proto3" json:"tasks,omitempty"`
}

func (x *BatchCreateTasksResponse) Reset() {
	*x = BatchCreateTasksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateTasksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateTasksResponse) ProtoMessage() {}

func (x *BatchCreateTasksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateTasksResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateTasksResponse) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescGZIP(), []int{6}
}

func (x *BatchCreateTasksResponse) GetTasks() []*Task {
	if x != nil {
		return x.Tasks
	}
	return nil
}

// The `CreateTask` request message.
type CreateTaskRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The standard Delivery API request header.
	Header *DeliveryRequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Required. Must be in the format `providers/{provider}`. The `provider` must
	// be the Google Cloud Project ID. For example, `sample-cloud-project`.
	Parent string `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Task ID must be unique, but it should be not a shipment
	// tracking ID. To store a shipment tracking ID, use the `tracking_id` field.
	// Note that multiple tasks can have the same `tracking_id`. Task IDs are
	// subject to the following restrictions:
	//
	// * Must be a valid Unicode string.
	// * Limited to a maximum length of 64 characters.
	// * Normalized according to [Unicode Normalization Form C]
	// (http://www.unicode.org/reports/tr15/).
	// * May not contain any of the following ASCII characters: '/', ':', '?',
	// ',', or '#'.
	TaskId string `protobuf:"bytes,5,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Required. The Task entity to create.
	// When creating a Task, the following fields are required:
	//
	// * `type`
	// * `state` (must be set to `OPEN`)
	// * `tracking_id` (must not be set for `UNAVAILABLE` or `SCHEDULED_STOP`
	// tasks, but required for all other task types)
	// * `planned_location` (optional for `UNAVAILABLE` tasks)
	// * `task_duration`
	//
	// Note: The Task's `name` field is ignored. All other Task fields must not be
	// set; otherwise, an error is returned.
	Task *Task `protobuf:"bytes,4,opt,name=task,proto3" json:"task,omitempty"`
}

func (x *CreateTaskRequest) Reset() {
	*x = CreateTaskRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTaskRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTaskRequest) ProtoMessage() {}

func (x *CreateTaskRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTaskRequest.ProtoReflect.Descriptor instead.
func (*CreateTaskRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescGZIP(), []int{7}
}

func (x *CreateTaskRequest) GetHeader() *DeliveryRequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *CreateTaskRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTaskRequest) GetTaskId() string {
	if x != nil {
		return x.TaskId
	}
	return ""
}

func (x *CreateTaskRequest) GetTask() *Task {
	if x != nil {
		return x.Task
	}
	return nil
}

// The `GetTask` request message.
type GetTaskRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The standard Delivery API request header.
	Header *DeliveryRequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Required. Must be in the format `providers/{provider}/tasks/{task}`. The
	// `provider` must be the Google Cloud Project ID. For example,
	// `sample-cloud-project`.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTaskRequest) Reset() {
	*x = GetTaskRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTaskRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTaskRequest) ProtoMessage() {}

func (x *GetTaskRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTaskRequest.ProtoReflect.Descriptor instead.
func (*GetTaskRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescGZIP(), []int{8}
}

func (x *GetTaskRequest) GetHeader() *DeliveryRequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetTaskRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The `UpdateTask` request message.
type UpdateTaskRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The standard Delivery API request header.
	Header *DeliveryRequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Required. The Task associated with the update.
	// The following fields are maintained by Fleet Engine. Do not update
	// them using `Task.update`.
	//
	//   - `last_location`.
	//   - `last_location_snappable`.
	//   - `name`.
	//   - `remaining_vehicle_journey_segments`.
	//   - `task_outcome_location_source`.
	//
	// Note: You cannot change the value of `task_outcome` once you set it.
	//
	// If the Task has been assigned to a delivery vehicle, then don't set the
	// Task state to CLOSED using `Task.update`. Instead, remove the `VehicleStop`
	// that contains the Task from the delivery vehicle, which automatically sets
	// the Task state to CLOSED.
	Task *Task `protobuf:"bytes,3,opt,name=task,proto3" json:"task,omitempty"`
	// Required. The field mask that indicates which Task fields to update.
	// Note: The `update_mask` must contain at least one field.
	//
	// This is a comma-separated list of fully qualified names of fields. Example:
	// `"task_outcome,task_outcome_time,task_outcome_location"`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateTaskRequest) Reset() {
	*x = UpdateTaskRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTaskRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTaskRequest) ProtoMessage() {}

func (x *UpdateTaskRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTaskRequest.ProtoReflect.Descriptor instead.
func (*UpdateTaskRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateTaskRequest) GetHeader() *DeliveryRequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *UpdateTaskRequest) GetTask() *Task {
	if x != nil {
		return x.Task
	}
	return nil
}

func (x *UpdateTaskRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The `ListTasks` request message.
type ListTasksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The standard Delivery API request header.
	Header *DeliveryRequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Required. Must be in the format `providers/{provider}`.
	// The `provider` must be the Google Cloud Project ID. For example,
	// `sample-cloud-project`.
	Parent string `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of Tasks to return. The service may return
	// fewer than this value. If you don't specify this value, then the server
	// determines the number of results to return.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token received from a previous `ListTasks` call.
	// You can provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListTasks` must match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A filter query to apply when listing Tasks. See
	// http://aip.dev/160 for examples of filter syntax. If you don't specify a
	// value, or if you filter on an empty string, then all Tasks are returned.
	// For information about the Task properties that you can filter on, see [List
	// tasks](https://developers.google.com/maps/documentation/mobility/fleet-engine/journeys/tasks/find-tasks#filter_listed_tasks).
	Filter string `protobuf:"bytes,6,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListTasksRequest) Reset() {
	*x = ListTasksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTasksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTasksRequest) ProtoMessage() {}

func (x *ListTasksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTasksRequest.ProtoReflect.Descriptor instead.
func (*ListTasksRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescGZIP(), []int{10}
}

func (x *ListTasksRequest) GetHeader() *DeliveryRequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *ListTasksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTasksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTasksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTasksRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The `ListTasks` response that contains the set of Tasks that meet the filter
// criteria in the `ListTasksRequest`.
type ListTasksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of Tasks that meet the requested filtering criteria. When no filter
	// is specified, the request returns all tasks. A successful response can also
	// be empty. An empty response indicates that no Tasks were found meeting the
	// requested filter criteria.
	Tasks []*Task `protobuf:"bytes,1,rep,name=tasks,proto3" json:"tasks,omitempty"`
	// Pass this token in the `ListTasksRequest` to continue to list results.
	// If all results have been returned, then this field is either an empty
	// string, or it doesn't appear in the response.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of Tasks that match the request criteria, across all
	// pages.
	TotalSize int64 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListTasksResponse) Reset() {
	*x = ListTasksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTasksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTasksResponse) ProtoMessage() {}

func (x *ListTasksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTasksResponse.ProtoReflect.Descriptor instead.
func (*ListTasksResponse) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescGZIP(), []int{11}
}

func (x *ListTasksResponse) GetTasks() []*Task {
	if x != nil {
		return x.Tasks
	}
	return nil
}

func (x *ListTasksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListTasksResponse) GetTotalSize() int64 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// The `GetTaskTrackingInfoRequest` request message.
type GetTaskTrackingInfoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The standard Delivery API request header.
	Header *DeliveryRequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Required. Must be in the format
	// `providers/{provider}/taskTrackingInfo/{tracking_id}`. The `provider`
	// must be the Google Cloud Project ID, and the `tracking_id` must be the
	// tracking ID associated with the task. An example name can be
	// `providers/sample-cloud-project/taskTrackingInfo/sample-tracking-id`.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTaskTrackingInfoRequest) Reset() {
	*x = GetTaskTrackingInfoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTaskTrackingInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTaskTrackingInfoRequest) ProtoMessage() {}

func (x *GetTaskTrackingInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTaskTrackingInfoRequest.ProtoReflect.Descriptor instead.
func (*GetTaskTrackingInfoRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescGZIP(), []int{12}
}

func (x *GetTaskTrackingInfoRequest) GetHeader() *DeliveryRequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetTaskTrackingInfoRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_maps_fleetengine_delivery_v1_delivery_api_proto protoreflect.FileDescriptor

var file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x66, 0x6c,
	0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x61,
	0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66,
	0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x67, 0x65, 0x6f, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x2f, 0x76, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73,
	0x2f, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x5f, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x66, 0x6c,
	0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f,
	0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x64, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x74, 0x72, 0x61,
	0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x66, 0x6c,
	0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xa1, 0x02, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65,
	0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x33, 0x0a, 0x13, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f,
	0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56,
	0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x5d, 0x0a, 0x10, 0x64, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x5f, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x22, 0xb5, 0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x44,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65,
	0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x66,
	0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xda, 0x02, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x50, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x66, 0x6c, 0x65, 0x65, 0x74,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65,
	0x68, 0x69, 0x63, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x3a, 0x0a, 0x08, 0x76, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6f, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x76, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x22, 0xc1, 0x01, 0x0a,
	0x1c, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68,
	0x69, 0x63, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a,
	0x11, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x52, 0x10, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65,
	0x22, 0x91, 0x02, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x50, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x12, 0x5d, 0x0a, 0x10, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f,
	0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63,
	0x6c, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0xfe, 0x01, 0x0a, 0x17, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x50, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x12, 0x1f, 0x66, 0x6c, 0x65, 0x65,
	0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65,
	0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x54, 0x0a, 0x18, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x38, 0x0a, 0x05, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x61, 0x73, 0x6b, 0x52, 0x05, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x22, 0xdd, 0x01, 0x0a, 0x11,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x50, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1c, 0x0a, 0x07, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x74, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x3b,
	0x0a, 0x04, 0x74, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x61, 0x73, 0x6b, 0x22, 0x9f, 0x01, 0x0a, 0x0e,
	0x47, 0x65, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50,
	0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe4, 0x01,
	0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x3b, 0x0a, 0x04, 0x74, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x61,
	0x73, 0x6b, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0x88, 0x02, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x73,
	0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x3f, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x21, 0x12, 0x1f, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x61, 0x73, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22,
	0x94, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38, 0x0a, 0x05, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65,
	0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x05, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xb7, 0x01, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x54, 0x61,
	0x73, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65,
	0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x66,
	0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x73, 0x6b, 0x54, 0x72,
	0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x32, 0x8a, 0x13, 0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0xa1, 0x02, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x12, 0x3a,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69,
	0x63, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x22, 0x9c, 0x01, 0xda, 0x41, 0x2b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x76,
	0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x2c, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f,
	0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d,
	0x3a, 0x10, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x76, 0x65, 0x68, 0x69, 0x63,
	0x6c, 0x65, 0x22, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x8a, 0xd3, 0xe4,
	0x93, 0x02, 0x25, 0x12, 0x23, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x7b,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x3d, 0x70, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdf, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74,
	0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x12,
	0x37, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x22, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x12, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x12, 0x21, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x19, 0x7b, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x3d, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb2, 0x02, 0x0a, 0x15, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68,
	0x69, 0x63, 0x6c, 0x65, 0x12, 0x3a, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65,
	0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2d, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x22,
	0xad, 0x01, 0xda, 0x41, 0x1c, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x76, 0x65,
	0x68, 0x69, 0x63, 0x6c, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x10, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x5f, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x32, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x0a, 0x15, 0x64,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x7b, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x3d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xe3, 0x01, 0x0a, 0x10, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x61, 0x73, 0x6b, 0x73, 0x12, 0x35, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65,
	0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x61, 0x73, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x60, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x3a, 0x01, 0x2a, 0x22, 0x2a,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x3a, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x25,
	0x12, 0x23, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x7b, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x3d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd0, 0x01, 0x0a, 0x0a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x61, 0x73, 0x6b, 0x12, 0x2f, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65,
	0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65,
	0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x22, 0x6d, 0xda, 0x41, 0x13, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x61, 0x73, 0x6b, 0x2c, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69,
	0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x3a, 0x04, 0x74, 0x61, 0x73, 0x6b, 0x22, 0x1e, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x8a, 0xd3, 0xe4,
	0x93, 0x02, 0x25, 0x12, 0x23, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x7b,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x3d, 0x70, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb3, 0x01, 0x0a, 0x07, 0x47, 0x65, 0x74,
	0x54, 0x61, 0x73, 0x6b, 0x12, 0x2c, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65,
	0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x22, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x22, 0x56, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x20, 0x12, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x73,
	0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x12, 0x21, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x19, 0x7b, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x3d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd5,
	0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x12, 0x2f, 0x2e,
	0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61,
	0x73, 0x6b, 0x22, 0x72, 0xda, 0x41, 0x10, 0x74, 0x61, 0x73, 0x6b, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x3a, 0x04, 0x74,
	0x61, 0x73, 0x6b, 0x32, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x74, 0x61, 0x73, 0x6b, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x74, 0x61, 0x73, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x28, 0x12, 0x26,
	0x0a, 0x09, 0x74, 0x61, 0x73, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x7b, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x3d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc8, 0x01, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x54,
	0x61, 0x73, 0x6b, 0x73, 0x12, 0x2e, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65,
	0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65,
	0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x20, 0x12, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x12, 0x23, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x7b, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x3d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xe2, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x54, 0x72, 0x61,
	0x63, 0x6b, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x38, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x61, 0x73, 0x6b,
	0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x49,
	0x6e, 0x66, 0x6f, 0x22, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2b, 0x12, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x54, 0x72,
	0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x2f, 0x2a, 0x7d, 0x8a, 0xd3, 0xe4,
	0x93, 0x02, 0x23, 0x12, 0x21, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x7b, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x3d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf4, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x12,
	0x39, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x65, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x12, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c,
	0x65, 0x73, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x12, 0x23, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x19, 0x7b, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x3d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x4e, 0xca,
	0x41, 0x1a, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xba, 0x02,
	0xea, 0x41, 0x3b, 0x0a, 0x23, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x14, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x7d, 0x0a, 0x23,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65,
	0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x42, 0x0b, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x41, 0x70, 0x69,
	0x50, 0x01, 0x5a, 0x49, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x66, 0x6c, 0x65,
	0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x70, 0x62, 0x3b, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x70, 0x62, 0xa2, 0x02, 0x04,
	0x43, 0x46, 0x45, 0x44, 0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x4d, 0x61,
	0x70, 0x73, 0x2e, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x44,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x4d, 0x61, 0x70, 0x73, 0x5c, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x5c, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x4d, 0x61, 0x70, 0x73, 0x3a,
	0x3a, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x44, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescOnce sync.Once
	file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescData = file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDesc
)

func file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescGZIP() []byte {
	file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescOnce.Do(func() {
		file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescData)
	})
	return file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDescData
}

var file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_maps_fleetengine_delivery_v1_delivery_api_proto_goTypes = []any{
	(*CreateDeliveryVehicleRequest)(nil), // 0: maps.fleetengine.delivery.v1.CreateDeliveryVehicleRequest
	(*GetDeliveryVehicleRequest)(nil),    // 1: maps.fleetengine.delivery.v1.GetDeliveryVehicleRequest
	(*ListDeliveryVehiclesRequest)(nil),  // 2: maps.fleetengine.delivery.v1.ListDeliveryVehiclesRequest
	(*ListDeliveryVehiclesResponse)(nil), // 3: maps.fleetengine.delivery.v1.ListDeliveryVehiclesResponse
	(*UpdateDeliveryVehicleRequest)(nil), // 4: maps.fleetengine.delivery.v1.UpdateDeliveryVehicleRequest
	(*BatchCreateTasksRequest)(nil),      // 5: maps.fleetengine.delivery.v1.BatchCreateTasksRequest
	(*BatchCreateTasksResponse)(nil),     // 6: maps.fleetengine.delivery.v1.BatchCreateTasksResponse
	(*CreateTaskRequest)(nil),            // 7: maps.fleetengine.delivery.v1.CreateTaskRequest
	(*GetTaskRequest)(nil),               // 8: maps.fleetengine.delivery.v1.GetTaskRequest
	(*UpdateTaskRequest)(nil),            // 9: maps.fleetengine.delivery.v1.UpdateTaskRequest
	(*ListTasksRequest)(nil),             // 10: maps.fleetengine.delivery.v1.ListTasksRequest
	(*ListTasksResponse)(nil),            // 11: maps.fleetengine.delivery.v1.ListTasksResponse
	(*GetTaskTrackingInfoRequest)(nil),   // 12: maps.fleetengine.delivery.v1.GetTaskTrackingInfoRequest
	(*DeliveryRequestHeader)(nil),        // 13: maps.fleetengine.delivery.v1.DeliveryRequestHeader
	(*DeliveryVehicle)(nil),              // 14: maps.fleetengine.delivery.v1.DeliveryVehicle
	(*viewport.Viewport)(nil),            // 15: google.geo.type.Viewport
	(*fieldmaskpb.FieldMask)(nil),        // 16: google.protobuf.FieldMask
	(*Task)(nil),                         // 17: maps.fleetengine.delivery.v1.Task
	(*TaskTrackingInfo)(nil),             // 18: maps.fleetengine.delivery.v1.TaskTrackingInfo
}
var file_google_maps_fleetengine_delivery_v1_delivery_api_proto_depIdxs = []int32{
	13, // 0: maps.fleetengine.delivery.v1.CreateDeliveryVehicleRequest.header:type_name -> maps.fleetengine.delivery.v1.DeliveryRequestHeader
	14, // 1: maps.fleetengine.delivery.v1.CreateDeliveryVehicleRequest.delivery_vehicle:type_name -> maps.fleetengine.delivery.v1.DeliveryVehicle
	13, // 2: maps.fleetengine.delivery.v1.GetDeliveryVehicleRequest.header:type_name -> maps.fleetengine.delivery.v1.DeliveryRequestHeader
	13, // 3: maps.fleetengine.delivery.v1.ListDeliveryVehiclesRequest.header:type_name -> maps.fleetengine.delivery.v1.DeliveryRequestHeader
	15, // 4: maps.fleetengine.delivery.v1.ListDeliveryVehiclesRequest.viewport:type_name -> google.geo.type.Viewport
	14, // 5: maps.fleetengine.delivery.v1.ListDeliveryVehiclesResponse.delivery_vehicles:type_name -> maps.fleetengine.delivery.v1.DeliveryVehicle
	13, // 6: maps.fleetengine.delivery.v1.UpdateDeliveryVehicleRequest.header:type_name -> maps.fleetengine.delivery.v1.DeliveryRequestHeader
	14, // 7: maps.fleetengine.delivery.v1.UpdateDeliveryVehicleRequest.delivery_vehicle:type_name -> maps.fleetengine.delivery.v1.DeliveryVehicle
	16, // 8: maps.fleetengine.delivery.v1.UpdateDeliveryVehicleRequest.update_mask:type_name -> google.protobuf.FieldMask
	13, // 9: maps.fleetengine.delivery.v1.BatchCreateTasksRequest.header:type_name -> maps.fleetengine.delivery.v1.DeliveryRequestHeader
	7,  // 10: maps.fleetengine.delivery.v1.BatchCreateTasksRequest.requests:type_name -> maps.fleetengine.delivery.v1.CreateTaskRequest
	17, // 11: maps.fleetengine.delivery.v1.BatchCreateTasksResponse.tasks:type_name -> maps.fleetengine.delivery.v1.Task
	13, // 12: maps.fleetengine.delivery.v1.CreateTaskRequest.header:type_name -> maps.fleetengine.delivery.v1.DeliveryRequestHeader
	17, // 13: maps.fleetengine.delivery.v1.CreateTaskRequest.task:type_name -> maps.fleetengine.delivery.v1.Task
	13, // 14: maps.fleetengine.delivery.v1.GetTaskRequest.header:type_name -> maps.fleetengine.delivery.v1.DeliveryRequestHeader
	13, // 15: maps.fleetengine.delivery.v1.UpdateTaskRequest.header:type_name -> maps.fleetengine.delivery.v1.DeliveryRequestHeader
	17, // 16: maps.fleetengine.delivery.v1.UpdateTaskRequest.task:type_name -> maps.fleetengine.delivery.v1.Task
	16, // 17: maps.fleetengine.delivery.v1.UpdateTaskRequest.update_mask:type_name -> google.protobuf.FieldMask
	13, // 18: maps.fleetengine.delivery.v1.ListTasksRequest.header:type_name -> maps.fleetengine.delivery.v1.DeliveryRequestHeader
	17, // 19: maps.fleetengine.delivery.v1.ListTasksResponse.tasks:type_name -> maps.fleetengine.delivery.v1.Task
	13, // 20: maps.fleetengine.delivery.v1.GetTaskTrackingInfoRequest.header:type_name -> maps.fleetengine.delivery.v1.DeliveryRequestHeader
	0,  // 21: maps.fleetengine.delivery.v1.DeliveryService.CreateDeliveryVehicle:input_type -> maps.fleetengine.delivery.v1.CreateDeliveryVehicleRequest
	1,  // 22: maps.fleetengine.delivery.v1.DeliveryService.GetDeliveryVehicle:input_type -> maps.fleetengine.delivery.v1.GetDeliveryVehicleRequest
	4,  // 23: maps.fleetengine.delivery.v1.DeliveryService.UpdateDeliveryVehicle:input_type -> maps.fleetengine.delivery.v1.UpdateDeliveryVehicleRequest
	5,  // 24: maps.fleetengine.delivery.v1.DeliveryService.BatchCreateTasks:input_type -> maps.fleetengine.delivery.v1.BatchCreateTasksRequest
	7,  // 25: maps.fleetengine.delivery.v1.DeliveryService.CreateTask:input_type -> maps.fleetengine.delivery.v1.CreateTaskRequest
	8,  // 26: maps.fleetengine.delivery.v1.DeliveryService.GetTask:input_type -> maps.fleetengine.delivery.v1.GetTaskRequest
	9,  // 27: maps.fleetengine.delivery.v1.DeliveryService.UpdateTask:input_type -> maps.fleetengine.delivery.v1.UpdateTaskRequest
	10, // 28: maps.fleetengine.delivery.v1.DeliveryService.ListTasks:input_type -> maps.fleetengine.delivery.v1.ListTasksRequest
	12, // 29: maps.fleetengine.delivery.v1.DeliveryService.GetTaskTrackingInfo:input_type -> maps.fleetengine.delivery.v1.GetTaskTrackingInfoRequest
	2,  // 30: maps.fleetengine.delivery.v1.DeliveryService.ListDeliveryVehicles:input_type -> maps.fleetengine.delivery.v1.ListDeliveryVehiclesRequest
	14, // 31: maps.fleetengine.delivery.v1.DeliveryService.CreateDeliveryVehicle:output_type -> maps.fleetengine.delivery.v1.DeliveryVehicle
	14, // 32: maps.fleetengine.delivery.v1.DeliveryService.GetDeliveryVehicle:output_type -> maps.fleetengine.delivery.v1.DeliveryVehicle
	14, // 33: maps.fleetengine.delivery.v1.DeliveryService.UpdateDeliveryVehicle:output_type -> maps.fleetengine.delivery.v1.DeliveryVehicle
	6,  // 34: maps.fleetengine.delivery.v1.DeliveryService.BatchCreateTasks:output_type -> maps.fleetengine.delivery.v1.BatchCreateTasksResponse
	17, // 35: maps.fleetengine.delivery.v1.DeliveryService.CreateTask:output_type -> maps.fleetengine.delivery.v1.Task
	17, // 36: maps.fleetengine.delivery.v1.DeliveryService.GetTask:output_type -> maps.fleetengine.delivery.v1.Task
	17, // 37: maps.fleetengine.delivery.v1.DeliveryService.UpdateTask:output_type -> maps.fleetengine.delivery.v1.Task
	11, // 38: maps.fleetengine.delivery.v1.DeliveryService.ListTasks:output_type -> maps.fleetengine.delivery.v1.ListTasksResponse
	18, // 39: maps.fleetengine.delivery.v1.DeliveryService.GetTaskTrackingInfo:output_type -> maps.fleetengine.delivery.v1.TaskTrackingInfo
	3,  // 40: maps.fleetengine.delivery.v1.DeliveryService.ListDeliveryVehicles:output_type -> maps.fleetengine.delivery.v1.ListDeliveryVehiclesResponse
	31, // [31:41] is the sub-list for method output_type
	21, // [21:31] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_maps_fleetengine_delivery_v1_delivery_api_proto_init() }
func file_google_maps_fleetengine_delivery_v1_delivery_api_proto_init() {
	if File_google_maps_fleetengine_delivery_v1_delivery_api_proto != nil {
		return
	}
	file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_init()
	file_google_maps_fleetengine_delivery_v1_header_proto_init()
	file_google_maps_fleetengine_delivery_v1_task_tracking_info_proto_init()
	file_google_maps_fleetengine_delivery_v1_tasks_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*CreateDeliveryVehicleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*GetDeliveryVehicleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ListDeliveryVehiclesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ListDeliveryVehiclesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateDeliveryVehicleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*BatchCreateTasksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*BatchCreateTasksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*CreateTaskRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*GetTaskRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateTaskRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*ListTasksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*ListTasksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*GetTaskTrackingInfoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_maps_fleetengine_delivery_v1_delivery_api_proto_goTypes,
		DependencyIndexes: file_google_maps_fleetengine_delivery_v1_delivery_api_proto_depIdxs,
		MessageInfos:      file_google_maps_fleetengine_delivery_v1_delivery_api_proto_msgTypes,
	}.Build()
	File_google_maps_fleetengine_delivery_v1_delivery_api_proto = out.File
	file_google_maps_fleetengine_delivery_v1_delivery_api_proto_rawDesc = nil
	file_google_maps_fleetengine_delivery_v1_delivery_api_proto_goTypes = nil
	file_google_maps_fleetengine_delivery_v1_delivery_api_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DeliveryServiceClient is the client API for DeliveryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DeliveryServiceClient interface {
	// Creates and returns a new `DeliveryVehicle`.
	CreateDeliveryVehicle(ctx context.Context, in *CreateDeliveryVehicleRequest, opts ...grpc.CallOption) (*DeliveryVehicle, error)
	// Returns the specified `DeliveryVehicle` instance.
	GetDeliveryVehicle(ctx context.Context, in *GetDeliveryVehicleRequest, opts ...grpc.CallOption) (*DeliveryVehicle, error)
	// Writes updated `DeliveryVehicle` data to Fleet Engine, and assigns
	// `Tasks` to the `DeliveryVehicle`. You cannot update the name of the
	// `DeliveryVehicle`. You *can* update `remaining_vehicle_journey_segments`,
	// but it must contain all of the `VehicleJourneySegment`s to be persisted on
	// the `DeliveryVehicle`. The `task_id`s are retrieved from
	// `remaining_vehicle_journey_segments`, and their corresponding `Tasks` are
	// assigned to the `DeliveryVehicle` if they have not yet been assigned.
	UpdateDeliveryVehicle(ctx context.Context, in *UpdateDeliveryVehicleRequest, opts ...grpc.CallOption) (*DeliveryVehicle, error)
	// Creates and returns a batch of new `Task` objects.
	BatchCreateTasks(ctx context.Context, in *BatchCreateTasksRequest, opts ...grpc.CallOption) (*BatchCreateTasksResponse, error)
	// Creates and returns a new `Task` object.
	CreateTask(ctx context.Context, in *CreateTaskRequest, opts ...grpc.CallOption) (*Task, error)
	// Gets information about a `Task`.
	GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*Task, error)
	// Updates `Task` data.
	UpdateTask(ctx context.Context, in *UpdateTaskRequest, opts ...grpc.CallOption) (*Task, error)
	// Gets all `Task`s that meet the specified filtering criteria.
	ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error)
	// Returns the specified `TaskTrackingInfo` instance.
	GetTaskTrackingInfo(ctx context.Context, in *GetTaskTrackingInfoRequest, opts ...grpc.CallOption) (*TaskTrackingInfo, error)
	// Gets all `DeliveryVehicle`s that meet the specified filtering criteria.
	ListDeliveryVehicles(ctx context.Context, in *ListDeliveryVehiclesRequest, opts ...grpc.CallOption) (*ListDeliveryVehiclesResponse, error)
}

type deliveryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDeliveryServiceClient(cc grpc.ClientConnInterface) DeliveryServiceClient {
	return &deliveryServiceClient{cc}
}

func (c *deliveryServiceClient) CreateDeliveryVehicle(ctx context.Context, in *CreateDeliveryVehicleRequest, opts ...grpc.CallOption) (*DeliveryVehicle, error) {
	out := new(DeliveryVehicle)
	err := c.cc.Invoke(ctx, "/maps.fleetengine.delivery.v1.DeliveryService/CreateDeliveryVehicle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) GetDeliveryVehicle(ctx context.Context, in *GetDeliveryVehicleRequest, opts ...grpc.CallOption) (*DeliveryVehicle, error) {
	out := new(DeliveryVehicle)
	err := c.cc.Invoke(ctx, "/maps.fleetengine.delivery.v1.DeliveryService/GetDeliveryVehicle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) UpdateDeliveryVehicle(ctx context.Context, in *UpdateDeliveryVehicleRequest, opts ...grpc.CallOption) (*DeliveryVehicle, error) {
	out := new(DeliveryVehicle)
	err := c.cc.Invoke(ctx, "/maps.fleetengine.delivery.v1.DeliveryService/UpdateDeliveryVehicle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) BatchCreateTasks(ctx context.Context, in *BatchCreateTasksRequest, opts ...grpc.CallOption) (*BatchCreateTasksResponse, error) {
	out := new(BatchCreateTasksResponse)
	err := c.cc.Invoke(ctx, "/maps.fleetengine.delivery.v1.DeliveryService/BatchCreateTasks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) CreateTask(ctx context.Context, in *CreateTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, "/maps.fleetengine.delivery.v1.DeliveryService/CreateTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, "/maps.fleetengine.delivery.v1.DeliveryService/GetTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) UpdateTask(ctx context.Context, in *UpdateTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, "/maps.fleetengine.delivery.v1.DeliveryService/UpdateTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error) {
	out := new(ListTasksResponse)
	err := c.cc.Invoke(ctx, "/maps.fleetengine.delivery.v1.DeliveryService/ListTasks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) GetTaskTrackingInfo(ctx context.Context, in *GetTaskTrackingInfoRequest, opts ...grpc.CallOption) (*TaskTrackingInfo, error) {
	out := new(TaskTrackingInfo)
	err := c.cc.Invoke(ctx, "/maps.fleetengine.delivery.v1.DeliveryService/GetTaskTrackingInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) ListDeliveryVehicles(ctx context.Context, in *ListDeliveryVehiclesRequest, opts ...grpc.CallOption) (*ListDeliveryVehiclesResponse, error) {
	out := new(ListDeliveryVehiclesResponse)
	err := c.cc.Invoke(ctx, "/maps.fleetengine.delivery.v1.DeliveryService/ListDeliveryVehicles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DeliveryServiceServer is the server API for DeliveryService service.
type DeliveryServiceServer interface {
	// Creates and returns a new `DeliveryVehicle`.
	CreateDeliveryVehicle(context.Context, *CreateDeliveryVehicleRequest) (*DeliveryVehicle, error)
	// Returns the specified `DeliveryVehicle` instance.
	GetDeliveryVehicle(context.Context, *GetDeliveryVehicleRequest) (*DeliveryVehicle, error)
	// Writes updated `DeliveryVehicle` data to Fleet Engine, and assigns
	// `Tasks` to the `DeliveryVehicle`. You cannot update the name of the
	// `DeliveryVehicle`. You *can* update `remaining_vehicle_journey_segments`,
	// but it must contain all of the `VehicleJourneySegment`s to be persisted on
	// the `DeliveryVehicle`. The `task_id`s are retrieved from
	// `remaining_vehicle_journey_segments`, and their corresponding `Tasks` are
	// assigned to the `DeliveryVehicle` if they have not yet been assigned.
	UpdateDeliveryVehicle(context.Context, *UpdateDeliveryVehicleRequest) (*DeliveryVehicle, error)
	// Creates and returns a batch of new `Task` objects.
	BatchCreateTasks(context.Context, *BatchCreateTasksRequest) (*BatchCreateTasksResponse, error)
	// Creates and returns a new `Task` object.
	CreateTask(context.Context, *CreateTaskRequest) (*Task, error)
	// Gets information about a `Task`.
	GetTask(context.Context, *GetTaskRequest) (*Task, error)
	// Updates `Task` data.
	UpdateTask(context.Context, *UpdateTaskRequest) (*Task, error)
	// Gets all `Task`s that meet the specified filtering criteria.
	ListTasks(context.Context, *ListTasksRequest) (*ListTasksResponse, error)
	// Returns the specified `TaskTrackingInfo` instance.
	GetTaskTrackingInfo(context.Context, *GetTaskTrackingInfoRequest) (*TaskTrackingInfo, error)
	// Gets all `DeliveryVehicle`s that meet the specified filtering criteria.
	ListDeliveryVehicles(context.Context, *ListDeliveryVehiclesRequest) (*ListDeliveryVehiclesResponse, error)
}

// UnimplementedDeliveryServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDeliveryServiceServer struct {
}

func (*UnimplementedDeliveryServiceServer) CreateDeliveryVehicle(context.Context, *CreateDeliveryVehicleRequest) (*DeliveryVehicle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDeliveryVehicle not implemented")
}
func (*UnimplementedDeliveryServiceServer) GetDeliveryVehicle(context.Context, *GetDeliveryVehicleRequest) (*DeliveryVehicle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeliveryVehicle not implemented")
}
func (*UnimplementedDeliveryServiceServer) UpdateDeliveryVehicle(context.Context, *UpdateDeliveryVehicleRequest) (*DeliveryVehicle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDeliveryVehicle not implemented")
}
func (*UnimplementedDeliveryServiceServer) BatchCreateTasks(context.Context, *BatchCreateTasksRequest) (*BatchCreateTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateTasks not implemented")
}
func (*UnimplementedDeliveryServiceServer) CreateTask(context.Context, *CreateTaskRequest) (*Task, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTask not implemented")
}
func (*UnimplementedDeliveryServiceServer) GetTask(context.Context, *GetTaskRequest) (*Task, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTask not implemented")
}
func (*UnimplementedDeliveryServiceServer) UpdateTask(context.Context, *UpdateTaskRequest) (*Task, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTask not implemented")
}
func (*UnimplementedDeliveryServiceServer) ListTasks(context.Context, *ListTasksRequest) (*ListTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTasks not implemented")
}
func (*UnimplementedDeliveryServiceServer) GetTaskTrackingInfo(context.Context, *GetTaskTrackingInfoRequest) (*TaskTrackingInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTaskTrackingInfo not implemented")
}
func (*UnimplementedDeliveryServiceServer) ListDeliveryVehicles(context.Context, *ListDeliveryVehiclesRequest) (*ListDeliveryVehiclesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeliveryVehicles not implemented")
}

func RegisterDeliveryServiceServer(s *grpc.Server, srv DeliveryServiceServer) {
	s.RegisterService(&_DeliveryService_serviceDesc, srv)
}

func _DeliveryService_CreateDeliveryVehicle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeliveryVehicleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).CreateDeliveryVehicle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/maps.fleetengine.delivery.v1.DeliveryService/CreateDeliveryVehicle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).CreateDeliveryVehicle(ctx, req.(*CreateDeliveryVehicleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_GetDeliveryVehicle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeliveryVehicleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).GetDeliveryVehicle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/maps.fleetengine.delivery.v1.DeliveryService/GetDeliveryVehicle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).GetDeliveryVehicle(ctx, req.(*GetDeliveryVehicleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_UpdateDeliveryVehicle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeliveryVehicleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).UpdateDeliveryVehicle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/maps.fleetengine.delivery.v1.DeliveryService/UpdateDeliveryVehicle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).UpdateDeliveryVehicle(ctx, req.(*UpdateDeliveryVehicleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_BatchCreateTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).BatchCreateTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/maps.fleetengine.delivery.v1.DeliveryService/BatchCreateTasks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).BatchCreateTasks(ctx, req.(*BatchCreateTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_CreateTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).CreateTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/maps.fleetengine.delivery.v1.DeliveryService/CreateTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).CreateTask(ctx, req.(*CreateTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_GetTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).GetTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/maps.fleetengine.delivery.v1.DeliveryService/GetTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).GetTask(ctx, req.(*GetTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_UpdateTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).UpdateTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/maps.fleetengine.delivery.v1.DeliveryService/UpdateTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).UpdateTask(ctx, req.(*UpdateTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_ListTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).ListTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/maps.fleetengine.delivery.v1.DeliveryService/ListTasks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).ListTasks(ctx, req.(*ListTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_GetTaskTrackingInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTaskTrackingInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).GetTaskTrackingInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/maps.fleetengine.delivery.v1.DeliveryService/GetTaskTrackingInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).GetTaskTrackingInfo(ctx, req.(*GetTaskTrackingInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_ListDeliveryVehicles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeliveryVehiclesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).ListDeliveryVehicles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/maps.fleetengine.delivery.v1.DeliveryService/ListDeliveryVehicles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).ListDeliveryVehicles(ctx, req.(*ListDeliveryVehiclesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DeliveryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "maps.fleetengine.delivery.v1.DeliveryService",
	HandlerType: (*DeliveryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDeliveryVehicle",
			Handler:    _DeliveryService_CreateDeliveryVehicle_Handler,
		},
		{
			MethodName: "GetDeliveryVehicle",
			Handler:    _DeliveryService_GetDeliveryVehicle_Handler,
		},
		{
			MethodName: "UpdateDeliveryVehicle",
			Handler:    _DeliveryService_UpdateDeliveryVehicle_Handler,
		},
		{
			MethodName: "BatchCreateTasks",
			Handler:    _DeliveryService_BatchCreateTasks_Handler,
		},
		{
			MethodName: "CreateTask",
			Handler:    _DeliveryService_CreateTask_Handler,
		},
		{
			MethodName: "GetTask",
			Handler:    _DeliveryService_GetTask_Handler,
		},
		{
			MethodName: "UpdateTask",
			Handler:    _DeliveryService_UpdateTask_Handler,
		},
		{
			MethodName: "ListTasks",
			Handler:    _DeliveryService_ListTasks_Handler,
		},
		{
			MethodName: "GetTaskTrackingInfo",
			Handler:    _DeliveryService_GetTaskTrackingInfo_Handler,
		},
		{
			MethodName: "ListDeliveryVehicles",
			Handler:    _DeliveryService_ListDeliveryVehicles_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/maps/fleetengine/delivery/v1/delivery_api.proto",
}
