//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package edgeorder

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/edgeorder/mgmt/2021-12-01/edgeorder"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ActionStatusEnum = original.ActionStatusEnum

const (
	ActionStatusEnumAllowed    ActionStatusEnum = original.ActionStatusEnumAllowed
	ActionStatusEnumNotAllowed ActionStatusEnum = original.ActionStatusEnumNotAllowed
)

type ActionType = original.ActionType

const (
	ActionTypeInternal ActionType = original.ActionTypeInternal
)

type AddressType = original.AddressType

const (
	AddressTypeCommercial  AddressType = original.AddressTypeCommercial
	AddressTypeNone        AddressType = original.AddressTypeNone
	AddressTypeResidential AddressType = original.AddressTypeResidential
)

type AddressValidationStatus = original.AddressValidationStatus

const (
	AddressValidationStatusAmbiguous AddressValidationStatus = original.AddressValidationStatusAmbiguous
	AddressValidationStatusInvalid   AddressValidationStatus = original.AddressValidationStatusInvalid
	AddressValidationStatusValid     AddressValidationStatus = original.AddressValidationStatusValid
)

type AvailabilityStage = original.AvailabilityStage

const (
	AvailabilityStageAvailable   AvailabilityStage = original.AvailabilityStageAvailable
	AvailabilityStageComingSoon  AvailabilityStage = original.AvailabilityStageComingSoon
	AvailabilityStageDeprecated  AvailabilityStage = original.AvailabilityStageDeprecated
	AvailabilityStagePreview     AvailabilityStage = original.AvailabilityStagePreview
	AvailabilityStageSignup      AvailabilityStage = original.AvailabilityStageSignup
	AvailabilityStageUnavailable AvailabilityStage = original.AvailabilityStageUnavailable
)

type BillingType = original.BillingType

const (
	BillingTypeMeterDetails BillingType = original.BillingTypeMeterDetails
	BillingTypePav2         BillingType = original.BillingTypePav2
	BillingTypePurchase     BillingType = original.BillingTypePurchase
)

type ChargingType = original.ChargingType

const (
	ChargingTypePerDevice ChargingType = original.ChargingTypePerDevice
	ChargingTypePerOrder  ChargingType = original.ChargingTypePerOrder
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type DescriptionType = original.DescriptionType

const (
	DescriptionTypeBase DescriptionType = original.DescriptionTypeBase
)

type DisabledReason = original.DisabledReason

const (
	DisabledReasonCountry            DisabledReason = original.DisabledReasonCountry
	DisabledReasonFeature            DisabledReason = original.DisabledReasonFeature
	DisabledReasonNone               DisabledReason = original.DisabledReasonNone
	DisabledReasonNoSubscriptionInfo DisabledReason = original.DisabledReasonNoSubscriptionInfo
	DisabledReasonNotAvailable       DisabledReason = original.DisabledReasonNotAvailable
	DisabledReasonOfferType          DisabledReason = original.DisabledReasonOfferType
	DisabledReasonOutOfStock         DisabledReason = original.DisabledReasonOutOfStock
	DisabledReasonRegion             DisabledReason = original.DisabledReasonRegion
)

type DoubleEncryptionStatus = original.DoubleEncryptionStatus

const (
	DoubleEncryptionStatusDisabled DoubleEncryptionStatus = original.DoubleEncryptionStatusDisabled
	DoubleEncryptionStatusEnabled  DoubleEncryptionStatus = original.DoubleEncryptionStatusEnabled
)

type ImageType = original.ImageType

const (
	ImageTypeBulletImage  ImageType = original.ImageTypeBulletImage
	ImageTypeGenericImage ImageType = original.ImageTypeGenericImage
	ImageTypeMainImage    ImageType = original.ImageTypeMainImage
)

type LengthHeightUnit = original.LengthHeightUnit

const (
	LengthHeightUnitCM LengthHeightUnit = original.LengthHeightUnitCM
	LengthHeightUnitIN LengthHeightUnit = original.LengthHeightUnitIN
)

type LinkType = original.LinkType

const (
	LinkTypeDocumentation      LinkType = original.LinkTypeDocumentation
	LinkTypeGeneric            LinkType = original.LinkTypeGeneric
	LinkTypeKnowMore           LinkType = original.LinkTypeKnowMore
	LinkTypeSignUp             LinkType = original.LinkTypeSignUp
	LinkTypeSpecification      LinkType = original.LinkTypeSpecification
	LinkTypeTermsAndConditions LinkType = original.LinkTypeTermsAndConditions
)

type MeteringType = original.MeteringType

const (
	MeteringTypeAdhoc     MeteringType = original.MeteringTypeAdhoc
	MeteringTypeOneTime   MeteringType = original.MeteringTypeOneTime
	MeteringTypeRecurring MeteringType = original.MeteringTypeRecurring
)

type NotificationStageName = original.NotificationStageName

const (
	NotificationStageNameDelivered NotificationStageName = original.NotificationStageNameDelivered
	NotificationStageNameShipped   NotificationStageName = original.NotificationStageNameShipped
)

type OrderItemCancellationEnum = original.OrderItemCancellationEnum

const (
	OrderItemCancellationEnumCancellable        OrderItemCancellationEnum = original.OrderItemCancellationEnumCancellable
	OrderItemCancellationEnumCancellableWithFee OrderItemCancellationEnum = original.OrderItemCancellationEnumCancellableWithFee
	OrderItemCancellationEnumNotCancellable     OrderItemCancellationEnum = original.OrderItemCancellationEnumNotCancellable
)

type OrderItemReturnEnum = original.OrderItemReturnEnum

const (
	OrderItemReturnEnumNotReturnable     OrderItemReturnEnum = original.OrderItemReturnEnumNotReturnable
	OrderItemReturnEnumReturnable        OrderItemReturnEnum = original.OrderItemReturnEnumReturnable
	OrderItemReturnEnumReturnableWithFee OrderItemReturnEnum = original.OrderItemReturnEnumReturnableWithFee
)

type OrderItemType = original.OrderItemType

const (
	OrderItemTypePurchase OrderItemType = original.OrderItemTypePurchase
	OrderItemTypeRental   OrderItemType = original.OrderItemTypeRental
)

type Origin = original.Origin

const (
	OriginSystem     Origin = original.OriginSystem
	OriginUser       Origin = original.OriginUser
	OriginUsersystem Origin = original.OriginUsersystem
)

type StageName = original.StageName

const (
	StageNameCancelled           StageName = original.StageNameCancelled
	StageNameConfirmed           StageName = original.StageNameConfirmed
	StageNameDelivered           StageName = original.StageNameDelivered
	StageNameInReview            StageName = original.StageNameInReview
	StageNameInUse               StageName = original.StageNameInUse
	StageNamePlaced              StageName = original.StageNamePlaced
	StageNameReadyToShip         StageName = original.StageNameReadyToShip
	StageNameReturnCompleted     StageName = original.StageNameReturnCompleted
	StageNameReturnedToMicrosoft StageName = original.StageNameReturnedToMicrosoft
	StageNameReturnInitiated     StageName = original.StageNameReturnInitiated
	StageNameReturnPickedUp      StageName = original.StageNameReturnPickedUp
	StageNameShipped             StageName = original.StageNameShipped
)

type StageStatus = original.StageStatus

const (
	StageStatusCancelled  StageStatus = original.StageStatusCancelled
	StageStatusCancelling StageStatus = original.StageStatusCancelling
	StageStatusFailed     StageStatus = original.StageStatusFailed
	StageStatusInProgress StageStatus = original.StageStatusInProgress
	StageStatusNone       StageStatus = original.StageStatusNone
	StageStatusSucceeded  StageStatus = original.StageStatusSucceeded
)

type SupportedFilterTypes = original.SupportedFilterTypes

const (
	SupportedFilterTypesDoubleEncryptionStatus SupportedFilterTypes = original.SupportedFilterTypesDoubleEncryptionStatus
	SupportedFilterTypesShipToCountries        SupportedFilterTypes = original.SupportedFilterTypesShipToCountries
)

type TransportShipmentTypes = original.TransportShipmentTypes

const (
	TransportShipmentTypesCustomerManaged  TransportShipmentTypes = original.TransportShipmentTypesCustomerManaged
	TransportShipmentTypesMicrosoftManaged TransportShipmentTypes = original.TransportShipmentTypesMicrosoftManaged
)

type WeightMeasurementUnit = original.WeightMeasurementUnit

const (
	WeightMeasurementUnitKGS WeightMeasurementUnit = original.WeightMeasurementUnitKGS
	WeightMeasurementUnitLBS WeightMeasurementUnit = original.WeightMeasurementUnitLBS
)

type AddressDetails = original.AddressDetails
type AddressProperties = original.AddressProperties
type AddressResource = original.AddressResource
type AddressResourceList = original.AddressResourceList
type AddressResourceListIterator = original.AddressResourceListIterator
type AddressResourceListPage = original.AddressResourceListPage
type AddressUpdateParameter = original.AddressUpdateParameter
type AddressUpdateProperties = original.AddressUpdateProperties
type AvailabilityInformation = original.AvailabilityInformation
type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type BasicInformation = original.BasicInformation
type BasicMeterDetails = original.BasicMeterDetails
type BillingMeterDetails = original.BillingMeterDetails
type CancellationReason = original.CancellationReason
type CommonProperties = original.CommonProperties
type Configuration = original.Configuration
type ConfigurationFilters = original.ConfigurationFilters
type ConfigurationProperties = original.ConfigurationProperties
type Configurations = original.Configurations
type ConfigurationsIterator = original.ConfigurationsIterator
type ConfigurationsPage = original.ConfigurationsPage
type ConfigurationsRequest = original.ConfigurationsRequest
type ContactDetails = original.ContactDetails
type CostInformation = original.CostInformation
type CreateAddressFuture = original.CreateAddressFuture
type CreateOrderItemFuture = original.CreateOrderItemFuture
type CustomerSubscriptionDetails = original.CustomerSubscriptionDetails
type CustomerSubscriptionRegisteredFeatures = original.CustomerSubscriptionRegisteredFeatures
type DeleteAddressByNameFuture = original.DeleteAddressByNameFuture
type DeleteOrderItemByNameFuture = original.DeleteOrderItemByNameFuture
type Description = original.Description
type DeviceDetails = original.DeviceDetails
type Dimensions = original.Dimensions
type DisplayInfo = original.DisplayInfo
type EncryptionPreferences = original.EncryptionPreferences
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorDetail = original.ErrorDetail
type ErrorResponse = original.ErrorResponse
type FilterableProperty = original.FilterableProperty
type ForwardShippingDetails = original.ForwardShippingDetails
type HierarchyInformation = original.HierarchyInformation
type ImageInformation = original.ImageInformation
type Link = original.Link
type ManagementResourcePreferences = original.ManagementResourcePreferences
type MeterDetails = original.MeterDetails
type NotificationPreference = original.NotificationPreference
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OrderItemDetails = original.OrderItemDetails
type OrderItemProperties = original.OrderItemProperties
type OrderItemResource = original.OrderItemResource
type OrderItemResourceList = original.OrderItemResourceList
type OrderItemResourceListIterator = original.OrderItemResourceListIterator
type OrderItemResourceListPage = original.OrderItemResourceListPage
type OrderItemUpdateParameter = original.OrderItemUpdateParameter
type OrderItemUpdateProperties = original.OrderItemUpdateProperties
type OrderProperties = original.OrderProperties
type OrderResource = original.OrderResource
type OrderResourceList = original.OrderResourceList
type OrderResourceListIterator = original.OrderResourceListIterator
type OrderResourceListPage = original.OrderResourceListPage
type Pav2MeterDetails = original.Pav2MeterDetails
type Preferences = original.Preferences
type Product = original.Product
type ProductDetails = original.ProductDetails
type ProductFamilies = original.ProductFamilies
type ProductFamiliesIterator = original.ProductFamiliesIterator
type ProductFamiliesMetadata = original.ProductFamiliesMetadata
type ProductFamiliesMetadataDetails = original.ProductFamiliesMetadataDetails
type ProductFamiliesMetadataIterator = original.ProductFamiliesMetadataIterator
type ProductFamiliesMetadataPage = original.ProductFamiliesMetadataPage
type ProductFamiliesPage = original.ProductFamiliesPage
type ProductFamiliesRequest = original.ProductFamiliesRequest
type ProductFamily = original.ProductFamily
type ProductFamilyProperties = original.ProductFamilyProperties
type ProductLine = original.ProductLine
type ProductLineProperties = original.ProductLineProperties
type ProductProperties = original.ProductProperties
type ProxyResource = original.ProxyResource
type PurchaseMeterDetails = original.PurchaseMeterDetails
type Resource = original.Resource
type ResourceIdentity = original.ResourceIdentity
type ResourceProviderDetails = original.ResourceProviderDetails
type ReturnOrderItemDetails = original.ReturnOrderItemDetails
type ReturnOrderItemFuture = original.ReturnOrderItemFuture
type ReverseShippingDetails = original.ReverseShippingDetails
type ShippingAddress = original.ShippingAddress
type ShippingDetails = original.ShippingDetails
type Specification = original.Specification
type StageDetails = original.StageDetails
type SystemData = original.SystemData
type TrackedResource = original.TrackedResource
type TransportPreferences = original.TransportPreferences
type UpdateAddressFuture = original.UpdateAddressFuture
type UpdateOrderItemFuture = original.UpdateOrderItemFuture

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAddressResourceListIterator(page AddressResourceListPage) AddressResourceListIterator {
	return original.NewAddressResourceListIterator(page)
}
func NewAddressResourceListPage(cur AddressResourceList, getNextPage func(context.Context, AddressResourceList) (AddressResourceList, error)) AddressResourceListPage {
	return original.NewAddressResourceListPage(cur, getNextPage)
}
func NewConfigurationsIterator(page ConfigurationsPage) ConfigurationsIterator {
	return original.NewConfigurationsIterator(page)
}
func NewConfigurationsPage(cur Configurations, getNextPage func(context.Context, Configurations) (Configurations, error)) ConfigurationsPage {
	return original.NewConfigurationsPage(cur, getNextPage)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(cur, getNextPage)
}
func NewOrderItemResourceListIterator(page OrderItemResourceListPage) OrderItemResourceListIterator {
	return original.NewOrderItemResourceListIterator(page)
}
func NewOrderItemResourceListPage(cur OrderItemResourceList, getNextPage func(context.Context, OrderItemResourceList) (OrderItemResourceList, error)) OrderItemResourceListPage {
	return original.NewOrderItemResourceListPage(cur, getNextPage)
}
func NewOrderResourceListIterator(page OrderResourceListPage) OrderResourceListIterator {
	return original.NewOrderResourceListIterator(page)
}
func NewOrderResourceListPage(cur OrderResourceList, getNextPage func(context.Context, OrderResourceList) (OrderResourceList, error)) OrderResourceListPage {
	return original.NewOrderResourceListPage(cur, getNextPage)
}
func NewProductFamiliesIterator(page ProductFamiliesPage) ProductFamiliesIterator {
	return original.NewProductFamiliesIterator(page)
}
func NewProductFamiliesMetadataIterator(page ProductFamiliesMetadataPage) ProductFamiliesMetadataIterator {
	return original.NewProductFamiliesMetadataIterator(page)
}
func NewProductFamiliesMetadataPage(cur ProductFamiliesMetadata, getNextPage func(context.Context, ProductFamiliesMetadata) (ProductFamiliesMetadata, error)) ProductFamiliesMetadataPage {
	return original.NewProductFamiliesMetadataPage(cur, getNextPage)
}
func NewProductFamiliesPage(cur ProductFamilies, getNextPage func(context.Context, ProductFamilies) (ProductFamilies, error)) ProductFamiliesPage {
	return original.NewProductFamiliesPage(cur, getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleActionStatusEnumValues() []ActionStatusEnum {
	return original.PossibleActionStatusEnumValues()
}
func PossibleActionTypeValues() []ActionType {
	return original.PossibleActionTypeValues()
}
func PossibleAddressTypeValues() []AddressType {
	return original.PossibleAddressTypeValues()
}
func PossibleAddressValidationStatusValues() []AddressValidationStatus {
	return original.PossibleAddressValidationStatusValues()
}
func PossibleAvailabilityStageValues() []AvailabilityStage {
	return original.PossibleAvailabilityStageValues()
}
func PossibleBillingTypeValues() []BillingType {
	return original.PossibleBillingTypeValues()
}
func PossibleChargingTypeValues() []ChargingType {
	return original.PossibleChargingTypeValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleDescriptionTypeValues() []DescriptionType {
	return original.PossibleDescriptionTypeValues()
}
func PossibleDisabledReasonValues() []DisabledReason {
	return original.PossibleDisabledReasonValues()
}
func PossibleDoubleEncryptionStatusValues() []DoubleEncryptionStatus {
	return original.PossibleDoubleEncryptionStatusValues()
}
func PossibleImageTypeValues() []ImageType {
	return original.PossibleImageTypeValues()
}
func PossibleLengthHeightUnitValues() []LengthHeightUnit {
	return original.PossibleLengthHeightUnitValues()
}
func PossibleLinkTypeValues() []LinkType {
	return original.PossibleLinkTypeValues()
}
func PossibleMeteringTypeValues() []MeteringType {
	return original.PossibleMeteringTypeValues()
}
func PossibleNotificationStageNameValues() []NotificationStageName {
	return original.PossibleNotificationStageNameValues()
}
func PossibleOrderItemCancellationEnumValues() []OrderItemCancellationEnum {
	return original.PossibleOrderItemCancellationEnumValues()
}
func PossibleOrderItemReturnEnumValues() []OrderItemReturnEnum {
	return original.PossibleOrderItemReturnEnumValues()
}
func PossibleOrderItemTypeValues() []OrderItemType {
	return original.PossibleOrderItemTypeValues()
}
func PossibleOriginValues() []Origin {
	return original.PossibleOriginValues()
}
func PossibleStageNameValues() []StageName {
	return original.PossibleStageNameValues()
}
func PossibleStageStatusValues() []StageStatus {
	return original.PossibleStageStatusValues()
}
func PossibleSupportedFilterTypesValues() []SupportedFilterTypes {
	return original.PossibleSupportedFilterTypesValues()
}
func PossibleTransportShipmentTypesValues() []TransportShipmentTypes {
	return original.PossibleTransportShipmentTypesValues()
}
func PossibleWeightMeasurementUnitValues() []WeightMeasurementUnit {
	return original.PossibleWeightMeasurementUnitValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
