package activitylogs

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/monitor/mgmt/2020-10-01/activitylogs"

// ActionGroup a pointer to an Azure Action Group.
type ActionGroup struct {
	// ActionGroupID - The resource ID of the Action Group. This cannot be null or empty.
	ActionGroupID *string `json:"actionGroupId,omitempty"`
	// WebhookProperties - the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
	WebhookProperties map[string]*string `json:"webhookProperties"`
}

// MarshalJSON is the custom marshaler for ActionGroup.
func (ag ActionGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ag.ActionGroupID != nil {
		objectMap["actionGroupId"] = ag.ActionGroupID
	}
	if ag.WebhookProperties != nil {
		objectMap["webhookProperties"] = ag.WebhookProperties
	}
	return json.Marshal(objectMap)
}

// ActionList a list of Activity Log Alert rule actions.
type ActionList struct {
	// ActionGroups - The list of the Action Groups.
	ActionGroups *[]ActionGroup `json:"actionGroups,omitempty"`
}

// AlertResource an Activity Log Alert rule resource.
type AlertResource struct {
	autorest.Response `json:"-"`
	// AlertRuleProperties - The Activity Log Alert rule properties of the resource.
	*AlertRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. Since Azure Activity Log Alerts is a global service, the location of the rules should always be 'global'.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AlertResource.
func (ar AlertResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.AlertRuleProperties != nil {
		objectMap["properties"] = ar.AlertRuleProperties
	}
	if ar.Location != nil {
		objectMap["location"] = ar.Location
	}
	if ar.Tags != nil {
		objectMap["tags"] = ar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertResource struct.
func (ar *AlertResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertRuleProperties AlertRuleProperties
				err = json.Unmarshal(*v, &alertRuleProperties)
				if err != nil {
					return err
				}
				ar.AlertRuleProperties = &alertRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ar.Tags = tags
			}
		}
	}

	return nil
}

// AlertRuleAllOfCondition an Activity Log Alert rule condition that is met when all its member conditions
// are met.
type AlertRuleAllOfCondition struct {
	// AllOf - The list of Activity Log Alert rule conditions.
	AllOf *[]AlertRuleAnyOfOrLeafCondition `json:"allOf,omitempty"`
}

// AlertRuleAnyOfOrLeafCondition an Activity Log Alert rule condition that is met when all its member
// conditions are met.
// Each condition can be of one of the following types:
// __Important__: Each type has its unique subset of properties. Properties from different types CANNOT
// exist in one condition.
// * __Leaf Condition -__ must contain 'field' and either 'equals' or 'containsAny'.
// _Please note, 'anyOf' should __not__ be set in a Leaf Condition._
// * __AnyOf Condition -__ must contain __only__ 'anyOf' (which is an array of Leaf Conditions).
// _Please note, 'field', 'equals' and 'containsAny' should __not__ be set in an AnyOf Condition._
type AlertRuleAnyOfOrLeafCondition struct {
	// AnyOf - An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
	AnyOf *[]AlertRuleLeafCondition `json:"anyOf,omitempty"`
	// Field - The name of the Activity Log event's field that this condition will examine.
	// The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
	Field *string `json:"field,omitempty"`
	// Equals - The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
	Equals *string `json:"equals,omitempty"`
	// ContainsAny - The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
	ContainsAny *[]string `json:"containsAny,omitempty"`
}

// AlertRuleLeafCondition an Activity Log Alert rule condition that is met by comparing the field and value
// of an Activity Log event.
// This condition must contain 'field' and either 'equals' or 'containsAny'.
type AlertRuleLeafCondition struct {
	// Field - The name of the Activity Log event's field that this condition will examine.
	// The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
	Field *string `json:"field,omitempty"`
	// Equals - The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
	Equals *string `json:"equals,omitempty"`
	// ContainsAny - The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
	ContainsAny *[]string `json:"containsAny,omitempty"`
}

// AlertRuleList a list of Activity Log Alert rules.
type AlertRuleList struct {
	autorest.Response `json:"-"`
	// Value - The list of Activity Log Alert rules.
	Value *[]AlertResource `json:"value,omitempty"`
	// NextLink - Provides the link to retrieve the next set of elements.
	NextLink *string `json:"nextLink,omitempty"`
}

// AlertRuleListIterator provides access to a complete listing of AlertResource values.
type AlertRuleListIterator struct {
	i    int
	page AlertRuleListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertRuleListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRuleListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertRuleListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertRuleListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertRuleListIterator) Response() AlertRuleList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertRuleListIterator) Value() AlertResource {
	if !iter.page.NotDone() {
		return AlertResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertRuleListIterator type.
func NewAlertRuleListIterator(page AlertRuleListPage) AlertRuleListIterator {
	return AlertRuleListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arl AlertRuleList) IsEmpty() bool {
	return arl.Value == nil || len(*arl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (arl AlertRuleList) hasNextLink() bool {
	return arl.NextLink != nil && len(*arl.NextLink) != 0
}

// alertRuleListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arl AlertRuleList) alertRuleListPreparer(ctx context.Context) (*http.Request, error) {
	if !arl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arl.NextLink)))
}

// AlertRuleListPage contains a page of AlertResource values.
type AlertRuleListPage struct {
	fn  func(context.Context, AlertRuleList) (AlertRuleList, error)
	arl AlertRuleList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertRuleListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRuleListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.arl)
		if err != nil {
			return err
		}
		page.arl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertRuleListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertRuleListPage) NotDone() bool {
	return !page.arl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertRuleListPage) Response() AlertRuleList {
	return page.arl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertRuleListPage) Values() []AlertResource {
	if page.arl.IsEmpty() {
		return nil
	}
	return *page.arl.Value
}

// Creates a new instance of the AlertRuleListPage type.
func NewAlertRuleListPage(cur AlertRuleList, getNextPage func(context.Context, AlertRuleList) (AlertRuleList, error)) AlertRuleListPage {
	return AlertRuleListPage{
		fn:  getNextPage,
		arl: cur,
	}
}

// AlertRulePatchObject an Activity Log Alert rule object for the body of patch operations.
type AlertRulePatchObject struct {
	// Tags - The resource tags
	Tags map[string]*string `json:"tags"`
	// AlertRulePatchProperties - The activity log alert settings for an update operation.
	*AlertRulePatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertRulePatchObject.
func (arpo AlertRulePatchObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arpo.Tags != nil {
		objectMap["tags"] = arpo.Tags
	}
	if arpo.AlertRulePatchProperties != nil {
		objectMap["properties"] = arpo.AlertRulePatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertRulePatchObject struct.
func (arpo *AlertRulePatchObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				arpo.Tags = tags
			}
		case "properties":
			if v != nil {
				var alertRulePatchProperties AlertRulePatchProperties
				err = json.Unmarshal(*v, &alertRulePatchProperties)
				if err != nil {
					return err
				}
				arpo.AlertRulePatchProperties = &alertRulePatchProperties
			}
		}
	}

	return nil
}

// AlertRulePatchProperties an Activity Log Alert rule properties for patch operations.
type AlertRulePatchProperties struct {
	// Enabled - Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert rule is not enabled, then none of its actions will be activated.
	Enabled *bool `json:"enabled,omitempty"`
}

// AlertRuleProperties an Azure Activity Log Alert rule.
type AlertRuleProperties struct {
	// Scopes - A list of resource IDs that will be used as prefixes. The alert will only apply to Activity Log events with resource IDs that fall under one of these prefixes. This list must include at least one item.
	Scopes *[]string `json:"scopes,omitempty"`
	// Condition - The condition that will cause this alert to activate.
	Condition *AlertRuleAllOfCondition `json:"condition,omitempty"`
	// Actions - The actions that will activate when the condition is met.
	Actions *ActionList `json:"actions,omitempty"`
	// Enabled - Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert rule is not enabled, then none of its actions will be activated.
	Enabled *bool `json:"enabled,omitempty"`
	// Description - A description of this Activity Log Alert rule.
	Description *string `json:"description,omitempty"`
}

// AzureResource an Azure resource object.
type AzureResource struct {
	// ID - READ-ONLY; The resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. Since Azure Activity Log Alerts is a global service, the location of the rules should always be 'global'.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AzureResource.
func (ar AzureResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.Location != nil {
		objectMap["location"] = ar.Location
	}
	if ar.Tags != nil {
		objectMap["tags"] = ar.Tags
	}
	return json.Marshal(objectMap)
}

// ErrorResponse describes the format of Error response.
type ErrorResponse struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// EventData the Azure event log entries are of type EventData
type EventData struct {
	// Authorization - READ-ONLY; The sender authorization information.
	Authorization *SenderAuthorization `json:"authorization,omitempty"`
	// Claims - READ-ONLY; key value pairs to identify ARM permissions.
	Claims map[string]*string `json:"claims"`
	// Caller - READ-ONLY; the email address of the user who has performed the operation, the UPN claim or SPN claim based on availability.
	Caller *string `json:"caller,omitempty"`
	// Description - READ-ONLY; the description of the event.
	Description *string `json:"description,omitempty"`
	// ID - READ-ONLY; the Id of this event as required by ARM for RBAC. It contains the EventDataID and a timestamp information.
	ID *string `json:"id,omitempty"`
	// EventDataID - READ-ONLY; the event data Id. This is a unique identifier for an event.
	EventDataID *string `json:"eventDataId,omitempty"`
	// CorrelationID - READ-ONLY; the correlation Id, usually a GUID in the string format. The correlation Id is shared among the events that belong to the same uber operation.
	CorrelationID *string `json:"correlationId,omitempty"`
	// EventName - READ-ONLY; the event name. This value should not be confused with OperationName. For practical purposes, OperationName might be more appealing to end users.
	EventName *LocalizableString `json:"eventName,omitempty"`
	// Category - READ-ONLY; the event category.
	Category *LocalizableString `json:"category,omitempty"`
	// HTTPRequest - READ-ONLY; the HTTP request info. Usually includes the 'clientRequestId', 'clientIpAddress' (IP address of the user who initiated the event) and 'method' (HTTP method e.g. PUT).
	HTTPRequest *HTTPRequestInfo `json:"httpRequest,omitempty"`
	// Level - READ-ONLY; the event level. Possible values include: 'EventLevelCritical', 'EventLevelError', 'EventLevelWarning', 'EventLevelInformational', 'EventLevelVerbose'
	Level EventLevel `json:"level,omitempty"`
	// ResourceGroupName - READ-ONLY; the resource group name of the impacted resource.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// ResourceProviderName - READ-ONLY; the resource provider name of the impacted resource.
	ResourceProviderName *LocalizableString `json:"resourceProviderName,omitempty"`
	// ResourceID - READ-ONLY; the resource uri that uniquely identifies the resource that caused this event.
	ResourceID *string `json:"resourceId,omitempty"`
	// ResourceType - READ-ONLY; the resource type
	ResourceType *LocalizableString `json:"resourceType,omitempty"`
	// OperationID - READ-ONLY; It is usually a GUID shared among the events corresponding to single operation. This value should not be confused with EventName.
	OperationID *string `json:"operationId,omitempty"`
	// OperationName - READ-ONLY; the operation name.
	OperationName *LocalizableString `json:"operationName,omitempty"`
	// Properties - READ-ONLY; the set of <Key, Value> pairs (usually a Dictionary<String, String>) that includes details about the event.
	Properties map[string]*string `json:"properties"`
	// Status - READ-ONLY; a string describing the status of the operation. Some typical values are: Started, In progress, Succeeded, Failed, Resolved.
	Status *LocalizableString `json:"status,omitempty"`
	// SubStatus - READ-ONLY; the event sub status. Most of the time, when included, this captures the HTTP status code of the REST call. Common values are: OK (HTTP Status Code: 200), Created (HTTP Status Code: 201), Accepted (HTTP Status Code: 202), No Content (HTTP Status Code: 204), Bad Request(HTTP Status Code: 400), Not Found (HTTP Status Code: 404), Conflict (HTTP Status Code: 409), Internal Server Error (HTTP Status Code: 500), Service Unavailable (HTTP Status Code:503), Gateway Timeout (HTTP Status Code: 504)
	SubStatus *LocalizableString `json:"subStatus,omitempty"`
	// EventTimestamp - READ-ONLY; the timestamp of when the event was generated by the Azure service processing the request corresponding the event. It in ISO 8601 format.
	EventTimestamp *date.Time `json:"eventTimestamp,omitempty"`
	// SubmissionTimestamp - READ-ONLY; the timestamp of when the event became available for querying via this API. It is in ISO 8601 format. This value should not be confused eventTimestamp. As there might be a delay between the occurrence time of the event, and the time that the event is submitted to the Azure logging infrastructure.
	SubmissionTimestamp *date.Time `json:"submissionTimestamp,omitempty"`
	// SubscriptionID - READ-ONLY; the Azure subscription Id usually a GUID.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// TenantID - READ-ONLY; the Azure tenant Id
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for EventData.
func (ed EventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EventDataCollection represents collection of events.
type EventDataCollection struct {
	autorest.Response `json:"-"`
	// Value - this list that includes the Azure audit logs.
	Value *[]EventData `json:"value,omitempty"`
	// NextLink - Provides the link to retrieve the next set of events.
	NextLink *string `json:"nextLink,omitempty"`
}

// EventDataCollectionIterator provides access to a complete listing of EventData values.
type EventDataCollectionIterator struct {
	i    int
	page EventDataCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EventDataCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventDataCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EventDataCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EventDataCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EventDataCollectionIterator) Response() EventDataCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EventDataCollectionIterator) Value() EventData {
	if !iter.page.NotDone() {
		return EventData{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EventDataCollectionIterator type.
func NewEventDataCollectionIterator(page EventDataCollectionPage) EventDataCollectionIterator {
	return EventDataCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (edc EventDataCollection) IsEmpty() bool {
	return edc.Value == nil || len(*edc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (edc EventDataCollection) hasNextLink() bool {
	return edc.NextLink != nil && len(*edc.NextLink) != 0
}

// eventDataCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (edc EventDataCollection) eventDataCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !edc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(edc.NextLink)))
}

// EventDataCollectionPage contains a page of EventData values.
type EventDataCollectionPage struct {
	fn  func(context.Context, EventDataCollection) (EventDataCollection, error)
	edc EventDataCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EventDataCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventDataCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.edc)
		if err != nil {
			return err
		}
		page.edc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EventDataCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EventDataCollectionPage) NotDone() bool {
	return !page.edc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EventDataCollectionPage) Response() EventDataCollection {
	return page.edc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EventDataCollectionPage) Values() []EventData {
	if page.edc.IsEmpty() {
		return nil
	}
	return *page.edc.Value
}

// Creates a new instance of the EventDataCollectionPage type.
func NewEventDataCollectionPage(cur EventDataCollection, getNextPage func(context.Context, EventDataCollection) (EventDataCollection, error)) EventDataCollectionPage {
	return EventDataCollectionPage{
		fn:  getNextPage,
		edc: cur,
	}
}

// HTTPRequestInfo the Http request info.
type HTTPRequestInfo struct {
	// ClientRequestID - the client request id.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// ClientIPAddress - the client Ip Address
	ClientIPAddress *string `json:"clientIpAddress,omitempty"`
	// Method - the Http request method.
	Method *string `json:"method,omitempty"`
	// URI - the Uri.
	URI *string `json:"uri,omitempty"`
}

// LocalizableString the localizable string class.
type LocalizableString struct {
	// Value - the invariant value.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - the locale specific value.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// SenderAuthorization the authorization used by the user who has performed the operation that led to this
// event. This captures the RBAC properties of the event. These usually include the 'action', 'role' and
// the 'scope'
type SenderAuthorization struct {
	// Action - the permissible actions. For instance: microsoft.support/supporttickets/write
	Action *string `json:"action,omitempty"`
	// Role - the role of the user. For instance: Subscription Admin
	Role *string `json:"role,omitempty"`
	// Scope - the scope.
	Scope *string `json:"scope,omitempty"`
}
