package cassandra

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterStatus invokes the cassandra.DescribeClusterStatus API synchronously
func (client *Client) DescribeClusterStatus(request *DescribeClusterStatusRequest) (response *DescribeClusterStatusResponse, err error) {
	response = CreateDescribeClusterStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterStatusWithChan invokes the cassandra.DescribeClusterStatus API asynchronously
func (client *Client) DescribeClusterStatusWithChan(request *DescribeClusterStatusRequest) (<-chan *DescribeClusterStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterStatusWithCallback invokes the cassandra.DescribeClusterStatus API asynchronously
func (client *Client) DescribeClusterStatusWithCallback(request *DescribeClusterStatusRequest, callback func(response *DescribeClusterStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterStatusRequest is the request struct for api DescribeClusterStatus
type DescribeClusterStatusRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// DescribeClusterStatusResponse is the response struct for api DescribeClusterStatus
type DescribeClusterStatusResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Status      string `json:"Status" xml:"Status"`
	CreatedTime string `json:"CreatedTime" xml:"CreatedTime"`
}

// CreateDescribeClusterStatusRequest creates a request to invoke DescribeClusterStatus API
func CreateDescribeClusterStatusRequest() (request *DescribeClusterStatusRequest) {
	request = &DescribeClusterStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cassandra", "2019-01-01", "DescribeClusterStatus", "Cassandra", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeClusterStatusResponse creates a response to parse from DescribeClusterStatus response
func CreateDescribeClusterStatusResponse() (response *DescribeClusterStatusResponse) {
	response = &DescribeClusterStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
