package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNewbieTaskStatus invokes the cloudcallcenter.GetNewbieTaskStatus API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getnewbietaskstatus.html
func (client *Client) GetNewbieTaskStatus(request *GetNewbieTaskStatusRequest) (response *GetNewbieTaskStatusResponse, err error) {
	response = CreateGetNewbieTaskStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetNewbieTaskStatusWithChan invokes the cloudcallcenter.GetNewbieTaskStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getnewbietaskstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetNewbieTaskStatusWithChan(request *GetNewbieTaskStatusRequest) (<-chan *GetNewbieTaskStatusResponse, <-chan error) {
	responseChan := make(chan *GetNewbieTaskStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNewbieTaskStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNewbieTaskStatusWithCallback invokes the cloudcallcenter.GetNewbieTaskStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getnewbietaskstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetNewbieTaskStatusWithCallback(request *GetNewbieTaskStatusRequest, callback func(response *GetNewbieTaskStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNewbieTaskStatusResponse
		var err error
		defer close(result)
		response, err = client.GetNewbieTaskStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNewbieTaskStatusRequest is the request struct for api GetNewbieTaskStatus
type GetNewbieTaskStatusRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetNewbieTaskStatusResponse is the response struct for api GetNewbieTaskStatus
type GetNewbieTaskStatusResponse struct {
	*responses.BaseResponse
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	Success        bool       `json:"Success" xml:"Success"`
	Code           string     `json:"Code" xml:"Code"`
	Message        string     `json:"Message" xml:"Message"`
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	TaskStatus     TaskStatus `json:"TaskStatus" xml:"TaskStatus"`
}

// CreateGetNewbieTaskStatusRequest creates a request to invoke GetNewbieTaskStatus API
func CreateGetNewbieTaskStatusRequest() (request *GetNewbieTaskStatusRequest) {
	request = &GetNewbieTaskStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetNewbieTaskStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateGetNewbieTaskStatusResponse creates a response to parse from GetNewbieTaskStatus response
func CreateGetNewbieTaskStatusResponse() (response *GetNewbieTaskStatusResponse) {
	response = &GetNewbieTaskStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
