package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ProfileHistory invokes the cloudwf.ProfileHistory API synchronously
// api document: https://help.aliyun.com/api/cloudwf/profilehistory.html
func (client *Client) ProfileHistory(request *ProfileHistoryRequest) (response *ProfileHistoryResponse, err error) {
	response = CreateProfileHistoryResponse()
	err = client.DoAction(request, response)
	return
}

// ProfileHistoryWithChan invokes the cloudwf.ProfileHistory API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/profilehistory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ProfileHistoryWithChan(request *ProfileHistoryRequest) (<-chan *ProfileHistoryResponse, <-chan error) {
	responseChan := make(chan *ProfileHistoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ProfileHistory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ProfileHistoryWithCallback invokes the cloudwf.ProfileHistory API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/profilehistory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ProfileHistoryWithCallback(request *ProfileHistoryRequest, callback func(response *ProfileHistoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ProfileHistoryResponse
		var err error
		defer close(result)
		response, err = client.ProfileHistory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ProfileHistoryRequest is the request struct for api ProfileHistory
type ProfileHistoryRequest struct {
	*requests.RpcRequest
	Idtype     requests.Integer `position:"Query" name:"Idtype"`
	EndMonth   string           `position:"Query" name:"EndMonth"`
	BeginMonth string           `position:"Query" name:"BeginMonth"`
	Agsid      requests.Integer `position:"Query" name:"Agsid"`
}

// ProfileHistoryResponse is the response struct for api ProfileHistory
type ProfileHistoryResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateProfileHistoryRequest creates a request to invoke ProfileHistory API
func CreateProfileHistoryRequest() (request *ProfileHistoryRequest) {
	request = &ProfileHistoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ProfileHistory", "cloudwf", "openAPI")
	return
}

// CreateProfileHistoryResponse creates a response to parse from ProfileHistory response
func CreateProfileHistoryResponse() (response *ProfileHistoryResponse) {
	response = &ProfileHistoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
