package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetBranchInfo invokes the codeup.GetBranchInfo API synchronously
func (client *Client) GetBranchInfo(request *GetBranchInfoRequest) (response *GetBranchInfoResponse, err error) {
	response = CreateGetBranchInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetBranchInfoWithChan invokes the codeup.GetBranchInfo API asynchronously
func (client *Client) GetBranchInfoWithChan(request *GetBranchInfoRequest) (<-chan *GetBranchInfoResponse, <-chan error) {
	responseChan := make(chan *GetBranchInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetBranchInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetBranchInfoWithCallback invokes the codeup.GetBranchInfo API asynchronously
func (client *Client) GetBranchInfoWithCallback(request *GetBranchInfoRequest, callback func(response *GetBranchInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetBranchInfoResponse
		var err error
		defer close(result)
		response, err = client.GetBranchInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetBranchInfoRequest is the request struct for api GetBranchInfo
type GetBranchInfoRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	SubUserId      string           `position:"Query" name:"SubUserId"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
	BranchName     string           `position:"Query" name:"BranchName"`
}

// GetBranchInfoResponse is the response struct for api GetBranchInfo
type GetBranchInfoResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateGetBranchInfoRequest creates a request to invoke GetBranchInfo API
func CreateGetBranchInfoRequest() (request *GetBranchInfoRequest) {
	request = &GetBranchInfoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "GetBranchInfo", "/api/v3/projects/[ProjectId]/repository/branches/detail", "", "")
	request.Method = requests.GET
	return
}

// CreateGetBranchInfoResponse creates a response to parse from GetBranchInfo response
func CreateGetBranchInfoResponse() (response *GetBranchInfoResponse) {
	response = &GetBranchInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
