package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApprovePermissionApplyOrder invokes the dataworks_public.ApprovePermissionApplyOrder API synchronously
func (client *Client) ApprovePermissionApplyOrder(request *ApprovePermissionApplyOrderRequest) (response *ApprovePermissionApplyOrderResponse, err error) {
	response = CreateApprovePermissionApplyOrderResponse()
	err = client.DoAction(request, response)
	return
}

// ApprovePermissionApplyOrderWithChan invokes the dataworks_public.ApprovePermissionApplyOrder API asynchronously
func (client *Client) ApprovePermissionApplyOrderWithChan(request *ApprovePermissionApplyOrderRequest) (<-chan *ApprovePermissionApplyOrderResponse, <-chan error) {
	responseChan := make(chan *ApprovePermissionApplyOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApprovePermissionApplyOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApprovePermissionApplyOrderWithCallback invokes the dataworks_public.ApprovePermissionApplyOrder API asynchronously
func (client *Client) ApprovePermissionApplyOrderWithCallback(request *ApprovePermissionApplyOrderRequest, callback func(response *ApprovePermissionApplyOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApprovePermissionApplyOrderResponse
		var err error
		defer close(result)
		response, err = client.ApprovePermissionApplyOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApprovePermissionApplyOrderRequest is the request struct for api ApprovePermissionApplyOrder
type ApprovePermissionApplyOrderRequest struct {
	*requests.RpcRequest
	FlowId         string           `position:"Query" name:"FlowId"`
	ApproveComment string           `position:"Query" name:"ApproveComment"`
	ApproveAction  requests.Integer `position:"Query" name:"ApproveAction"`
}

// ApprovePermissionApplyOrderResponse is the response struct for api ApprovePermissionApplyOrder
type ApprovePermissionApplyOrderResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ApproveSuccess bool   `json:"ApproveSuccess" xml:"ApproveSuccess"`
}

// CreateApprovePermissionApplyOrderRequest creates a request to invoke ApprovePermissionApplyOrder API
func CreateApprovePermissionApplyOrderRequest() (request *ApprovePermissionApplyOrderRequest) {
	request = &ApprovePermissionApplyOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ApprovePermissionApplyOrder", "", "")
	request.Method = requests.POST
	return
}

// CreateApprovePermissionApplyOrderResponse creates a response to parse from ApprovePermissionApplyOrder response
func CreateApprovePermissionApplyOrderResponse() (response *ApprovePermissionApplyOrderResponse) {
	response = &ApprovePermissionApplyOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
