package domain_intl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveSingleTaskForCreatingOrderRenew invokes the domain_intl.SaveSingleTaskForCreatingOrderRenew API synchronously
// api document: https://help.aliyun.com/api/domain-intl/savesingletaskforcreatingorderrenew.html
func (client *Client) SaveSingleTaskForCreatingOrderRenew(request *SaveSingleTaskForCreatingOrderRenewRequest) (response *SaveSingleTaskForCreatingOrderRenewResponse, err error) {
	response = CreateSaveSingleTaskForCreatingOrderRenewResponse()
	err = client.DoAction(request, response)
	return
}

// SaveSingleTaskForCreatingOrderRenewWithChan invokes the domain_intl.SaveSingleTaskForCreatingOrderRenew API asynchronously
// api document: https://help.aliyun.com/api/domain-intl/savesingletaskforcreatingorderrenew.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveSingleTaskForCreatingOrderRenewWithChan(request *SaveSingleTaskForCreatingOrderRenewRequest) (<-chan *SaveSingleTaskForCreatingOrderRenewResponse, <-chan error) {
	responseChan := make(chan *SaveSingleTaskForCreatingOrderRenewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveSingleTaskForCreatingOrderRenew(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveSingleTaskForCreatingOrderRenewWithCallback invokes the domain_intl.SaveSingleTaskForCreatingOrderRenew API asynchronously
// api document: https://help.aliyun.com/api/domain-intl/savesingletaskforcreatingorderrenew.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveSingleTaskForCreatingOrderRenewWithCallback(request *SaveSingleTaskForCreatingOrderRenewRequest, callback func(response *SaveSingleTaskForCreatingOrderRenewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveSingleTaskForCreatingOrderRenewResponse
		var err error
		defer close(result)
		response, err = client.SaveSingleTaskForCreatingOrderRenew(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveSingleTaskForCreatingOrderRenewRequest is the request struct for api SaveSingleTaskForCreatingOrderRenew
type SaveSingleTaskForCreatingOrderRenewRequest struct {
	*requests.RpcRequest
	SubscriptionDuration  requests.Integer `position:"Query" name:"SubscriptionDuration"`
	PromotionNo           string           `position:"Query" name:"PromotionNo"`
	CurrentExpirationDate requests.Integer `position:"Query" name:"CurrentExpirationDate"`
	UserClientIp          string           `position:"Query" name:"UserClientIp"`
	DomainName            string           `position:"Query" name:"DomainName"`
	CouponNo              string           `position:"Query" name:"CouponNo"`
	UseCoupon             requests.Boolean `position:"Query" name:"UseCoupon"`
	Lang                  string           `position:"Query" name:"Lang"`
	UsePromotion          requests.Boolean `position:"Query" name:"UsePromotion"`
}

// SaveSingleTaskForCreatingOrderRenewResponse is the response struct for api SaveSingleTaskForCreatingOrderRenew
type SaveSingleTaskForCreatingOrderRenewResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskNo    string `json:"TaskNo" xml:"TaskNo"`
}

// CreateSaveSingleTaskForCreatingOrderRenewRequest creates a request to invoke SaveSingleTaskForCreatingOrderRenew API
func CreateSaveSingleTaskForCreatingOrderRenewRequest() (request *SaveSingleTaskForCreatingOrderRenewRequest) {
	request = &SaveSingleTaskForCreatingOrderRenewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain-intl", "2017-12-18", "SaveSingleTaskForCreatingOrderRenew", "domain", "openAPI")
	return
}

// CreateSaveSingleTaskForCreatingOrderRenewResponse creates a response to parse from SaveSingleTaskForCreatingOrderRenew response
func CreateSaveSingleTaskForCreatingOrderRenewResponse() (response *SaveSingleTaskForCreatingOrderRenewResponse) {
	response = &SaveSingleTaskForCreatingOrderRenewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
