package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDrdsSlowSqls invokes the drds.DescribeDrdsSlowSqls API synchronously
func (client *Client) DescribeDrdsSlowSqls(request *DescribeDrdsSlowSqlsRequest) (response *DescribeDrdsSlowSqlsResponse, err error) {
	response = CreateDescribeDrdsSlowSqlsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDrdsSlowSqlsWithChan invokes the drds.DescribeDrdsSlowSqls API asynchronously
func (client *Client) DescribeDrdsSlowSqlsWithChan(request *DescribeDrdsSlowSqlsRequest) (<-chan *DescribeDrdsSlowSqlsResponse, <-chan error) {
	responseChan := make(chan *DescribeDrdsSlowSqlsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDrdsSlowSqls(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDrdsSlowSqlsWithCallback invokes the drds.DescribeDrdsSlowSqls API asynchronously
func (client *Client) DescribeDrdsSlowSqlsWithCallback(request *DescribeDrdsSlowSqlsRequest, callback func(response *DescribeDrdsSlowSqlsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDrdsSlowSqlsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDrdsSlowSqls(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDrdsSlowSqlsRequest is the request struct for api DescribeDrdsSlowSqls
type DescribeDrdsSlowSqlsRequest struct {
	*requests.RpcRequest
	EndTime        requests.Integer `position:"Query" name:"EndTime"`
	StartTime      requests.Integer `position:"Query" name:"StartTime"`
	DrdsInstanceId string           `position:"Query" name:"DrdsInstanceId"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	DbName         string           `position:"Query" name:"DbName"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	ExeTime        requests.Integer `position:"Query" name:"ExeTime"`
}

// DescribeDrdsSlowSqlsResponse is the response struct for api DescribeDrdsSlowSqls
type DescribeDrdsSlowSqlsResponse struct {
	*responses.BaseResponse
	RequestId  string                      `json:"RequestId" xml:"RequestId"`
	Success    bool                        `json:"Success" xml:"Success"`
	Total      int                         `json:"Total" xml:"Total"`
	PageNumber int                         `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                         `json:"PageSize" xml:"PageSize"`
	Items      ItemsInDescribeDrdsSlowSqls `json:"Items" xml:"Items"`
}

// CreateDescribeDrdsSlowSqlsRequest creates a request to invoke DescribeDrdsSlowSqls API
func CreateDescribeDrdsSlowSqlsRequest() (request *DescribeDrdsSlowSqlsRequest) {
	request = &DescribeDrdsSlowSqlsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeDrdsSlowSqls", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDrdsSlowSqlsResponse creates a response to parse from DescribeDrdsSlowSqls response
func CreateDescribeDrdsSlowSqlsResponse() (response *DescribeDrdsSlowSqlsResponse) {
	response = &DescribeDrdsSlowSqlsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
