package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetClusterEngineVersions invokes the foas.GetClusterEngineVersions API synchronously
func (client *Client) GetClusterEngineVersions(request *GetClusterEngineVersionsRequest) (response *GetClusterEngineVersionsResponse, err error) {
	response = CreateGetClusterEngineVersionsResponse()
	err = client.DoAction(request, response)
	return
}

// GetClusterEngineVersionsWithChan invokes the foas.GetClusterEngineVersions API asynchronously
func (client *Client) GetClusterEngineVersionsWithChan(request *GetClusterEngineVersionsRequest) (<-chan *GetClusterEngineVersionsResponse, <-chan error) {
	responseChan := make(chan *GetClusterEngineVersionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetClusterEngineVersions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetClusterEngineVersionsWithCallback invokes the foas.GetClusterEngineVersions API asynchronously
func (client *Client) GetClusterEngineVersionsWithCallback(request *GetClusterEngineVersionsRequest, callback func(response *GetClusterEngineVersionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetClusterEngineVersionsResponse
		var err error
		defer close(result)
		response, err = client.GetClusterEngineVersions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetClusterEngineVersionsRequest is the request struct for api GetClusterEngineVersions
type GetClusterEngineVersionsRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Path" name:"clusterId"`
}

// GetClusterEngineVersionsResponse is the response struct for api GetClusterEngineVersions
type GetClusterEngineVersionsResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	EngineVersions EngineVersions `json:"EngineVersions" xml:"EngineVersions"`
}

// CreateGetClusterEngineVersionsRequest creates a request to invoke GetClusterEngineVersions API
func CreateGetClusterEngineVersionsRequest() (request *GetClusterEngineVersionsRequest) {
	request = &GetClusterEngineVersionsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "GetClusterEngineVersions", "/api/v2/clusters/[clusterId]/engineversions", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetClusterEngineVersionsResponse creates a response to parse from GetClusterEngineVersions response
func CreateGetClusterEngineVersionsResponse() (response *GetClusterEngineVersionsResponse) {
	response = &GetClusterEngineVersionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
