package ft

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FtDynamicAddressHsf invokes the ft.FtDynamicAddressHsf API synchronously
func (client *Client) FtDynamicAddressHsf(request *FtDynamicAddressHsfRequest) (response *FtDynamicAddressHsfResponse, err error) {
	response = CreateFtDynamicAddressHsfResponse()
	err = client.DoAction(request, response)
	return
}

// FtDynamicAddressHsfWithChan invokes the ft.FtDynamicAddressHsf API asynchronously
func (client *Client) FtDynamicAddressHsfWithChan(request *FtDynamicAddressHsfRequest) (<-chan *FtDynamicAddressHsfResponse, <-chan error) {
	responseChan := make(chan *FtDynamicAddressHsfResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FtDynamicAddressHsf(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FtDynamicAddressHsfWithCallback invokes the ft.FtDynamicAddressHsf API asynchronously
func (client *Client) FtDynamicAddressHsfWithCallback(request *FtDynamicAddressHsfRequest, callback func(response *FtDynamicAddressHsfResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FtDynamicAddressHsfResponse
		var err error
		defer close(result)
		response, err = client.FtDynamicAddressHsf(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FtDynamicAddressHsfRequest is the request struct for api FtDynamicAddressHsf
type FtDynamicAddressHsfRequest struct {
	*requests.RpcRequest
}

// FtDynamicAddressHsfResponse is the response struct for api FtDynamicAddressHsf
type FtDynamicAddressHsfResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateFtDynamicAddressHsfRequest creates a request to invoke FtDynamicAddressHsf API
func CreateFtDynamicAddressHsfRequest() (request *FtDynamicAddressHsfRequest) {
	request = &FtDynamicAddressHsfRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ft", "2018-07-13", "FtDynamicAddressHsf", "", "")
	request.Method = requests.POST
	return
}

// CreateFtDynamicAddressHsfResponse creates a response to parse from FtDynamicAddressHsf response
func CreateFtDynamicAddressHsfResponse() (response *FtDynamicAddressHsfResponse) {
	response = &FtDynamicAddressHsfResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
