package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInstanceServiceConfigurations invokes the hbase.ListInstanceServiceConfigurations API synchronously
func (client *Client) ListInstanceServiceConfigurations(request *ListInstanceServiceConfigurationsRequest) (response *ListInstanceServiceConfigurationsResponse, err error) {
	response = CreateListInstanceServiceConfigurationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListInstanceServiceConfigurationsWithChan invokes the hbase.ListInstanceServiceConfigurations API asynchronously
func (client *Client) ListInstanceServiceConfigurationsWithChan(request *ListInstanceServiceConfigurationsRequest) (<-chan *ListInstanceServiceConfigurationsResponse, <-chan error) {
	responseChan := make(chan *ListInstanceServiceConfigurationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInstanceServiceConfigurations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInstanceServiceConfigurationsWithCallback invokes the hbase.ListInstanceServiceConfigurations API asynchronously
func (client *Client) ListInstanceServiceConfigurationsWithCallback(request *ListInstanceServiceConfigurationsRequest, callback func(response *ListInstanceServiceConfigurationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInstanceServiceConfigurationsResponse
		var err error
		defer close(result)
		response, err = client.ListInstanceServiceConfigurations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInstanceServiceConfigurationsRequest is the request struct for api ListInstanceServiceConfigurations
type ListInstanceServiceConfigurationsRequest struct {
	*requests.RpcRequest
	ClusterId  string           `position:"Query" name:"ClusterId"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListInstanceServiceConfigurationsResponse is the response struct for api ListInstanceServiceConfigurations
type ListInstanceServiceConfigurationsResponse struct {
	*responses.BaseResponse
	RequestId        string        `json:"RequestId" xml:"RequestId"`
	PageNumber       int           `json:"PageNumber" xml:"PageNumber"`
	PageRecordCount  int           `json:"PageRecordCount" xml:"PageRecordCount"`
	TotalRecordCount int64         `json:"TotalRecordCount" xml:"TotalRecordCount"`
	ConfigureList    ConfigureList `json:"ConfigureList" xml:"ConfigureList"`
}

// CreateListInstanceServiceConfigurationsRequest creates a request to invoke ListInstanceServiceConfigurations API
func CreateListInstanceServiceConfigurationsRequest() (request *ListInstanceServiceConfigurationsRequest) {
	request = &ListInstanceServiceConfigurationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "ListInstanceServiceConfigurations", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListInstanceServiceConfigurationsResponse creates a response to parse from ListInstanceServiceConfigurations response
func CreateListInstanceServiceConfigurationsResponse() (response *ListInstanceServiceConfigurationsResponse) {
	response = &ListInstanceServiceConfigurationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
