package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAnalyticsData invokes the iot.ListAnalyticsData API synchronously
func (client *Client) ListAnalyticsData(request *ListAnalyticsDataRequest) (response *ListAnalyticsDataResponse, err error) {
	response = CreateListAnalyticsDataResponse()
	err = client.DoAction(request, response)
	return
}

// ListAnalyticsDataWithChan invokes the iot.ListAnalyticsData API asynchronously
func (client *Client) ListAnalyticsDataWithChan(request *ListAnalyticsDataRequest) (<-chan *ListAnalyticsDataResponse, <-chan error) {
	responseChan := make(chan *ListAnalyticsDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAnalyticsData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAnalyticsDataWithCallback invokes the iot.ListAnalyticsData API asynchronously
func (client *Client) ListAnalyticsDataWithCallback(request *ListAnalyticsDataRequest, callback func(response *ListAnalyticsDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAnalyticsDataResponse
		var err error
		defer close(result)
		response, err = client.ListAnalyticsData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAnalyticsDataRequest is the request struct for api ListAnalyticsData
type ListAnalyticsDataRequest struct {
	*requests.RpcRequest
	PageNum       requests.Integer              `position:"Query" name:"PageNum"`
	IotInstanceId string                        `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer              `position:"Query" name:"PageSize"`
	IsoId         string                        `position:"Query" name:"IsoId"`
	ApiPath       string                        `position:"Query" name:"ApiPath"`
	Condition     *[]ListAnalyticsDataCondition `position:"Query" name:"Condition"  type:"Repeated"`
	ApiProduct    string                        `position:"Body" name:"ApiProduct"`
	ApiRevision   string                        `position:"Body" name:"ApiRevision"`
}

// ListAnalyticsDataCondition is a repeated param struct in ListAnalyticsDataRequest
type ListAnalyticsDataCondition struct {
	FieldName    string `name:"FieldName"`
	Operate      string `name:"Operate"`
	BetweenStart string `name:"BetweenStart"`
	BetweenEnd   string `name:"BetweenEnd"`
	Value        string `name:"Value"`
}

// ListAnalyticsDataResponse is the response struct for api ListAnalyticsData
type ListAnalyticsDataResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateListAnalyticsDataRequest creates a request to invoke ListAnalyticsData API
func CreateListAnalyticsDataRequest() (request *ListAnalyticsDataRequest) {
	request = &ListAnalyticsDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ListAnalyticsData", "", "")
	request.Method = requests.POST
	return
}

// CreateListAnalyticsDataResponse creates a response to parse from ListAnalyticsData response
func CreateListAnalyticsDataResponse() (response *ListAnalyticsDataResponse) {
	response = &ListAnalyticsDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
