package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AsymmetricVerify invokes the kms.AsymmetricVerify API synchronously
func (client *Client) AsymmetricVerify(request *AsymmetricVerifyRequest) (response *AsymmetricVerifyResponse, err error) {
	response = CreateAsymmetricVerifyResponse()
	err = client.DoAction(request, response)
	return
}

// AsymmetricVerifyWithChan invokes the kms.AsymmetricVerify API asynchronously
func (client *Client) AsymmetricVerifyWithChan(request *AsymmetricVerifyRequest) (<-chan *AsymmetricVerifyResponse, <-chan error) {
	responseChan := make(chan *AsymmetricVerifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AsymmetricVerify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AsymmetricVerifyWithCallback invokes the kms.AsymmetricVerify API asynchronously
func (client *Client) AsymmetricVerifyWithCallback(request *AsymmetricVerifyRequest, callback func(response *AsymmetricVerifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AsymmetricVerifyResponse
		var err error
		defer close(result)
		response, err = client.AsymmetricVerify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AsymmetricVerifyRequest is the request struct for api AsymmetricVerify
type AsymmetricVerifyRequest struct {
	*requests.RpcRequest
	KeyVersionId string `position:"Query" name:"KeyVersionId"`
	Digest       string `position:"Query" name:"Digest"`
	KeyId        string `position:"Query" name:"KeyId"`
	Value        string `position:"Query" name:"Value"`
	Algorithm    string `position:"Query" name:"Algorithm"`
}

// AsymmetricVerifyResponse is the response struct for api AsymmetricVerify
type AsymmetricVerifyResponse struct {
	*responses.BaseResponse
	Value        bool   `json:"Value" xml:"Value"`
	KeyId        string `json:"KeyId" xml:"KeyId"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	KeyVersionId string `json:"KeyVersionId" xml:"KeyVersionId"`
}

// CreateAsymmetricVerifyRequest creates a request to invoke AsymmetricVerify API
func CreateAsymmetricVerifyRequest() (request *AsymmetricVerifyRequest) {
	request = &AsymmetricVerifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "AsymmetricVerify", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAsymmetricVerifyResponse creates a response to parse from AsymmetricVerify response
func CreateAsymmetricVerifyResponse() (response *AsymmetricVerifyResponse) {
	response = &AsymmetricVerifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
