package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyShowList invokes the live.ModifyShowList API synchronously
func (client *Client) ModifyShowList(request *ModifyShowListRequest) (response *ModifyShowListResponse, err error) {
	response = CreateModifyShowListResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyShowListWithChan invokes the live.ModifyShowList API asynchronously
func (client *Client) ModifyShowListWithChan(request *ModifyShowListRequest) (<-chan *ModifyShowListResponse, <-chan error) {
	responseChan := make(chan *ModifyShowListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyShowList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyShowListWithCallback invokes the live.ModifyShowList API asynchronously
func (client *Client) ModifyShowListWithCallback(request *ModifyShowListRequest, callback func(response *ModifyShowListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyShowListResponse
		var err error
		defer close(result)
		response, err = client.ModifyShowList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyShowListRequest is the request struct for api ModifyShowList
type ModifyShowListRequest struct {
	*requests.RpcRequest
	RepeatTimes               requests.Integer `position:"Query" name:"RepeatTimes"`
	HighPriorityShowStartTime string           `position:"Query" name:"HighPriorityShowStartTime"`
	CasterId                  string           `position:"Query" name:"CasterId"`
	HighPriorityShowId        string           `position:"Query" name:"HighPriorityShowId"`
	OwnerId                   requests.Integer `position:"Query" name:"OwnerId"`
	ShowId                    string           `position:"Query" name:"ShowId"`
	Spot                      requests.Integer `position:"Query" name:"Spot"`
}

// ModifyShowListResponse is the response struct for api ModifyShowList
type ModifyShowListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyShowListRequest creates a request to invoke ModifyShowList API
func CreateModifyShowListRequest() (request *ModifyShowListRequest) {
	request = &ModifyShowListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ModifyShowList", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyShowListResponse creates a response to parse from ModifyShowList response
func CreateModifyShowListResponse() (response *ModifyShowListResponse) {
	response = &ModifyShowListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
