package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyTagPolicies invokes the mse.ApplyTagPolicies API synchronously
func (client *Client) ApplyTagPolicies(request *ApplyTagPoliciesRequest) (response *ApplyTagPoliciesResponse, err error) {
	response = CreateApplyTagPoliciesResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyTagPoliciesWithChan invokes the mse.ApplyTagPolicies API asynchronously
func (client *Client) ApplyTagPoliciesWithChan(request *ApplyTagPoliciesRequest) (<-chan *ApplyTagPoliciesResponse, <-chan error) {
	responseChan := make(chan *ApplyTagPoliciesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyTagPolicies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyTagPoliciesWithCallback invokes the mse.ApplyTagPolicies API asynchronously
func (client *Client) ApplyTagPoliciesWithCallback(request *ApplyTagPoliciesRequest, callback func(response *ApplyTagPoliciesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyTagPoliciesResponse
		var err error
		defer close(result)
		response, err = client.ApplyTagPolicies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyTagPoliciesRequest is the request struct for api ApplyTagPolicies
type ApplyTagPoliciesRequest struct {
	*requests.RpcRequest
	Rules          string           `position:"Query" name:"Rules"`
	Source         string           `position:"Query" name:"Source"`
	NamespaceId    string           `position:"Query" name:"NamespaceId"`
	Enable         requests.Boolean `position:"Query" name:"Enable"`
	AppId          string           `position:"Query" name:"AppId"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
	Region         string           `position:"Query" name:"Region"`
}

// ApplyTagPoliciesResponse is the response struct for api ApplyTagPolicies
type ApplyTagPoliciesResponse struct {
	*responses.BaseResponse
	HttpStatusCode int           `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string        `json:"Message" xml:"Message"`
	RequestId      string        `json:"RequestId" xml:"RequestId"`
	Code           int           `json:"Code" xml:"Code"`
	Success        bool          `json:"Success" xml:"Success"`
	Data           []RouteRuleVO `json:"Data" xml:"Data"`
}

// CreateApplyTagPoliciesRequest creates a request to invoke ApplyTagPolicies API
func CreateApplyTagPoliciesRequest() (request *ApplyTagPoliciesRequest) {
	request = &ApplyTagPoliciesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ApplyTagPolicies", "", "")
	request.Method = requests.POST
	return
}

// CreateApplyTagPoliciesResponse creates a response to parse from ApplyTagPolicies response
func CreateApplyTagPoliciesResponse() (response *ApplyTagPoliciesResponse) {
	response = &ApplyTagPoliciesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
