package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetModelProgress invokes the opensearch.GetModelProgress API synchronously
func (client *Client) GetModelProgress(request *GetModelProgressRequest) (response *GetModelProgressResponse, err error) {
	response = CreateGetModelProgressResponse()
	err = client.DoAction(request, response)
	return
}

// GetModelProgressWithChan invokes the opensearch.GetModelProgress API asynchronously
func (client *Client) GetModelProgressWithChan(request *GetModelProgressRequest) (<-chan *GetModelProgressResponse, <-chan error) {
	responseChan := make(chan *GetModelProgressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetModelProgress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetModelProgressWithCallback invokes the opensearch.GetModelProgress API asynchronously
func (client *Client) GetModelProgressWithCallback(request *GetModelProgressRequest, callback func(response *GetModelProgressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetModelProgressResponse
		var err error
		defer close(result)
		response, err = client.GetModelProgress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetModelProgressRequest is the request struct for api GetModelProgress
type GetModelProgressRequest struct {
	*requests.RoaRequest
	ModelName        string `position:"Path" name:"modelName"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// GetModelProgressResponse is the response struct for api GetModelProgress
type GetModelProgressResponse struct {
	*responses.BaseResponse
	RequestId string                   `json:"requestId" xml:"requestId"`
	Result    ResultInGetModelProgress `json:"result" xml:"result"`
}

// CreateGetModelProgressRequest creates a request to invoke GetModelProgress API
func CreateGetModelProgressRequest() (request *GetModelProgressRequest) {
	request = &GetModelProgressRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "GetModelProgress", "/v4/openapi/app-groups/[appGroupIdentity]/algorithm/models/[modelName]/progress", "opensearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetModelProgressResponse creates a response to parse from GetModelProgress response
func CreateGetModelProgressResponse() (response *GetModelProgressResponse) {
	response = &GetModelProgressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
