package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRecordRemark invokes the pvtz.UpdateRecordRemark API synchronously
func (client *Client) UpdateRecordRemark(request *UpdateRecordRemarkRequest) (response *UpdateRecordRemarkResponse, err error) {
	response = CreateUpdateRecordRemarkResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRecordRemarkWithChan invokes the pvtz.UpdateRecordRemark API asynchronously
func (client *Client) UpdateRecordRemarkWithChan(request *UpdateRecordRemarkRequest) (<-chan *UpdateRecordRemarkResponse, <-chan error) {
	responseChan := make(chan *UpdateRecordRemarkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRecordRemark(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRecordRemarkWithCallback invokes the pvtz.UpdateRecordRemark API asynchronously
func (client *Client) UpdateRecordRemarkWithCallback(request *UpdateRecordRemarkRequest, callback func(response *UpdateRecordRemarkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRecordRemarkResponse
		var err error
		defer close(result)
		response, err = client.UpdateRecordRemark(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRecordRemarkRequest is the request struct for api UpdateRecordRemark
type UpdateRecordRemarkRequest struct {
	*requests.RpcRequest
	Remark       string           `position:"Query" name:"Remark"`
	RecordId     requests.Integer `position:"Query" name:"RecordId"`
	UserClientIp string           `position:"Query" name:"UserClientIp"`
	Lang         string           `position:"Query" name:"Lang"`
}

// UpdateRecordRemarkResponse is the response struct for api UpdateRecordRemark
type UpdateRecordRemarkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	RecordId  int64  `json:"RecordId" xml:"RecordId"`
}

// CreateUpdateRecordRemarkRequest creates a request to invoke UpdateRecordRemark API
func CreateUpdateRecordRemarkRequest() (request *UpdateRecordRemarkRequest) {
	request = &UpdateRecordRemarkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "UpdateRecordRemark", "pvtz", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateRecordRemarkResponse creates a response to parse from UpdateRecordRemark response
func CreateUpdateRecordRemarkResponse() (response *UpdateRecordRemarkResponse) {
	response = &UpdateRecordRemarkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
