package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSmartAccessGatewayClientUser invokes the smartag.CreateSmartAccessGatewayClientUser API synchronously
func (client *Client) CreateSmartAccessGatewayClientUser(request *CreateSmartAccessGatewayClientUserRequest) (response *CreateSmartAccessGatewayClientUserResponse, err error) {
	response = CreateCreateSmartAccessGatewayClientUserResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSmartAccessGatewayClientUserWithChan invokes the smartag.CreateSmartAccessGatewayClientUser API asynchronously
func (client *Client) CreateSmartAccessGatewayClientUserWithChan(request *CreateSmartAccessGatewayClientUserRequest) (<-chan *CreateSmartAccessGatewayClientUserResponse, <-chan error) {
	responseChan := make(chan *CreateSmartAccessGatewayClientUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSmartAccessGatewayClientUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSmartAccessGatewayClientUserWithCallback invokes the smartag.CreateSmartAccessGatewayClientUser API asynchronously
func (client *Client) CreateSmartAccessGatewayClientUserWithCallback(request *CreateSmartAccessGatewayClientUserRequest, callback func(response *CreateSmartAccessGatewayClientUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSmartAccessGatewayClientUserResponse
		var err error
		defer close(result)
		response, err = client.CreateSmartAccessGatewayClientUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSmartAccessGatewayClientUserRequest is the request struct for api CreateSmartAccessGatewayClientUser
type CreateSmartAccessGatewayClientUserRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Password             string           `position:"Query" name:"Password"`
	ClientIp             string           `position:"Query" name:"ClientIp"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	Bandwidth            requests.Integer `position:"Query" name:"Bandwidth"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	UserMail             string           `position:"Query" name:"UserMail"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	UserName             string           `position:"Query" name:"UserName"`
}

// CreateSmartAccessGatewayClientUserResponse is the response struct for api CreateSmartAccessGatewayClientUser
type CreateSmartAccessGatewayClientUserResponse struct {
	*responses.BaseResponse
	UserName  string `json:"UserName" xml:"UserName"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	UserMail  string `json:"UserMail" xml:"UserMail"`
	Bandwidth int    `json:"Bandwidth" xml:"Bandwidth"`
	ClientIp  string `json:"ClientIp" xml:"ClientIp"`
}

// CreateCreateSmartAccessGatewayClientUserRequest creates a request to invoke CreateSmartAccessGatewayClientUser API
func CreateCreateSmartAccessGatewayClientUserRequest() (request *CreateSmartAccessGatewayClientUserRequest) {
	request = &CreateSmartAccessGatewayClientUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "CreateSmartAccessGatewayClientUser", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSmartAccessGatewayClientUserResponse creates a response to parse from CreateSmartAccessGatewayClientUser response
func CreateCreateSmartAccessGatewayClientUserResponse() (response *CreateSmartAccessGatewayClientUserResponse) {
	response = &CreateSmartAccessGatewayClientUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
