package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteIpv6InternetBandwidth invokes the vpc.DeleteIpv6InternetBandwidth API synchronously
func (client *Client) DeleteIpv6InternetBandwidth(request *DeleteIpv6InternetBandwidthRequest) (response *DeleteIpv6InternetBandwidthResponse, err error) {
	response = CreateDeleteIpv6InternetBandwidthResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteIpv6InternetBandwidthWithChan invokes the vpc.DeleteIpv6InternetBandwidth API asynchronously
func (client *Client) DeleteIpv6InternetBandwidthWithChan(request *DeleteIpv6InternetBandwidthRequest) (<-chan *DeleteIpv6InternetBandwidthResponse, <-chan error) {
	responseChan := make(chan *DeleteIpv6InternetBandwidthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteIpv6InternetBandwidth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteIpv6InternetBandwidthWithCallback invokes the vpc.DeleteIpv6InternetBandwidth API asynchronously
func (client *Client) DeleteIpv6InternetBandwidthWithCallback(request *DeleteIpv6InternetBandwidthRequest, callback func(response *DeleteIpv6InternetBandwidthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteIpv6InternetBandwidthResponse
		var err error
		defer close(result)
		response, err = client.DeleteIpv6InternetBandwidth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteIpv6InternetBandwidthRequest is the request struct for api DeleteIpv6InternetBandwidth
type DeleteIpv6InternetBandwidthRequest struct {
	*requests.RpcRequest
	ResourceOwnerId         requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Ipv6InternetBandwidthId string           `position:"Query" name:"Ipv6InternetBandwidthId"`
	ResourceOwnerAccount    string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount            string           `position:"Query" name:"OwnerAccount"`
	OwnerId                 requests.Integer `position:"Query" name:"OwnerId"`
	Ipv6AddressId           string           `position:"Query" name:"Ipv6AddressId"`
}

// DeleteIpv6InternetBandwidthResponse is the response struct for api DeleteIpv6InternetBandwidth
type DeleteIpv6InternetBandwidthResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteIpv6InternetBandwidthRequest creates a request to invoke DeleteIpv6InternetBandwidth API
func CreateDeleteIpv6InternetBandwidthRequest() (request *DeleteIpv6InternetBandwidthRequest) {
	request = &DeleteIpv6InternetBandwidthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteIpv6InternetBandwidth", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteIpv6InternetBandwidthResponse creates a response to parse from DeleteIpv6InternetBandwidth response
func CreateDeleteIpv6InternetBandwidthResponse() (response *DeleteIpv6InternetBandwidthResponse) {
	response = &DeleteIpv6InternetBandwidthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
