//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/filters/http/header_to_metadata/v3/header_to_metadata.proto

package header_to_metadatav3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on Config with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Config) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Config with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in ConfigMultiError, or nil if none found.
func (m *Config) ValidateAll() error {
	return m.validate(true)
}

func (m *Config) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetRequestRules() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ConfigValidationError{
						field:  fmt.Sprintf("RequestRules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ConfigValidationError{
						field:  fmt.Sprintf("RequestRules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ConfigValidationError{
					field:  fmt.Sprintf("RequestRules[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetResponseRules() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ConfigValidationError{
						field:  fmt.Sprintf("ResponseRules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ConfigValidationError{
						field:  fmt.Sprintf("ResponseRules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ConfigValidationError{
					field:  fmt.Sprintf("ResponseRules[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return ConfigMultiError(errors)
	}

	return nil
}

// ConfigMultiError is an error wrapping multiple validation errors returned by
// Config.ValidateAll() if the designated constraints aren't met.
type ConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ConfigMultiError) AllErrors() []error { return m }

// ConfigValidationError is the validation error returned by Config.Validate if
// the designated constraints aren't met.
type ConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ConfigValidationError) ErrorName() string { return "ConfigValidationError" }

// Error satisfies the builtin error interface
func (e ConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ConfigValidationError{}

// Validate checks the field values on Config_KeyValuePair with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Config_KeyValuePair) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Config_KeyValuePair with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Config_KeyValuePairMultiError, or nil if none found.
func (m *Config_KeyValuePair) ValidateAll() error {
	return m.validate(true)
}

func (m *Config_KeyValuePair) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for MetadataNamespace

	if utf8.RuneCountInString(m.GetKey()) < 1 {
		err := Config_KeyValuePairValidationError{
			field:  "Key",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Value

	if all {
		switch v := interface{}(m.GetRegexValueRewrite()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Config_KeyValuePairValidationError{
					field:  "RegexValueRewrite",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Config_KeyValuePairValidationError{
					field:  "RegexValueRewrite",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRegexValueRewrite()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Config_KeyValuePairValidationError{
				field:  "RegexValueRewrite",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if _, ok := Config_ValueType_name[int32(m.GetType())]; !ok {
		err := Config_KeyValuePairValidationError{
			field:  "Type",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Encode

	if len(errors) > 0 {
		return Config_KeyValuePairMultiError(errors)
	}

	return nil
}

// Config_KeyValuePairMultiError is an error wrapping multiple validation
// errors returned by Config_KeyValuePair.ValidateAll() if the designated
// constraints aren't met.
type Config_KeyValuePairMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Config_KeyValuePairMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Config_KeyValuePairMultiError) AllErrors() []error { return m }

// Config_KeyValuePairValidationError is the validation error returned by
// Config_KeyValuePair.Validate if the designated constraints aren't met.
type Config_KeyValuePairValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Config_KeyValuePairValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Config_KeyValuePairValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Config_KeyValuePairValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Config_KeyValuePairValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Config_KeyValuePairValidationError) ErrorName() string {
	return "Config_KeyValuePairValidationError"
}

// Error satisfies the builtin error interface
func (e Config_KeyValuePairValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConfig_KeyValuePair.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Config_KeyValuePairValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Config_KeyValuePairValidationError{}

// Validate checks the field values on Config_Rule with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Config_Rule) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Config_Rule with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in Config_RuleMultiError, or
// nil if none found.
func (m *Config_Rule) ValidateAll() error {
	return m.validate(true)
}

func (m *Config_Rule) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_Config_Rule_Header_Pattern.MatchString(m.GetHeader()) {
		err := Config_RuleValidationError{
			field:  "Header",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_Config_Rule_Cookie_Pattern.MatchString(m.GetCookie()) {
		err := Config_RuleValidationError{
			field:  "Cookie",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetOnHeaderPresent()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Config_RuleValidationError{
					field:  "OnHeaderPresent",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Config_RuleValidationError{
					field:  "OnHeaderPresent",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetOnHeaderPresent()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Config_RuleValidationError{
				field:  "OnHeaderPresent",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetOnHeaderMissing()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Config_RuleValidationError{
					field:  "OnHeaderMissing",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Config_RuleValidationError{
					field:  "OnHeaderMissing",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetOnHeaderMissing()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Config_RuleValidationError{
				field:  "OnHeaderMissing",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Remove

	if len(errors) > 0 {
		return Config_RuleMultiError(errors)
	}

	return nil
}

// Config_RuleMultiError is an error wrapping multiple validation errors
// returned by Config_Rule.ValidateAll() if the designated constraints aren't met.
type Config_RuleMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Config_RuleMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Config_RuleMultiError) AllErrors() []error { return m }

// Config_RuleValidationError is the validation error returned by
// Config_Rule.Validate if the designated constraints aren't met.
type Config_RuleValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Config_RuleValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Config_RuleValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Config_RuleValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Config_RuleValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Config_RuleValidationError) ErrorName() string { return "Config_RuleValidationError" }

// Error satisfies the builtin error interface
func (e Config_RuleValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConfig_Rule.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Config_RuleValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Config_RuleValidationError{}

var _Config_Rule_Header_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _Config_Rule_Cookie_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")
