// Code generated by go-swagger; DO NOT EDIT.

package cli

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-swagger/go-swagger/examples/cli/models"
	"github.com/spf13/cobra"
)

// Schema cli for Error

// register flags to command
func registerModelErrorFlags(depth int, cmdPrefix string, cmd *cobra.Command) error {

	if err := registerErrorCode(depth, cmdPrefix, cmd); err != nil {
		return err
	}

	if err := registerErrorMessage(depth, cmdPrefix, cmd); err != nil {
		return err
	}

	return nil
}

func registerErrorCode(depth int, cmdPrefix string, cmd *cobra.Command) error {
	if depth > maxDepth {
		return nil
	}

	codeDescription := ``

	var codeFlagName string
	if cmdPrefix == "" {
		codeFlagName = "code"
	} else {
		codeFlagName = fmt.Sprintf("%v.code", cmdPrefix)
	}

	var codeFlagDefault int64

	_ = cmd.PersistentFlags().Int64(codeFlagName, codeFlagDefault, codeDescription)

	return nil
}

func registerErrorMessage(depth int, cmdPrefix string, cmd *cobra.Command) error {
	if depth > maxDepth {
		return nil
	}

	messageDescription := `Required. `

	var messageFlagName string
	if cmdPrefix == "" {
		messageFlagName = "message"
	} else {
		messageFlagName = fmt.Sprintf("%v.message", cmdPrefix)
	}

	var messageFlagDefault string

	_ = cmd.PersistentFlags().String(messageFlagName, messageFlagDefault, messageDescription)

	return nil
}

// retrieve flags from commands, and set value in model. Return true if any flag is passed by user to fill model field.
func retrieveModelErrorFlags(depth int, m *models.Error, cmdPrefix string, cmd *cobra.Command) (error, bool) {
	retAdded := false

	err, codeAdded := retrieveErrorCodeFlags(depth, m, cmdPrefix, cmd)
	if err != nil {
		return err, false
	}
	retAdded = retAdded || codeAdded

	err, messageAdded := retrieveErrorMessageFlags(depth, m, cmdPrefix, cmd)
	if err != nil {
		return err, false
	}
	retAdded = retAdded || messageAdded

	return nil, retAdded
}

func retrieveErrorCodeFlags(depth int, m *models.Error, cmdPrefix string, cmd *cobra.Command) (error, bool) {
	if depth > maxDepth {
		return nil, false
	}
	retAdded := false

	codeFlagName := fmt.Sprintf("%v.code", cmdPrefix)
	if cmd.Flags().Changed(codeFlagName) {

		var codeFlagName string
		if cmdPrefix == "" {
			codeFlagName = "code"
		} else {
			codeFlagName = fmt.Sprintf("%v.code", cmdPrefix)
		}

		codeFlagValue, err := cmd.Flags().GetInt64(codeFlagName)
		if err != nil {
			return err, false
		}
		m.Code = codeFlagValue

		retAdded = true
	}

	return nil, retAdded
}

func retrieveErrorMessageFlags(depth int, m *models.Error, cmdPrefix string, cmd *cobra.Command) (error, bool) {
	if depth > maxDepth {
		return nil, false
	}
	retAdded := false

	messageFlagName := fmt.Sprintf("%v.message", cmdPrefix)
	if cmd.Flags().Changed(messageFlagName) {

		var messageFlagName string
		if cmdPrefix == "" {
			messageFlagName = "message"
		} else {
			messageFlagName = fmt.Sprintf("%v.message", cmdPrefix)
		}

		messageFlagValue, err := cmd.Flags().GetString(messageFlagName)
		if err != nil {
			return err, false
		}
		m.Message = &messageFlagValue

		retAdded = true
	}

	return nil, retAdded
}
