# Change Log

## [0.9.0](https://github.com/go-swagger/go-swagger/tree/0.9.0) (2017-04-09)
[Full Changelog](https://github.com/go-swagger/go-swagger/compare/0.8.0...0.9.0)

**Implemented enhancements:**

- Allow Bypassing FormatContent on Render [\#894](https://github.com/go-swagger/go-swagger/issues/894)
- tutorial needed on how to generate a service using kvstore as an example [\#889](https://github.com/go-swagger/go-swagger/issues/889)
- support bash/zsh autocompletion for swagger [\#886](https://github.com/go-swagger/go-swagger/issues/886)
- validate spec before generating, with opt-out option [\#825](https://github.com/go-swagger/go-swagger/issues/825)
- Improve Defaults of Server \(API\) Configuration [\#810](https://github.com/go-swagger/go-swagger/issues/810)
- Support new `operation` annotation [\#793](https://github.com/go-swagger/go-swagger/issues/793)
- Complete swagger:route generator based on full OpenAPI router spec [\#790](https://github.com/go-swagger/go-swagger/issues/790)
- Question: Is it possible to use existing type instead of generated model? [\#778](https://github.com/go-swagger/go-swagger/issues/778)
- Couldn't find swag.DateTime\(strfmt.DateTime\) \*strfmt.DateTime [\#734](https://github.com/go-swagger/go-swagger/issues/734)
- How to implement URLs to resources? [\#604](https://github.com/go-swagger/go-swagger/issues/604)
- Generate an url builder method for every resource path [\#119](https://github.com/go-swagger/go-swagger/issues/119)
- validate spec prior to gen. client/server [\#852](https://github.com/go-swagger/go-swagger/pull/852) ([GlenDC](https://github.com/GlenDC))
- add HTTPClient parameter functions [\#849](https://github.com/go-swagger/go-swagger/pull/849) ([GlenDC](https://github.com/GlenDC))

**Fixed bugs:**

- Path parameters not unescaped correctly [\#928](https://github.com/go-swagger/go-swagger/issues/928)
- routing issue when path param name contains a dash [\#907](https://github.com/go-swagger/go-swagger/issues/907)
- path params not always set to required:true [\#905](https://github.com/go-swagger/go-swagger/issues/905)
- Path not found error for endpoint with trailing slash [\#899](https://github.com/go-swagger/go-swagger/issues/899)
- Flattened spec does not validate. [\#898](https://github.com/go-swagger/go-swagger/issues/898)
- Generating array in response-header fails [\#881](https://github.com/go-swagger/go-swagger/issues/881)
- Spec generation examples and documentation does not match [\#879](https://github.com/go-swagger/go-swagger/issues/879)
- don't allow empty items in spec in resolveSimpleType [\#875](https://github.com/go-swagger/go-swagger/issues/875)
- root path `/` operations cannot be found in generated serverapi [\#870](https://github.com/go-swagger/go-swagger/issues/870)
- Debugging generated client at runtime [\#862](https://github.com/go-swagger/go-swagger/issues/862)
- Mistype [\#853](https://github.com/go-swagger/go-swagger/issues/853)
- Type using allOf in generate server has broken MarshalJSON and UnmarshalJSON in 0.8.0 [\#847](https://github.com/go-swagger/go-swagger/issues/847)
- responses dont have a stable order [\#846](https://github.com/go-swagger/go-swagger/issues/846)
- Wrong field selectors are generated when using allOf in response schema definition [\#844](https://github.com/go-swagger/go-swagger/issues/844)
- Model compilation problems when `additionalProperties: true` [\#822](https://github.com/go-swagger/go-swagger/issues/822)
- unresolvable blank format, generates in swagger-codegen, created repo with results [\#811](https://github.com/go-swagger/go-swagger/issues/811)
- Parameter names with brackets fail to generate valid Go variables [\#809](https://github.com/go-swagger/go-swagger/issues/809)
- Client gen not respecting `--tags` parameters [\#795](https://github.com/go-swagger/go-swagger/issues/795)
- Incorrect Validation generated for object field [\#786](https://github.com/go-swagger/go-swagger/issues/786)
- Can't reference definition from file in same directory [\#776](https://github.com/go-swagger/go-swagger/issues/776)
- baseImport doesn't handle case-insensitive paths on windows properly [\#775](https://github.com/go-swagger/go-swagger/issues/775)
- Model property default values not effective on server side processing [\#769](https://github.com/go-swagger/go-swagger/issues/769)
- Validation code for lists of int32s with minimum/maximum inside object fails to compile [\#763](https://github.com/go-swagger/go-swagger/issues/763)
- Server returns 405 Method not allowed instead of 404 for PUT, POST requests with invalid basepath [\#761](https://github.com/go-swagger/go-swagger/issues/761)
- Responses should support a description [\#738](https://github.com/go-swagger/go-swagger/issues/738)
- swagger generate client fails on validated swagger.json [\#733](https://github.com/go-swagger/go-swagger/issues/733)
- Validation error with spec that contains refs to local files [\#729](https://github.com/go-swagger/go-swagger/issues/729)
- Duplicate imports in main.go on pet-store's swagger file. [\#665](https://github.com/go-swagger/go-swagger/issues/665)
- \[BREAKING\] Path tags change code generation in a strange way [\#500](https://github.com/go-swagger/go-swagger/issues/500)

**Closed issues:**

- Remove warning messages [\#993](https://github.com/go-swagger/go-swagger/issues/993)
- Nested Packages: Generating Spec File [\#991](https://github.com/go-swagger/go-swagger/issues/991)
- Question: package names [\#971](https://github.com/go-swagger/go-swagger/issues/971)
- How to write comment when API accepts json body? [\#970](https://github.com/go-swagger/go-swagger/issues/970)
- generate spec from source doesn't support custom name of params on header, query [\#963](https://github.com/go-swagger/go-swagger/issues/963)
- Read request body in middleware. [\#955](https://github.com/go-swagger/go-swagger/issues/955)
- validating content type for "application/json" against \[\] [\#952](https://github.com/go-swagger/go-swagger/issues/952)
- Scanning of SecureDefinitions returns wrong json   [\#949](https://github.com/go-swagger/go-swagger/issues/949)
- Generated import path ignores capitalization [\#941](https://github.com/go-swagger/go-swagger/issues/941)
- Error "target must reside inside a location in the $GOPATH/src", target is in $GOPATH/src \(Windows\) [\#940](https://github.com/go-swagger/go-swagger/issues/940)
- Not able to generate proper swagger spec [\#938](https://github.com/go-swagger/go-swagger/issues/938)
- swagger:meta custom description [\#937](https://github.com/go-swagger/go-swagger/issues/937)
- Set HTTP header on the client side without an explicit swagger parameters [\#935](https://github.com/go-swagger/go-swagger/issues/935)
- Beam file not being generated. [\#930](https://github.com/go-swagger/go-swagger/issues/930)
- Need help in successfully running swagger generate commands [\#929](https://github.com/go-swagger/go-swagger/issues/929)
- How do you remove a not required date-time from your JSON output? [\#927](https://github.com/go-swagger/go-swagger/issues/927)
- Go-swagger app on Google App Engine Standard? [\#925](https://github.com/go-swagger/go-swagger/issues/925)
- Similar routing paths that differ at the leaf got dropped out  [\#918](https://github.com/go-swagger/go-swagger/issues/918)
- Embedded pointers cause errors in spec generation [\#896](https://github.com/go-swagger/go-swagger/issues/896)
- Cannot parse time formats that look like this: 2017-01-17T22:58:45 [\#873](https://github.com/go-swagger/go-swagger/issues/873)
- Allow customized client constructor while respecting defaults [\#838](https://github.com/go-swagger/go-swagger/issues/838)
- Implement ValidateNamed method to support validation errors with proper names [\#837](https://github.com/go-swagger/go-swagger/issues/837)
- Support default value for model property [\#828](https://github.com/go-swagger/go-swagger/issues/828)
- Newlines in title field breaks docstrings [\#813](https://github.com/go-swagger/go-swagger/issues/813)
- Code gen: missing import restapi/operations/\[name\]/get\_\[name\]\_parameters.go ; "github.com/go-openapi/runtime/middleware" [\#590](https://github.com/go-swagger/go-swagger/issues/590)

**Merged pull requests:**

- no x-go-name on $ref props [\#994](https://github.com/go-swagger/go-swagger/pull/994) ([casualjim](https://github.com/casualjim))
- Update response.md [\#988](https://github.com/go-swagger/go-swagger/pull/988) ([matiasanaya-ffx](https://github.com/matiasanaya-ffx))
- Allow to set build tags for scanner [\#980](https://github.com/go-swagger/go-swagger/pull/980) ([gaplyk](https://github.com/gaplyk))
- Fix links in docs/README.md [\#978](https://github.com/go-swagger/go-swagger/pull/978) ([houjunchen](https://github.com/houjunchen))
- Task: Update generate docs [\#975](https://github.com/go-swagger/go-swagger/pull/975) ([kenjones-cisco](https://github.com/kenjones-cisco))
- Bugfix: err shadows declaration [\#974](https://github.com/go-swagger/go-swagger/pull/974) ([kenjones-cisco](https://github.com/kenjones-cisco))
- Bugfix: Check error of SetTimeout [\#969](https://github.com/go-swagger/go-swagger/pull/969) ([kenjones-cisco](https://github.com/kenjones-cisco))
- Always add default imports [\#966](https://github.com/go-swagger/go-swagger/pull/966) ([kars7e](https://github.com/kars7e))
- Respect required for polymorphic types [\#964](https://github.com/go-swagger/go-swagger/pull/964) ([jbowes](https://github.com/jbowes))
- update vendored libs [\#956](https://github.com/go-swagger/go-swagger/pull/956) ([casualjim](https://github.com/casualjim))
- generator: Generate good godoc style for HTTP error codes [\#953](https://github.com/go-swagger/go-swagger/pull/953) ([tgraf](https://github.com/tgraf))
- Add  in swagger:meta, security fix. Implementation of secure definitions [\#950](https://github.com/go-swagger/go-swagger/pull/950) ([gaplyk](https://github.com/gaplyk))
- Fix package lookup. Add ast.SelectorExpr [\#945](https://github.com/go-swagger/go-swagger/pull/945) ([gaplyk](https://github.com/gaplyk))
- Updates schema scanner to print warning [\#942](https://github.com/go-swagger/go-swagger/pull/942) ([robertacosta](https://github.com/robertacosta))
- Added custom tag functionality [\#939](https://github.com/go-swagger/go-swagger/pull/939) ([johnnadratowski](https://github.com/johnnadratowski))
- Use json.RawMessage to decode polymorphic types [\#933](https://github.com/go-swagger/go-swagger/pull/933) ([kars7e](https://github.com/kars7e))
- Set the read and write timeout values for the http scheme [\#926](https://github.com/go-swagger/go-swagger/pull/926) ([jbowes](https://github.com/jbowes))
- Remove no-op basePath assignment. [\#921](https://github.com/go-swagger/go-swagger/pull/921) ([snargleplax](https://github.com/snargleplax))
- Support x-go-name in response elements [\#916](https://github.com/go-swagger/go-swagger/pull/916) ([tgraf](https://github.com/tgraf))
- Fix some typos and spelling errors I discovered while reading the docs [\#915](https://github.com/go-swagger/go-swagger/pull/915) ([flimzy](https://github.com/flimzy))
- generator: Provide const for all defined response codes [\#914](https://github.com/go-swagger/go-swagger/pull/914) ([tgraf](https://github.com/tgraf))
- fix\(generator\): always use runtime/flagext in server generation [\#913](https://github.com/go-swagger/go-swagger/pull/913) ([mitch000001](https://github.com/mitch000001))
- fixes path param scan and trailing slash router [\#906](https://github.com/go-swagger/go-swagger/pull/906) ([casualjim](https://github.com/casualjim))
- add custom server example and update examples [\#904](https://github.com/go-swagger/go-swagger/pull/904) ([GlenDC](https://github.com/GlenDC))
- remove unused resolveSimpleType func [\#903](https://github.com/go-swagger/go-swagger/pull/903) ([GlenDC](https://github.com/GlenDC))
- 886 bash zsh autocompletion [\#902](https://github.com/go-swagger/go-swagger/pull/902) ([GlenDC](https://github.com/GlenDC))
- add custom server tutorial [\#900](https://github.com/go-swagger/go-swagger/pull/900) ([GlenDC](https://github.com/GlenDC))
- Fixes \#896 - Added \*ast.StarExpr to parsers [\#897](https://github.com/go-swagger/go-swagger/pull/897) ([bjyoungblood](https://github.com/bjyoungblood))
- Allow CodeGen to skip formatting [\#895](https://github.com/go-swagger/go-swagger/pull/895) ([steve-gray](https://github.com/steve-gray))
- fix sliceserverheaderbuilder's broken ValueExpression selector [\#885](https://github.com/go-swagger/go-swagger/pull/885) ([GlenDC](https://github.com/GlenDC))
- Remove unnecessary ToUpper from builder template [\#882](https://github.com/go-swagger/go-swagger/pull/882) ([posener](https://github.com/posener))
- make sure docs and its inline example match [\#880](https://github.com/go-swagger/go-swagger/pull/880) ([GlenDC](https://github.com/GlenDC))
- Fix some grammar [\#878](https://github.com/go-swagger/go-swagger/pull/878) ([PaulCapestany](https://github.com/PaulCapestany))
- generate root path as empty string in server router [\#871](https://github.com/go-swagger/go-swagger/pull/871) ([GlenDC](https://github.com/GlenDC))
- Add default imports in templates [\#867](https://github.com/go-swagger/go-swagger/pull/867) ([JrCs](https://github.com/JrCs))
- fix for broken link in todo-list tutorial [\#857](https://github.com/go-swagger/go-swagger/pull/857) ([nathany](https://github.com/nathany))
- Generate code that keeps swagger spec as a string instead of a \[\]byte [\#856](https://github.com/go-swagger/go-swagger/pull/856) ([vburenin](https://github.com/vburenin))
- fix typo in server/builder.gotmpl [\#855](https://github.com/go-swagger/go-swagger/pull/855) ([GlenDC](https://github.com/GlenDC))
- fix \#847 [\#851](https://github.com/go-swagger/go-swagger/pull/851) ([Simon-Li](https://github.com/Simon-Li))
- ensure constant client response body order [\#848](https://github.com/go-swagger/go-swagger/pull/848) ([GlenDC](https://github.com/GlenDC))
- generator: strip package name from type name [\#845](https://github.com/go-swagger/go-swagger/pull/845) ([rjeczalik](https://github.com/rjeczalik))
- expose transport config, fixes \#838 [\#843](https://github.com/go-swagger/go-swagger/pull/843) ([GlenDC](https://github.com/GlenDC))
- 837-support-validation-error-with-proper-name [\#840](https://github.com/go-swagger/go-swagger/pull/840) ([Simon-Li](https://github.com/Simon-Li))
- Fix a number of bugs [\#832](https://github.com/go-swagger/go-swagger/pull/832) ([casualjim](https://github.com/casualjim))
- 828-Support-default-value-for-model-property [\#829](https://github.com/go-swagger/go-swagger/pull/829) ([Simon-Li](https://github.com/Simon-Li))
- Fix issue [\#826](https://github.com/go-swagger/go-swagger/pull/826) ([gaplyk](https://github.com/gaplyk))
- allow for gopath to be differently cased from actual [\#821](https://github.com/go-swagger/go-swagger/pull/821) ([casualjim](https://github.com/casualjim))
- local file refs for params and responses in server gen [\#820](https://github.com/go-swagger/go-swagger/pull/820) ([casualjim](https://github.com/casualjim))
- validate respects local file reference [\#819](https://github.com/go-swagger/go-swagger/pull/819) ([casualjim](https://github.com/casualjim))
- improve defaults API constructor, fixes \#810 [\#816](https://github.com/go-swagger/go-swagger/pull/816) ([GlenDC](https://github.com/GlenDC))
- add operation annotation [\#815](https://github.com/go-swagger/go-swagger/pull/815) ([GlenDC](https://github.com/GlenDC))
- Apply comment function to title in docstring template [\#814](https://github.com/go-swagger/go-swagger/pull/814) ([lstoll](https://github.com/lstoll))
- Use existing Go type instead of generated one \(fix \#778\) [\#812](https://github.com/go-swagger/go-swagger/pull/812) ([nikolay-turpitko](https://github.com/nikolay-turpitko))

\* *This Change Log was automatically generated by [github_changelog_generator](https://github.com/skywinder/Github-Changelog-Generator)*
