// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Definitions for Elliptic Curve Digital Signature Algorithm (ECDSA).

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.11.4
// source: third_party/tink/proto/ecies_aead_hkdf.proto

package ecies_aead_hkdf_go_proto

import (
	common_go_proto "github.com/google/tink/go/proto/common_go_proto"
	tink_go_proto "github.com/google/tink/go/proto/tink_go_proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Parameters of KEM (Key Encapsulation Mechanism)
type EciesHkdfKemParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	CurveType common_go_proto.EllipticCurveType `protobuf:"varint,1,opt,name=curve_type,json=curveType,proto3,enum=google.crypto.tink.EllipticCurveType" json:"curve_type,omitempty"`
	// Required.
	HkdfHashType common_go_proto.HashType `protobuf:"varint,2,opt,name=hkdf_hash_type,json=hkdfHashType,proto3,enum=google.crypto.tink.HashType" json:"hkdf_hash_type,omitempty"`
	// Optional.
	HkdfSalt []byte `protobuf:"bytes,11,opt,name=hkdf_salt,json=hkdfSalt,proto3" json:"hkdf_salt,omitempty"`
}

func (x *EciesHkdfKemParams) Reset() {
	*x = EciesHkdfKemParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EciesHkdfKemParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EciesHkdfKemParams) ProtoMessage() {}

func (x *EciesHkdfKemParams) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EciesHkdfKemParams.ProtoReflect.Descriptor instead.
func (*EciesHkdfKemParams) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_ecies_aead_hkdf_proto_rawDescGZIP(), []int{0}
}

func (x *EciesHkdfKemParams) GetCurveType() common_go_proto.EllipticCurveType {
	if x != nil {
		return x.CurveType
	}
	return common_go_proto.EllipticCurveType(0)
}

func (x *EciesHkdfKemParams) GetHkdfHashType() common_go_proto.HashType {
	if x != nil {
		return x.HkdfHashType
	}
	return common_go_proto.HashType(0)
}

func (x *EciesHkdfKemParams) GetHkdfSalt() []byte {
	if x != nil {
		return x.HkdfSalt
	}
	return nil
}

// Parameters of AEAD DEM (Data Encapsulation Mechanism).
type EciesAeadDemParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	// Contains an Aead or DeterministicAead key format (e.g:
	// AesCtrHmacAeadKeyFormat, AesGcmKeyFormat or AesSivKeyFormat).
	AeadDem *tink_go_proto.KeyTemplate `protobuf:"bytes,2,opt,name=aead_dem,json=aeadDem,proto3" json:"aead_dem,omitempty"`
}

func (x *EciesAeadDemParams) Reset() {
	*x = EciesAeadDemParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EciesAeadDemParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EciesAeadDemParams) ProtoMessage() {}

func (x *EciesAeadDemParams) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EciesAeadDemParams.ProtoReflect.Descriptor instead.
func (*EciesAeadDemParams) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_ecies_aead_hkdf_proto_rawDescGZIP(), []int{1}
}

func (x *EciesAeadDemParams) GetAeadDem() *tink_go_proto.KeyTemplate {
	if x != nil {
		return x.AeadDem
	}
	return nil
}

type EciesAeadHkdfParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key Encapsulation Mechanism.
	// Required.
	KemParams *EciesHkdfKemParams `protobuf:"bytes,1,opt,name=kem_params,json=kemParams,proto3" json:"kem_params,omitempty"`
	// Data Encapsulation Mechanism.
	// Required.
	DemParams *EciesAeadDemParams `protobuf:"bytes,2,opt,name=dem_params,json=demParams,proto3" json:"dem_params,omitempty"`
	// EC point format.
	// Required.
	EcPointFormat common_go_proto.EcPointFormat `protobuf:"varint,3,opt,name=ec_point_format,json=ecPointFormat,proto3,enum=google.crypto.tink.EcPointFormat" json:"ec_point_format,omitempty"`
}

func (x *EciesAeadHkdfParams) Reset() {
	*x = EciesAeadHkdfParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EciesAeadHkdfParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EciesAeadHkdfParams) ProtoMessage() {}

func (x *EciesAeadHkdfParams) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EciesAeadHkdfParams.ProtoReflect.Descriptor instead.
func (*EciesAeadHkdfParams) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_ecies_aead_hkdf_proto_rawDescGZIP(), []int{2}
}

func (x *EciesAeadHkdfParams) GetKemParams() *EciesHkdfKemParams {
	if x != nil {
		return x.KemParams
	}
	return nil
}

func (x *EciesAeadHkdfParams) GetDemParams() *EciesAeadDemParams {
	if x != nil {
		return x.DemParams
	}
	return nil
}

func (x *EciesAeadHkdfParams) GetEcPointFormat() common_go_proto.EcPointFormat {
	if x != nil {
		return x.EcPointFormat
	}
	return common_go_proto.EcPointFormat(0)
}

// EciesAeadHkdfPublicKey represents HybridEncryption primitive.
// key_type: type.googleapis.com/google.crypto.tink.EciesAeadHkdfPublicKey
type EciesAeadHkdfPublicKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	Params *EciesAeadHkdfParams `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	// Affine coordinates of the public key in bigendian representation.
	// The public key is a point (x, y) on the curve defined by
	// params.kem_params.curve. Required.
	X []byte `protobuf:"bytes,3,opt,name=x,proto3" json:"x,omitempty"`
	// Required.
	Y []byte `protobuf:"bytes,4,opt,name=y,proto3" json:"y,omitempty"`
}

func (x *EciesAeadHkdfPublicKey) Reset() {
	*x = EciesAeadHkdfPublicKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EciesAeadHkdfPublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EciesAeadHkdfPublicKey) ProtoMessage() {}

func (x *EciesAeadHkdfPublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EciesAeadHkdfPublicKey.ProtoReflect.Descriptor instead.
func (*EciesAeadHkdfPublicKey) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_ecies_aead_hkdf_proto_rawDescGZIP(), []int{3}
}

func (x *EciesAeadHkdfPublicKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *EciesAeadHkdfPublicKey) GetParams() *EciesAeadHkdfParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *EciesAeadHkdfPublicKey) GetX() []byte {
	if x != nil {
		return x.X
	}
	return nil
}

func (x *EciesAeadHkdfPublicKey) GetY() []byte {
	if x != nil {
		return x.Y
	}
	return nil
}

// EciesKdfAeadPrivateKey represents HybridDecryption primitive.
// key_type: type.googleapis.com/google.crypto.tink.EciesAeadHkdfPrivateKey
type EciesAeadHkdfPrivateKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	PublicKey *EciesAeadHkdfPublicKey `protobuf:"bytes,2,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Required.
	KeyValue []byte `protobuf:"bytes,3,opt,name=key_value,json=keyValue,proto3" json:"key_value,omitempty"` // Big integer in bigendian representation.
}

func (x *EciesAeadHkdfPrivateKey) Reset() {
	*x = EciesAeadHkdfPrivateKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EciesAeadHkdfPrivateKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EciesAeadHkdfPrivateKey) ProtoMessage() {}

func (x *EciesAeadHkdfPrivateKey) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EciesAeadHkdfPrivateKey.ProtoReflect.Descriptor instead.
func (*EciesAeadHkdfPrivateKey) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_ecies_aead_hkdf_proto_rawDescGZIP(), []int{4}
}

func (x *EciesAeadHkdfPrivateKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *EciesAeadHkdfPrivateKey) GetPublicKey() *EciesAeadHkdfPublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

func (x *EciesAeadHkdfPrivateKey) GetKeyValue() []byte {
	if x != nil {
		return x.KeyValue
	}
	return nil
}

type EciesAeadHkdfKeyFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	Params *EciesAeadHkdfParams `protobuf:"bytes,1,opt,name=params,proto3" json:"params,omitempty"`
}

func (x *EciesAeadHkdfKeyFormat) Reset() {
	*x = EciesAeadHkdfKeyFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EciesAeadHkdfKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EciesAeadHkdfKeyFormat) ProtoMessage() {}

func (x *EciesAeadHkdfKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EciesAeadHkdfKeyFormat.ProtoReflect.Descriptor instead.
func (*EciesAeadHkdfKeyFormat) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_ecies_aead_hkdf_proto_rawDescGZIP(), []int{5}
}

func (x *EciesAeadHkdfKeyFormat) GetParams() *EciesAeadHkdfParams {
	if x != nil {
		return x.Params
	}
	return nil
}

var File_third_party_tink_proto_ecies_aead_hkdf_proto protoreflect.FileDescriptor

var file_third_party_tink_proto_ecies_aead_hkdf_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x2f, 0x74, 0x69,
	0x6e, 0x6b, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x65, 0x63, 0x69, 0x65, 0x73, 0x5f, 0x61,
	0x65, 0x61, 0x64, 0x5f, 0x68, 0x6b, 0x64, 0x66, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69,
	0x6e, 0x6b, 0x1a, 0x23, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x2f,
	0x74, 0x69, 0x6e, 0x6b, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70,
	0x61, 0x72, 0x74, 0x79, 0x2f, 0x74, 0x69, 0x6e, 0x6b, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbb, 0x01, 0x0a, 0x12, 0x45,
	0x63, 0x69, 0x65, 0x73, 0x48, 0x6b, 0x64, 0x66, 0x4b, 0x65, 0x6d, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x12, 0x44, 0x0a, 0x0a, 0x63, 0x75, 0x72, 0x76, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x45, 0x6c, 0x6c, 0x69, 0x70,
	0x74, 0x69, 0x63, 0x43, 0x75, 0x72, 0x76, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x63, 0x75,
	0x72, 0x76, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x42, 0x0a, 0x0e, 0x68, 0x6b, 0x64, 0x66, 0x5f,
	0x68, 0x61, 0x73, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e,
	0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x68,
	0x6b, 0x64, 0x66, 0x48, 0x61, 0x73, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x68,
	0x6b, 0x64, 0x66, 0x5f, 0x73, 0x61, 0x6c, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08,
	0x68, 0x6b, 0x64, 0x66, 0x53, 0x61, 0x6c, 0x74, 0x22, 0x50, 0x0a, 0x12, 0x45, 0x63, 0x69, 0x65,
	0x73, 0x41, 0x65, 0x61, 0x64, 0x44, 0x65, 0x6d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x3a,
	0x0a, 0x08, 0x61, 0x65, 0x61, 0x64, 0x5f, 0x64, 0x65, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x4b, 0x65, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x52, 0x07, 0x61, 0x65, 0x61, 0x64, 0x44, 0x65, 0x6d, 0x22, 0xee, 0x01, 0x0a, 0x13, 0x45,
	0x63, 0x69, 0x65, 0x73, 0x41, 0x65, 0x61, 0x64, 0x48, 0x6b, 0x64, 0x66, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x12, 0x45, 0x0a, 0x0a, 0x6b, 0x65, 0x6d, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x45, 0x63, 0x69, 0x65,
	0x73, 0x48, 0x6b, 0x64, 0x66, 0x4b, 0x65, 0x6d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x09,
	0x6b, 0x65, 0x6d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x45, 0x0a, 0x0a, 0x64, 0x65, 0x6d,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69,
	0x6e, 0x6b, 0x2e, 0x45, 0x63, 0x69, 0x65, 0x73, 0x41, 0x65, 0x61, 0x64, 0x44, 0x65, 0x6d, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x09, 0x64, 0x65, 0x6d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x12, 0x49, 0x0a, 0x0f, 0x65, 0x63, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x45,
	0x63, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x0d, 0x65, 0x63,
	0x50, 0x6f, 0x69, 0x6e, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x8f, 0x01, 0x0a, 0x16,
	0x45, 0x63, 0x69, 0x65, 0x73, 0x41, 0x65, 0x61, 0x64, 0x48, 0x6b, 0x64, 0x66, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x45, 0x63, 0x69, 0x65, 0x73, 0x41, 0x65, 0x61, 0x64, 0x48,
	0x6b, 0x64, 0x66, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x12, 0x0c, 0x0a, 0x01, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x01, 0x78, 0x12,
	0x0c, 0x0a, 0x01, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x01, 0x79, 0x22, 0x9b, 0x01,
	0x0a, 0x17, 0x45, 0x63, 0x69, 0x65, 0x73, 0x41, 0x65, 0x61, 0x64, 0x48, 0x6b, 0x64, 0x66, 0x50,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x45, 0x63, 0x69,
	0x65, 0x73, 0x41, 0x65, 0x61, 0x64, 0x48, 0x6b, 0x64, 0x66, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x4b, 0x65, 0x79, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x1b,
	0x0a, 0x09, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x59, 0x0a, 0x16, 0x45,
	0x63, 0x69, 0x65, 0x73, 0x41, 0x65, 0x61, 0x64, 0x48, 0x6b, 0x64, 0x66, 0x4b, 0x65, 0x79, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x45, 0x63, 0x69, 0x65, 0x73,
	0x41, 0x65, 0x61, 0x64, 0x48, 0x6b, 0x64, 0x66, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x42, 0x57, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x35, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x69, 0x6e, 0x6b,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x65, 0x63, 0x69, 0x65, 0x73, 0x5f, 0x61, 0x65, 0x61,
	0x64, 0x5f, 0x68, 0x6b, 0x64, 0x66, 0x5f, 0x67, 0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_third_party_tink_proto_ecies_aead_hkdf_proto_rawDescOnce sync.Once
	file_third_party_tink_proto_ecies_aead_hkdf_proto_rawDescData = file_third_party_tink_proto_ecies_aead_hkdf_proto_rawDesc
)

func file_third_party_tink_proto_ecies_aead_hkdf_proto_rawDescGZIP() []byte {
	file_third_party_tink_proto_ecies_aead_hkdf_proto_rawDescOnce.Do(func() {
		file_third_party_tink_proto_ecies_aead_hkdf_proto_rawDescData = protoimpl.X.CompressGZIP(file_third_party_tink_proto_ecies_aead_hkdf_proto_rawDescData)
	})
	return file_third_party_tink_proto_ecies_aead_hkdf_proto_rawDescData
}

var file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_third_party_tink_proto_ecies_aead_hkdf_proto_goTypes = []interface{}{
	(*EciesHkdfKemParams)(nil),             // 0: google.crypto.tink.EciesHkdfKemParams
	(*EciesAeadDemParams)(nil),             // 1: google.crypto.tink.EciesAeadDemParams
	(*EciesAeadHkdfParams)(nil),            // 2: google.crypto.tink.EciesAeadHkdfParams
	(*EciesAeadHkdfPublicKey)(nil),         // 3: google.crypto.tink.EciesAeadHkdfPublicKey
	(*EciesAeadHkdfPrivateKey)(nil),        // 4: google.crypto.tink.EciesAeadHkdfPrivateKey
	(*EciesAeadHkdfKeyFormat)(nil),         // 5: google.crypto.tink.EciesAeadHkdfKeyFormat
	(common_go_proto.EllipticCurveType)(0), // 6: google.crypto.tink.EllipticCurveType
	(common_go_proto.HashType)(0),          // 7: google.crypto.tink.HashType
	(*tink_go_proto.KeyTemplate)(nil),      // 8: google.crypto.tink.KeyTemplate
	(common_go_proto.EcPointFormat)(0),     // 9: google.crypto.tink.EcPointFormat
}
var file_third_party_tink_proto_ecies_aead_hkdf_proto_depIdxs = []int32{
	6, // 0: google.crypto.tink.EciesHkdfKemParams.curve_type:type_name -> google.crypto.tink.EllipticCurveType
	7, // 1: google.crypto.tink.EciesHkdfKemParams.hkdf_hash_type:type_name -> google.crypto.tink.HashType
	8, // 2: google.crypto.tink.EciesAeadDemParams.aead_dem:type_name -> google.crypto.tink.KeyTemplate
	0, // 3: google.crypto.tink.EciesAeadHkdfParams.kem_params:type_name -> google.crypto.tink.EciesHkdfKemParams
	1, // 4: google.crypto.tink.EciesAeadHkdfParams.dem_params:type_name -> google.crypto.tink.EciesAeadDemParams
	9, // 5: google.crypto.tink.EciesAeadHkdfParams.ec_point_format:type_name -> google.crypto.tink.EcPointFormat
	2, // 6: google.crypto.tink.EciesAeadHkdfPublicKey.params:type_name -> google.crypto.tink.EciesAeadHkdfParams
	3, // 7: google.crypto.tink.EciesAeadHkdfPrivateKey.public_key:type_name -> google.crypto.tink.EciesAeadHkdfPublicKey
	2, // 8: google.crypto.tink.EciesAeadHkdfKeyFormat.params:type_name -> google.crypto.tink.EciesAeadHkdfParams
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_third_party_tink_proto_ecies_aead_hkdf_proto_init() }
func file_third_party_tink_proto_ecies_aead_hkdf_proto_init() {
	if File_third_party_tink_proto_ecies_aead_hkdf_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EciesHkdfKemParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EciesAeadDemParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EciesAeadHkdfParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EciesAeadHkdfPublicKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EciesAeadHkdfPrivateKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EciesAeadHkdfKeyFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_third_party_tink_proto_ecies_aead_hkdf_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_third_party_tink_proto_ecies_aead_hkdf_proto_goTypes,
		DependencyIndexes: file_third_party_tink_proto_ecies_aead_hkdf_proto_depIdxs,
		MessageInfos:      file_third_party_tink_proto_ecies_aead_hkdf_proto_msgTypes,
	}.Build()
	File_third_party_tink_proto_ecies_aead_hkdf_proto = out.File
	file_third_party_tink_proto_ecies_aead_hkdf_proto_rawDesc = nil
	file_third_party_tink_proto_ecies_aead_hkdf_proto_goTypes = nil
	file_third_party_tink_proto_ecies_aead_hkdf_proto_depIdxs = nil
}
