// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudPacker20220411ChannelIterationPointer A Channel Pointer is a special object that tracks channel
// history by storing both which iteration the channel points to and also when
// the channel was updated to point at said iteration.
// Deprecated: The iteration object is directly embed to Channel.
//
// swagger:model hashicorp.cloud.packer_20220411.ChannelIterationPointer
type HashicorpCloudPacker20220411ChannelIterationPointer struct {

	// The user who pointed the channel to the iteration.
	AuthorID string `json:"author_id,omitempty"`

	// When the channel pointer was created.
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// The iteration the channel is pointing to.
	Iteration *HashicorpCloudPacker20220411Iteration `json:"iteration,omitempty"`
}

// Validate validates this hashicorp cloud packer 20220411 channel iteration pointer
func (m *HashicorpCloudPacker20220411ChannelIterationPointer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIteration(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudPacker20220411ChannelIterationPointer) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudPacker20220411ChannelIterationPointer) validateIteration(formats strfmt.Registry) error {
	if swag.IsZero(m.Iteration) { // not required
		return nil
	}

	if m.Iteration != nil {
		if err := m.Iteration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iteration")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("iteration")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud packer 20220411 channel iteration pointer based on the context it is used
func (m *HashicorpCloudPacker20220411ChannelIterationPointer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIteration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudPacker20220411ChannelIterationPointer) contextValidateIteration(ctx context.Context, formats strfmt.Registry) error {

	if m.Iteration != nil {
		if err := m.Iteration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iteration")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("iteration")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudPacker20220411ChannelIterationPointer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudPacker20220411ChannelIterationPointer) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudPacker20220411ChannelIterationPointer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
