// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudPacker20220411UpdateRegistryRequest hashicorp cloud packer 20220411 update registry request
//
// swagger:model hashicorp.cloud.packer_20220411.UpdateRegistryRequest
type HashicorpCloudPacker20220411UpdateRegistryRequest struct {

	// Activates a deactivated registry. A registry can only be activated
	// if the organization billing account is valid (e.g. valid credits or payment method).
	Activate bool `json:"activate,omitempty"`

	// Feature tier of the Registry.
	FeatureTier *HashicorpCloudPacker20220411RegistryConfigTier `json:"feature_tier,omitempty"`

	// location
	Location *cloud.HashicorpCloudLocationLocation `json:"location,omitempty"`
}

// Validate validates this hashicorp cloud packer 20220411 update registry request
func (m *HashicorpCloudPacker20220411UpdateRegistryRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFeatureTier(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudPacker20220411UpdateRegistryRequest) validateFeatureTier(formats strfmt.Registry) error {
	if swag.IsZero(m.FeatureTier) { // not required
		return nil
	}

	if m.FeatureTier != nil {
		if err := m.FeatureTier.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("feature_tier")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("feature_tier")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20220411UpdateRegistryRequest) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud packer 20220411 update registry request based on the context it is used
func (m *HashicorpCloudPacker20220411UpdateRegistryRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFeatureTier(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudPacker20220411UpdateRegistryRequest) contextValidateFeatureTier(ctx context.Context, formats strfmt.Registry) error {

	if m.FeatureTier != nil {
		if err := m.FeatureTier.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("feature_tier")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("feature_tier")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20220411UpdateRegistryRequest) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {
		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudPacker20220411UpdateRegistryRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudPacker20220411UpdateRegistryRequest) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudPacker20220411UpdateRegistryRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
