// Code generated by go-swagger; DO NOT EDIT.

package provider_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListProvidersParams creates a new ListProvidersParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListProvidersParams() *ListProvidersParams {
	return &ListProvidersParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListProvidersParamsWithTimeout creates a new ListProvidersParams object
// with the ability to set a timeout on a request.
func NewListProvidersParamsWithTimeout(timeout time.Duration) *ListProvidersParams {
	return &ListProvidersParams{
		timeout: timeout,
	}
}

// NewListProvidersParamsWithContext creates a new ListProvidersParams object
// with the ability to set a context for a request.
func NewListProvidersParamsWithContext(ctx context.Context) *ListProvidersParams {
	return &ListProvidersParams{
		Context: ctx,
	}
}

// NewListProvidersParamsWithHTTPClient creates a new ListProvidersParams object
// with the ability to set a custom HTTPClient for a request.
func NewListProvidersParamsWithHTTPClient(client *http.Client) *ListProvidersParams {
	return &ListProvidersParams{
		HTTPClient: client,
	}
}

/*
ListProvidersParams contains all the parameters to send to the API endpoint

	for the list providers operation.

	Typically these are written to a http.Request.
*/
type ListProvidersParams struct {

	/* Box.

	     The name segment of the Box. As an example, this field would represent the
	"vagrant" in "hashicorp/vagrant".
	*/
	Box string

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The max number of results per page that should be returned. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned which can be used to get the next page of results in subsequent
	requests. A value of zero will cause `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	/* Registry.

	     The Registry segment of the Box. As an example, this field would represent
	the "hashicorp" in "hashicorp/vagrant".
	*/
	Registry string

	/* Version.

	   The name of the Version to look up Providers in.
	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list providers params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListProvidersParams) WithDefaults() *ListProvidersParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list providers params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListProvidersParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list providers params
func (o *ListProvidersParams) WithTimeout(timeout time.Duration) *ListProvidersParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list providers params
func (o *ListProvidersParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list providers params
func (o *ListProvidersParams) WithContext(ctx context.Context) *ListProvidersParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list providers params
func (o *ListProvidersParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list providers params
func (o *ListProvidersParams) WithHTTPClient(client *http.Client) *ListProvidersParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list providers params
func (o *ListProvidersParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBox adds the box to the list providers params
func (o *ListProvidersParams) WithBox(box string) *ListProvidersParams {
	o.SetBox(box)
	return o
}

// SetBox adds the box to the list providers params
func (o *ListProvidersParams) SetBox(box string) {
	o.Box = box
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the list providers params
func (o *ListProvidersParams) WithPaginationNextPageToken(paginationNextPageToken *string) *ListProvidersParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the list providers params
func (o *ListProvidersParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the list providers params
func (o *ListProvidersParams) WithPaginationPageSize(paginationPageSize *int64) *ListProvidersParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the list providers params
func (o *ListProvidersParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the list providers params
func (o *ListProvidersParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *ListProvidersParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the list providers params
func (o *ListProvidersParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithRegistry adds the registry to the list providers params
func (o *ListProvidersParams) WithRegistry(registry string) *ListProvidersParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the list providers params
func (o *ListProvidersParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WithVersion adds the version to the list providers params
func (o *ListProvidersParams) WithVersion(version string) *ListProvidersParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the list providers params
func (o *ListProvidersParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *ListProvidersParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param box
	if err := r.SetPathParam("box", o.Box); err != nil {
		return err
	}

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", o.Version); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
