// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// MarketplacePublisherService API
//
// Use the Marketplace Publisher API to manage the publishing of applications in Oracle Cloud Infrastructure Marketplace.
//

package marketplacepublisher

import (
	"context"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"github.com/oracle/oci-go-sdk/v65/common/auth"
	"net/http"
)

// OfferClient a client for Offer
type OfferClient struct {
	common.BaseClient
	config *common.ConfigurationProvider
}

// NewOfferClientWithConfigurationProvider Creates a new default Offer client with the given configuration provider.
// the configuration provider will be used for the default signer as well as reading the region
func NewOfferClientWithConfigurationProvider(configProvider common.ConfigurationProvider) (client OfferClient, err error) {
	if enabled := common.CheckForEnabledServices("marketplacepublisher"); !enabled {
		return client, fmt.Errorf("the Developer Tool configuration disabled this service, this behavior is controlled by OciSdkEnabledServicesMap variables. Please check if your local developer-tool-configuration.json file configured the service you're targeting or contact the cloud provider on the availability of this service")
	}
	provider, err := auth.GetGenericConfigurationProvider(configProvider)
	if err != nil {
		return client, err
	}
	baseClient, e := common.NewClientWithConfig(provider)
	if e != nil {
		return client, e
	}
	return newOfferClientFromBaseClient(baseClient, provider)
}

// NewOfferClientWithOboToken Creates a new default Offer client with the given configuration provider.
// The obotoken will be added to default headers and signed; the configuration provider will be used for the signer
//
//	as well as reading the region
func NewOfferClientWithOboToken(configProvider common.ConfigurationProvider, oboToken string) (client OfferClient, err error) {
	baseClient, err := common.NewClientWithOboToken(configProvider, oboToken)
	if err != nil {
		return client, err
	}

	return newOfferClientFromBaseClient(baseClient, configProvider)
}

func newOfferClientFromBaseClient(baseClient common.BaseClient, configProvider common.ConfigurationProvider) (client OfferClient, err error) {
	// Offer service default circuit breaker is enabled
	baseClient.Configuration.CircuitBreaker = common.NewCircuitBreaker(common.DefaultCircuitBreakerSettingWithServiceName("Offer"))
	common.ConfigCircuitBreakerFromEnvVar(&baseClient)
	common.ConfigCircuitBreakerFromGlobalVar(&baseClient)

	client = OfferClient{BaseClient: baseClient}
	client.BasePath = "20220901"
	err = client.setConfigurationProvider(configProvider)
	return
}

// SetRegion overrides the region of this client.
func (client *OfferClient) SetRegion(region string) {
	client.Host = common.StringToRegion(region).EndpointForTemplate("marketplacepublisher", "https://marketplace-publisher.{region}.oci.{secondLevelDomain}")
}

// SetConfigurationProvider sets the configuration provider including the region, returns an error if is not valid
func (client *OfferClient) setConfigurationProvider(configProvider common.ConfigurationProvider) error {
	if ok, err := common.IsConfigurationProviderValid(configProvider); !ok {
		return err
	}

	// Error has been checked already
	region, _ := configProvider.Region()
	client.SetRegion(region)
	if client.Host == "" {
		return fmt.Errorf("invalid region or Host. Endpoint cannot be constructed without endpointServiceName or serviceEndpointTemplate for a dotted region")
	}
	client.config = &configProvider
	return nil
}

// ConfigurationProvider the ConfigurationProvider used in this client, or null if none set
func (client *OfferClient) ConfigurationProvider() *common.ConfigurationProvider {
	return client.config
}

// CreateOffer Creates a new Offer.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/marketplacepublisher/CreateOffer.go.html to see an example of how to use CreateOffer API.
// A default retry strategy applies to this operation CreateOffer()
func (client OfferClient) CreateOffer(ctx context.Context, request CreateOfferRequest) (response CreateOfferResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.DefaultRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}

	if !(request.OpcRetryToken != nil && *request.OpcRetryToken != "") {
		request.OpcRetryToken = common.String(common.RetryToken())
	}

	ociResponse, err = common.Retry(ctx, request, client.createOffer, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = CreateOfferResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = CreateOfferResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(CreateOfferResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into CreateOfferResponse")
	}
	return
}

// createOffer implements the OCIOperation interface (enables retrying operations)
func (client OfferClient) createOffer(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPost, "/offers", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response CreateOfferResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/publisher/20220901/Offer/CreateOffer"
		err = common.PostProcessServiceError(err, "Offer", "CreateOffer", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// DeleteOffer Deletes an Offer resource by identifier
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/marketplacepublisher/DeleteOffer.go.html to see an example of how to use DeleteOffer API.
// A default retry strategy applies to this operation DeleteOffer()
func (client OfferClient) DeleteOffer(ctx context.Context, request DeleteOfferRequest) (response DeleteOfferResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.DefaultRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.deleteOffer, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = DeleteOfferResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = DeleteOfferResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(DeleteOfferResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into DeleteOfferResponse")
	}
	return
}

// deleteOffer implements the OCIOperation interface (enables retrying operations)
func (client OfferClient) deleteOffer(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodDelete, "/offers/{offerId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response DeleteOfferResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/publisher/20220901/Offer/DeleteOffer"
		err = common.PostProcessServiceError(err, "Offer", "DeleteOffer", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// GetOffer Gets an Offer by identifier
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/marketplacepublisher/GetOffer.go.html to see an example of how to use GetOffer API.
// A default retry strategy applies to this operation GetOffer()
func (client OfferClient) GetOffer(ctx context.Context, request GetOfferRequest) (response GetOfferResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.DefaultRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.getOffer, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = GetOfferResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = GetOfferResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(GetOfferResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into GetOfferResponse")
	}
	return
}

// getOffer implements the OCIOperation interface (enables retrying operations)
func (client OfferClient) getOffer(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/offers/{offerId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response GetOfferResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/publisher/20220901/Offer/GetOffer"
		err = common.PostProcessServiceError(err, "Offer", "GetOffer", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// GetOfferInternalDetail Gets an Offer internal details by identifier
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/marketplacepublisher/GetOfferInternalDetail.go.html to see an example of how to use GetOfferInternalDetail API.
// A default retry strategy applies to this operation GetOfferInternalDetail()
func (client OfferClient) GetOfferInternalDetail(ctx context.Context, request GetOfferInternalDetailRequest) (response GetOfferInternalDetailResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.DefaultRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.getOfferInternalDetail, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = GetOfferInternalDetailResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = GetOfferInternalDetailResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(GetOfferInternalDetailResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into GetOfferInternalDetailResponse")
	}
	return
}

// getOfferInternalDetail implements the OCIOperation interface (enables retrying operations)
func (client OfferClient) getOfferInternalDetail(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/offers/{offerId}/internalDetails", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response GetOfferInternalDetailResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/publisher/20220901/Offer/GetOfferInternalDetail"
		err = common.PostProcessServiceError(err, "Offer", "GetOfferInternalDetail", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListOffers Returns a list of Offers. Requires either the BuyerCompartmentId or the SellerCompartmentId params. If neither or both are provided, then the API will return a 400.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/marketplacepublisher/ListOffers.go.html to see an example of how to use ListOffers API.
// A default retry strategy applies to this operation ListOffers()
func (client OfferClient) ListOffers(ctx context.Context, request ListOffersRequest) (response ListOffersResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.DefaultRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listOffers, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListOffersResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListOffersResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListOffersResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListOffersResponse")
	}
	return
}

// listOffers implements the OCIOperation interface (enables retrying operations)
func (client OfferClient) listOffers(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/offers", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListOffersResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/publisher/20220901/OfferCollection/ListOffers"
		err = common.PostProcessServiceError(err, "Offer", "ListOffers", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// UpdateOffer Updates the Offer
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/marketplacepublisher/UpdateOffer.go.html to see an example of how to use UpdateOffer API.
// A default retry strategy applies to this operation UpdateOffer()
func (client OfferClient) UpdateOffer(ctx context.Context, request UpdateOfferRequest) (response UpdateOfferResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.DefaultRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.updateOffer, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = UpdateOfferResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = UpdateOfferResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(UpdateOfferResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into UpdateOfferResponse")
	}
	return
}

// updateOffer implements the OCIOperation interface (enables retrying operations)
func (client OfferClient) updateOffer(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPut, "/offers/{offerId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response UpdateOfferResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/publisher/20220901/Offer/UpdateOffer"
		err = common.PostProcessServiceError(err, "Offer", "UpdateOffer", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}
