/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.artifacts.dependencies.ProjectDependencyInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.TaskDependencyContainerInternal;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.util.Path;

class TasksFromProjectDependencies
implements TaskDependencyContainerInternal {
    private final TaskDependencyContainerInternal taskDependencyDelegate;

    public TasksFromProjectDependencies(String taskName, Supplier<Set<ProjectDependency>> projectDependencies, TaskDependencyFactory taskDependencyFactory, ProjectStateRegistry projectStateRegistry) {
        this.taskDependencyDelegate = taskDependencyFactory.visitingDependencies(context -> TasksFromProjectDependencies.resolveProjectDependencies(context, (Set)projectDependencies.get(), projectStateRegistry, taskName));
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        this.taskDependencyDelegate.visitDependencies(context);
    }

    private static void resolveProjectDependencies(TaskDependencyResolveContext context, Set<ProjectDependency> projectDependencies, ProjectStateRegistry projectStateRegistry, String taskName) {
        for (ProjectDependency projectDependency : projectDependencies) {
            Path identityPath = ((ProjectDependencyInternal)projectDependency).getIdentityPath();
            ProjectState projectState = projectStateRegistry.stateFor(identityPath);
            projectState.ensureTasksDiscovered();
            Task nextTask = (Task)projectState.getMutableModel().getTasks().findByName(taskName);
            if (nextTask == null || context.getTask() == nextTask) continue;
            context.add((Object)nextTask);
        }
    }

    public Set<? extends Task> getDependencies(@Nullable Task task) {
        return this.taskDependencyDelegate.getDependencies(task);
    }

    public Set<? extends Task> getDependenciesForInternalUse(@Nullable Task task) {
        return this.taskDependencyDelegate.getDependenciesForInternalUse(task);
    }
}

