/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.writer;

import jd.core.loader.Loader;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.constant.ConstantDouble;
import jd.core.model.classfile.constant.ConstantFloat;
import jd.core.model.classfile.constant.ConstantInteger;
import jd.core.model.classfile.constant.ConstantLong;
import jd.core.model.classfile.constant.ConstantString;
import jd.core.model.classfile.constant.ConstantValue;
import jd.core.model.reference.ReferenceMap;
import jd.core.printer.Printer;
import jd.core.process.writer.SignatureWriter;
import jd.core.util.StringUtil;

public class ConstantValueWriter {
    public static void Write(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, ConstantValue cv) {
        ConstantValueWriter.Write(loader, printer, referenceMap, classFile, cv, (byte)0);
    }

    public static void Write(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, ConstantValue cv, byte constantIntegerType) {
        ConstantPool constants = classFile.getConstantPool();
        block0 : switch (cv.tag) {
            case 6: {
                double d = ((ConstantDouble)cv).bytes;
                if (d == Double.POSITIVE_INFINITY) {
                    ConstantValueWriter.Write(loader, printer, referenceMap, classFile, "java/lang/Double", "POSITIVE_INFINITY", "D");
                    break;
                }
                if (d == Double.NEGATIVE_INFINITY) {
                    ConstantValueWriter.Write(loader, printer, referenceMap, classFile, "java/lang/Double", "NEGATIVE_INFINITY", "D");
                    break;
                }
                if (d == Double.NaN) {
                    ConstantValueWriter.Write(loader, printer, referenceMap, classFile, "java/lang/Double", "NaN", "D");
                    break;
                }
                if (d == Double.MAX_VALUE) {
                    ConstantValueWriter.Write(loader, printer, referenceMap, classFile, "java/lang/Double", "MAX_VALUE", "D");
                    break;
                }
                if (d == Double.MIN_VALUE) {
                    ConstantValueWriter.Write(loader, printer, referenceMap, classFile, "java/lang/Double", "MIN_VALUE", "D");
                    break;
                }
                String value = String.valueOf(d);
                if (value.indexOf(46) == -1) {
                    value = String.valueOf(value) + ".0";
                }
                printer.printNumeric(String.valueOf(value) + 'D');
                break;
            }
            case 4: {
                float value = ((ConstantFloat)cv).bytes;
                if (value == Float.POSITIVE_INFINITY) {
                    ConstantValueWriter.Write(loader, printer, referenceMap, classFile, "java/lang/Float", "POSITIVE_INFINITY", "F");
                    break;
                }
                if (value == Float.NEGATIVE_INFINITY) {
                    ConstantValueWriter.Write(loader, printer, referenceMap, classFile, "java/lang/Float", "NEGATIVE_INFINITY", "F");
                    break;
                }
                if (value == Float.NaN) {
                    ConstantValueWriter.Write(loader, printer, referenceMap, classFile, "java/lang/Float", "NaN", "F");
                    break;
                }
                if (value == Float.MAX_VALUE) {
                    ConstantValueWriter.Write(loader, printer, referenceMap, classFile, "java/lang/Float", "MAX_VALUE", "F");
                    break;
                }
                if (value == Float.MIN_VALUE) {
                    ConstantValueWriter.Write(loader, printer, referenceMap, classFile, "java/lang/Float", "MIN_VALUE", "F");
                    break;
                }
                String s = String.valueOf(value);
                if (s.indexOf(46) == -1) {
                    s = String.valueOf(s) + ".0";
                }
                printer.printNumeric(String.valueOf(s) + 'F');
                break;
            }
            case 3: {
                int value = ((ConstantInteger)cv).bytes;
                switch (constantIntegerType) {
                    case 90: {
                        printer.printKeyword(value == 0 ? "false" : "true");
                        break block0;
                    }
                    case 67: {
                        String escapedString = StringUtil.EscapeCharAndAppendApostrophe((char)value);
                        String scopeInternalName = classFile.getThisClassName();
                        printer.printString(escapedString, scopeInternalName);
                        break block0;
                    }
                }
                if (value == Integer.MIN_VALUE) {
                    ConstantValueWriter.Write(loader, printer, referenceMap, classFile, "java/lang/Integer", "MIN_VALUE", "I");
                    break;
                }
                if (value == Integer.MAX_VALUE) {
                    ConstantValueWriter.Write(loader, printer, referenceMap, classFile, "java/lang/Integer", "MAX_VALUE", "I");
                    break;
                }
                printer.printNumeric(String.valueOf(value));
                break;
            }
            case 5: {
                long value = ((ConstantLong)cv).bytes;
                if (value == Long.MIN_VALUE) {
                    ConstantValueWriter.Write(loader, printer, referenceMap, classFile, "java/lang/Long", "MIN_VALUE", "J");
                    break;
                }
                if (value == Long.MAX_VALUE) {
                    ConstantValueWriter.Write(loader, printer, referenceMap, classFile, "java/lang/Long", "MAX_VALUE", "J");
                    break;
                }
                printer.printNumeric(String.valueOf(String.valueOf(value)) + 'L');
                break;
            }
            case 8: {
                String s = constants.getConstantUtf8(((ConstantString)cv).string_index);
                String escapedString = StringUtil.EscapeStringAndAppendQuotationMark(s);
                String scopeInternalName = classFile.getThisClassName();
                printer.printString(escapedString, scopeInternalName);
            }
        }
    }

    private static void Write(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, String internalTypeName, String name, String descriptor) {
        String className = SignatureWriter.InternalClassNameToClassName(loader, referenceMap, classFile, internalTypeName);
        String scopeInternalName = classFile.getThisClassName();
        printer.printType(internalTypeName, className, scopeInternalName);
        printer.print('.');
        printer.printStaticField(internalTypeName, name, descriptor, scopeInternalName);
    }

    public static void WriteHexa(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, ConstantValue cv) {
        switch (cv.tag) {
            case 3: {
                printer.printNumeric("0x" + Integer.toHexString(((ConstantInteger)cv).bytes).toUpperCase());
                break;
            }
            case 5: {
                printer.printNumeric("0x" + Long.toHexString(((ConstantLong)cv).bytes).toUpperCase());
                break;
            }
            default: {
                ConstantValueWriter.Write(loader, printer, referenceMap, classFile, cv, (byte)0);
            }
        }
    }
}

