/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.platform;

import com.sshtools.daemon.configuration.PlatformConfiguration;
import com.sshtools.daemon.platform.PasswordChangeException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NativeAuthenticationProvider {
    private static Log log = LogFactory.getLog(NativeAuthenticationProvider.class);
    private static Class cls;
    private static NativeAuthenticationProvider instance;

    static {
        try {
            if (ConfigurationLoader.isConfigurationAvailable(PlatformConfiguration.class)) {
                cls = ConfigurationLoader.getExtensionClass(((PlatformConfiguration)ConfigurationLoader.getConfiguration(PlatformConfiguration.class)).getNativeAuthenticationProvider());
            }
        }
        catch (Exception e) {
            log.error("Failed to load native authentication provider", e);
            instance = null;
        }
    }

    public static void setProvider(Class cls) {
        NativeAuthenticationProvider.cls = cls;
    }

    public abstract String getHomeDirectory(String var1) throws IOException;

    public abstract boolean logonUser(String var1, String var2) throws PasswordChangeException, IOException;

    public abstract boolean logonUser(String var1) throws IOException;

    public abstract void logoffUser() throws IOException;

    public abstract boolean changePassword(String var1, String var2, String var3);

    public static NativeAuthenticationProvider getInstance() throws IOException {
        if (instance == null) {
            try {
                if (cls == null) {
                    throw new IOException("There is no authentication provider configured");
                }
                instance = (NativeAuthenticationProvider)cls.newInstance();
            }
            catch (Exception e) {
                throw new IOException("The authentication provider failed to initialize: " + e.getMessage());
            }
        }
        return instance;
    }
}

